/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.NumberParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class IntegerClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Integer.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.BASE)
    public static int valueOf(String input, String idTemplate) {
        return IntegerClassReplacement.parseInt(input, idTemplate);
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.BASE)
    public static int parseInt(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.INTEGER, null));
        }
        if (idTemplate == null) {
            return Integer.parseInt(input);
        }
        try {
            int res = Integer.parseInt(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (RuntimeException e) {
            double h = NumberParsingUtils.parseIntHeuristic(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean equals(Integer caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Integer)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Integer anotherInteger = (Integer)anObject;
            if (caller.equals(anotherInteger)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller, anotherInteger);
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }
}

