/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import shaded.net.sf.jsqlparser.expression.OracleHint;
import shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.select.Distinct;
import shaded.net.sf.jsqlparser.statement.select.Fetch;
import shaded.net.sf.jsqlparser.statement.select.First;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.GroupByElement;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.KSQLWindow;
import shaded.net.sf.jsqlparser.statement.select.Limit;
import shaded.net.sf.jsqlparser.statement.select.Offset;
import shaded.net.sf.jsqlparser.statement.select.OptimizeFor;
import shaded.net.sf.jsqlparser.statement.select.OrderByElement;
import shaded.net.sf.jsqlparser.statement.select.SelectBody;
import shaded.net.sf.jsqlparser.statement.select.SelectItem;
import shaded.net.sf.jsqlparser.statement.select.SelectVisitor;
import shaded.net.sf.jsqlparser.statement.select.Skip;
import shaded.net.sf.jsqlparser.statement.select.Top;
import shaded.net.sf.jsqlparser.statement.select.Wait;

public class PlainSelect
extends ASTNodeAccessImpl
implements SelectBody {
    private Distinct distinct = null;
    private List<SelectItem> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private GroupByElement groupBy;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private OptimizeFor optimizeFor;
    private Skip skip;
    private boolean mySqlHintStraightJoin;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean useBrackets = false;
    private Wait wait;
    private boolean mySqlSqlCalcFoundRows = false;
    private boolean sqlNoCacheFlag = false;
    private String forXmlPath;
    private KSQLWindow ksqlWindow = null;
    private boolean noWait = false;

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public PlainSelect withFromItem(FromItem item) {
        this.setFromItem(item);
        return this;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setIntoTables(List<Table> intoTables) {
        this.intoTables = intoTables;
    }

    public PlainSelect withSelectItems(List<SelectItem> list) {
        this.setSelectItems(list);
        return this;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public PlainSelect addSelectItems(SelectItem ... items) {
        List list = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, items);
        return this.withSelectItems(list);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public PlainSelect addJoins(Join ... joins) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joins);
        return this.withJoins(list);
    }

    public PlainSelect withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public void setOptimizeFor(OptimizeFor optimizeFor) {
        this.optimizeFor = optimizeFor;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public boolean getMySqlHintStraightJoin() {
        return this.mySqlHintStraightJoin;
    }

    public void setMySqlHintStraightJoin(boolean mySqlHintStraightJoin) {
        this.mySqlHintStraightJoin = mySqlHintStraightJoin;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public GroupByElement getGroupBy() {
        return this.groupBy;
    }

    public void setGroupByElement(GroupByElement groupBy) {
        this.groupBy = groupBy;
    }

    public PlainSelect addGroupByColumnReference(Expression expr) {
        this.groupBy = Optional.ofNullable(this.groupBy).orElseGet(GroupByElement::new);
        this.groupBy.addGroupByExpression(expr);
        return this;
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table forUpdateTable) {
        this.forUpdateTable = forUpdateTable;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String forXmlPath) {
        this.forXmlPath = forXmlPath;
    }

    public KSQLWindow getKsqlWindow() {
        return this.ksqlWindow;
    }

    public void setKsqlWindow(KSQLWindow ksqlWindow) {
        this.ksqlWindow = ksqlWindow;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.useBrackets) {
            sql.append("(");
        }
        sql.append("SELECT ");
        if (this.mySqlHintStraightJoin) {
            sql.append("STRAIGHT_JOIN ");
        }
        if (this.oracleHint != null) {
            sql.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            sql.append(this.skip).append(" ");
        }
        if (this.first != null) {
            sql.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            sql.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            sql.append(this.top).append(" ");
        }
        if (this.sqlNoCacheFlag) {
            sql.append("SQL_NO_CACHE").append(" ");
        }
        if (this.mySqlSqlCalcFoundRows) {
            sql.append("SQL_CALC_FOUND_ROWS").append(" ");
        }
        sql.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            sql.append(" INTO ");
            Iterator<Table> iter = this.intoTables.iterator();
            while (iter.hasNext()) {
                sql.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sql.append(", ");
            }
        }
        if (this.fromItem != null) {
            sql.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        sql.append(", ").append(join);
                        continue;
                    }
                    sql.append(" ").append(join);
                }
            }
            if (this.ksqlWindow != null) {
                sql.append(" WINDOW ").append(this.ksqlWindow.toString());
            }
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                sql.append(this.oracleHierarchical.toString());
            }
            if (this.groupBy != null) {
                sql.append(" ").append(this.groupBy.toString());
            }
            if (this.having != null) {
                sql.append(" HAVING ").append(this.having);
            }
            sql.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.limit != null) {
                sql.append(this.limit);
            }
            if (this.offset != null) {
                sql.append(this.offset);
            }
            if (this.fetch != null) {
                sql.append(this.fetch);
            }
            if (this.isForUpdate()) {
                sql.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    sql.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    sql.append(this.wait);
                }
                if (this.isNoWait()) {
                    sql.append(" NOWAIT");
                }
            }
            if (this.optimizeFor != null) {
                sql.append(this.optimizeFor);
            }
        } else if (this.where != null) {
            sql.append(" WHERE ").append(this.where);
        }
        if (this.forXmlPath != null) {
            sql.append(" FOR XML PATH(").append(this.forXmlPath).append(")");
        }
        if (this.useBrackets) {
            sql.append(")");
        }
        return sql.toString();
    }

    public static String orderByToString(List<OrderByElement> orderByElements) {
        return PlainSelect.orderByToString(false, orderByElements);
    }

    public static String orderByToString(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        return PlainSelect.getFormatedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List<?> list, String expression) {
        return PlainSelect.getFormatedList(list, expression, true, false);
    }

    public static String getFormatedList(List<?> list, String expression, boolean useComma, boolean useBrackets) {
        String sql = PlainSelect.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List<?> list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        StringBuilder ans = new StringBuilder();
        String comma = ",";
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                ans.append("(");
            }
            for (int i = 0; i < list.size(); ++i) {
                ans.append(list.get(i)).append(i < list.size() - 1 ? comma + " " : "");
            }
            if (useBrackets) {
                ans.append(")");
            }
        }
        return ans.toString();
    }

    public PlainSelect withMySqlSqlCalcFoundRows(boolean mySqlCalcFoundRows) {
        this.setMySqlSqlCalcFoundRows(mySqlCalcFoundRows);
        return this;
    }

    public PlainSelect withMySqlSqlNoCache(boolean sqlNoCacheFlagSet) {
        this.setMySqlSqlNoCache(sqlNoCacheFlagSet);
        return this;
    }

    public void setMySqlSqlCalcFoundRows(boolean mySqlCalcFoundRows) {
        this.mySqlSqlCalcFoundRows = mySqlCalcFoundRows;
    }

    public void setMySqlSqlNoCache(boolean sqlNoCacheFlagSet) {
        this.sqlNoCacheFlag = sqlNoCacheFlagSet;
    }

    public boolean getMySqlSqlCalcFoundRows() {
        return this.mySqlSqlCalcFoundRows;
    }

    public boolean getMySqlSqlNoCache() {
        return this.sqlNoCacheFlag;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public PlainSelect withDistinct(Distinct distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public PlainSelect withIntoTables(List<Table> intoTables) {
        this.setIntoTables(intoTables);
        return this;
    }

    public PlainSelect withWhere(Expression where) {
        this.setWhere(where);
        return this;
    }

    public PlainSelect withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public PlainSelect withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public PlainSelect withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public PlainSelect withFetch(Fetch fetch) {
        this.setFetch(fetch);
        return this;
    }

    public PlainSelect withOptimizeFor(OptimizeFor optimizeFor) {
        this.setOptimizeFor(optimizeFor);
        return this;
    }

    public PlainSelect withSkip(Skip skip) {
        this.setSkip(skip);
        return this;
    }

    public PlainSelect withMySqlHintStraightJoin(boolean mySqlHintStraightJoin) {
        this.setMySqlHintStraightJoin(mySqlHintStraightJoin);
        return this;
    }

    public PlainSelect withFirst(First first) {
        this.setFirst(first);
        return this;
    }

    public PlainSelect withTop(Top top) {
        this.setTop(top);
        return this;
    }

    public PlainSelect withOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.setOracleHierarchical(oracleHierarchical);
        return this;
    }

    public PlainSelect withOracleHint(OracleHint oracleHint) {
        this.setOracleHint(oracleHint);
        return this;
    }

    public PlainSelect withOracleSiblings(boolean oracleSiblings) {
        this.setOracleSiblings(oracleSiblings);
        return this;
    }

    public PlainSelect withForUpdate(boolean forUpdate) {
        this.setForUpdate(forUpdate);
        return this;
    }

    public PlainSelect withForUpdateTable(Table forUpdateTable) {
        this.setForUpdateTable(forUpdateTable);
        return this;
    }

    public PlainSelect withUseBrackets(boolean useBrackets) {
        this.setUseBrackets(useBrackets);
        return this;
    }

    public PlainSelect withForXmlPath(String forXmlPath) {
        this.setForXmlPath(forXmlPath);
        return this;
    }

    public PlainSelect withKsqlWindow(KSQLWindow ksqlWindow) {
        this.setKsqlWindow(ksqlWindow);
        return this;
    }

    public PlainSelect withNoWait(boolean noWait) {
        this.setNoWait(noWait);
        return this;
    }

    public PlainSelect withHaving(Expression having) {
        this.setHaving(having);
        return this;
    }

    public PlainSelect withWait(Wait wait) {
        this.setWait(wait);
        return this;
    }

    public PlainSelect addSelectItems(Collection<? extends SelectItem> selectItems) {
        List collection = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        collection.addAll(selectItems);
        return this.withSelectItems(collection);
    }

    public PlainSelect addIntoTables(Table ... intoTables) {
        List collection = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        Collections.addAll(collection, intoTables);
        return this.withIntoTables(collection);
    }

    public PlainSelect addIntoTables(Collection<? extends Table> intoTables) {
        List collection = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        collection.addAll(intoTables);
        return this.withIntoTables(collection);
    }

    public PlainSelect addJoins(Collection<? extends Join> joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        collection.addAll(joins);
        return this.withJoins(collection);
    }

    public PlainSelect addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public PlainSelect addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public <E extends FromItem> E getFromItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getFromItem()));
    }

    public <E extends Expression> E getWhere(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhere()));
    }

    public <E extends Expression> E getHaving(Class<E> type) {
        return (E)((Expression)type.cast(this.getHaving()));
    }
}

