/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CollectionType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ArrayParam
extends CollectionParam<List<NamedTypedValue>> {
    public ArrayParam(String name, CollectionType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        return ((List)this.getValue()).stream().map(v -> {
            try {
                return v.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ArrayParam: could not create new instance for value:" + v.getType());
            }
        }).toArray();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = RPCSupportedDataType.ARRAY;
        dto.type.example = ((CollectionType)this.getType()).getTemplate().getDto();
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }

    public ArrayParam copyStructure() {
        return new ArrayParam(this.getName(), (CollectionType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
            List values = dto.innerContent.stream().map(s -> {
                NamedTypedValue v = t.copyStructureWithProperties();
                v.setValueBasedOnDto((ParamDto)s);
                return v;
            }).collect(Collectors.toList());
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        ArrayList values = new ArrayList();
        int length = Array.getLength(instance);
        for (int i = 0; i < length; ++i) {
            Object e = Array.get(instance, i);
            NamedTypedValue copy = t.copyStructureWithProperties();
            copy.setValueBasedOnInstance(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = json;
        if (json instanceof String) {
            instance = this.parseValueWithJson((String)json);
        }
        if (instance == null) {
            this.setValue(null);
            return;
        }
        if (!this.isValidInstance(instance)) {
            throw new RuntimeException("cannot parse Array param " + this.getName() + " with the type " + json.getClass().getName());
        }
        NamedTypedValue t = ((CollectionType)this.getType()).getTemplate();
        ArrayList values = new ArrayList();
        int length = Array.getLength(instance);
        for (int i = 0; i < length; ++i) {
            Object e = Array.get(instance, i);
            NamedTypedValue copy = t.copyStructureWithProperties();
            copy.setValueBasedOnInstanceOrJson(e);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String fullName = ((CollectionType)this.getType()).getTypeNameForInstance();
        ArrayList<String> codes = new ArrayList<String>();
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, fullName, variableName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (this.getValue() == null) {
            return codes;
        }
        int length = ((List)this.getValue()).size();
        CodeJavaGenerator.addCode(codes, "{", indent);
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstance(variableName, CodeJavaGenerator.newArray(((TypeSchema)((CollectionType)this.getType()).getTemplate().getType()).getTypeNameForInstance(), length)), indent + 1);
        int index = 0;
        for (NamedTypedValue e : (List)this.getValue()) {
            String eVar = variableName + "[" + index + "]";
            codes.addAll(e.newInstanceWithJava(false, true, eVar, indent + 1));
            ++index;
        }
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertNull(responseVarName), indent);
            return codes;
        }
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.junitAssertEquals("" + ((List)this.getValue()).size(), CodeJavaGenerator.withLength(responseVarName)), indent);
        if (maxAssertionForDataInCollection == 0) {
            return codes;
        }
        List<Object> nvalue = null;
        nvalue = maxAssertionForDataInCollection > 0 && ((List)this.getValue()).size() > maxAssertionForDataInCollection ? CodeJavaGenerator.randomNInt(((List)this.getValue()).size(), maxAssertionForDataInCollection) : IntStream.range(0, ((List)this.getValue()).size()).boxed().collect(Collectors.toList());
        Iterator iterator = nvalue.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            NamedTypedValue e = (NamedTypedValue)((List)this.getValue()).get(index);
            String eVar = responseVarName + ".get(" + index + ")";
            codes.addAll(e.newAssertionWithJava(indent, eVar, maxAssertionForDataInCollection));
        }
        return codes;
    }

    @Override
    public String getValueAsJavaString() {
        return null;
    }
}

