/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NumericConstraintBase;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.BigDecimalType;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class BigDecimalParam
extends NamedTypedValue<BigDecimalType, BigDecimal>
implements NumericConstraintBase<BigDecimal> {
    private BigDecimal min;
    private BigDecimal max;
    private boolean minInclusive = true;
    private boolean maxInclusive = true;
    private Integer precision;
    private Integer scale;

    public BigDecimalParam(String name, BigDecimalType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public BigDecimalParam(String name, AccessibleSchema accessibleSchema) {
        this(name, new BigDecimalType(), accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        return this.getValue();
    }

    @Override
    public NamedTypedValue<BigDecimalType, BigDecimal> copyStructure() {
        return new BigDecimalParam(this.getName(), (BigDecimalType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void copyProperties(NamedTypedValue copy) {
        super.copyProperties(copy);
        if (copy instanceof BigDecimalParam) {
            ((BigDecimalParam)copy).setMax(this.max);
            ((BigDecimalParam)copy).setMin(this.min);
        }
        this.handleConstraintsInCopy(copy);
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        BigDecimal bd = this.parseValue(dto.stringValue);
        this.setValue(bd);
    }

    private BigDecimal parseValue(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        MathContext mc = null;
        BigDecimal bd = null;
        if (this.getPrecision() == null) {
            bd = new BigDecimal(stringValue);
        } else {
            mc = new MathContext(this.getPrecision());
            bd = new BigDecimal(stringValue, mc);
        }
        if (this.getScale() != null) {
            bd = bd.setScale((int)this.getScale(), RoundingMode.HALF_UP);
        }
        return bd;
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        if (json == null) {
            return;
        }
        BigDecimal bd = this.parseValue(json.toString());
        this.setValue(bd);
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((BigDecimal)instance);
    }

    @Override
    public List<String> newInstanceWithJava(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent) {
        String typeName = ((BigDecimalType)this.getType()).getTypeNameForInstance();
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        String var = CodeJavaGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, variableName, null);
        CodeJavaGenerator.addCode(codes, var, indent);
        if (isNull) {
            return codes;
        }
        CodeJavaGenerator.addCode(codes, "{", indent);
        String mcVar = variableName + "_mc";
        String consParam = this.getValueAsJavaString();
        if (this.getPrecision() != null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.oneLineInstance(true, true, MathContext.class.getName(), mcVar, CodeJavaGenerator.newObjectConsParams(MathContext.class.getName(), this.getPrecision().toString())), indent + 1);
            consParam = consParam + ", " + mcVar;
        }
        CodeJavaGenerator.addCode(codes, CodeJavaGenerator.setInstance(variableName, CodeJavaGenerator.newObjectConsParams(typeName, consParam)), indent + 1);
        if (this.getScale() != null) {
            CodeJavaGenerator.addCode(codes, CodeJavaGenerator.oneLineSetterInstance("setScale", null, variableName, this.getScale() + ", " + RoundingMode.class.getName() + ".HALF_UP"), indent + 1);
        }
        CodeJavaGenerator.addCode(codes, "}", indent);
        return codes;
    }

    @Override
    public List<String> newAssertionWithJava(int indent, String responseVarName, int maxAssertionForDataInCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append(CodeJavaGenerator.getIndent(indent));
        if (this.getValue() == null) {
            sb.append(CodeJavaGenerator.junitAssertNull(responseVarName));
        } else {
            sb.append(CodeJavaGenerator.junitAssertEquals(this.getValueAsJavaString(), responseVarName + ".toString()"));
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        this.handleConstraintsInCopyDto(dto);
        if (this.getValue() != null) {
            dto.stringValue = ((BigDecimal)this.getValue()).toString();
        }
        return dto;
    }

    @Override
    public String getValueAsJavaString() {
        if (this.getValue() == null) {
            return null;
        }
        return "\"" + ((BigDecimal)this.getValue()).toString() + "\"";
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    @Override
    public void setMin(BigDecimal min) {
        if (this.min != null && this.min.compareTo(min) >= 0) {
            return;
        }
        this.min = min;
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public void setMax(BigDecimal max) {
        if (this.max != null && this.max.compareTo(max) <= 0) {
            return;
        }
        this.max = max;
    }

    @Override
    public boolean getMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean inclusive) {
        this.minInclusive = inclusive;
    }

    @Override
    public boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean inclusive) {
        this.maxInclusive = inclusive;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

