/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class IntParam
extends PrimitiveOrWrapperParam<Integer> {
    public IntParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema) {
        super(name, type, fullTypeName, clazz, accessibleSchema);
    }

    public IntParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    public IntParam(String name, AccessibleSchema accessibleSchema) {
        super(name, new PrimitiveOrWrapperType(Integer.TYPE.getSimpleName(), Integer.TYPE.getName(), false, Integer.TYPE), accessibleSchema);
    }

    public IntParam(String name) {
        this(name, null);
    }

    @Override
    public String getValueAsJavaString() {
        if (this.getValue() == null) {
            return null;
        }
        return "" + this.getValue();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.INT : RPCSupportedDataType.P_INT;
        if (this.getValue() != null) {
            dto.stringValue = ((Integer)this.getValue()).toString();
        }
        return dto;
    }

    public IntParam copyStructure() {
        return new IntParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Integer.parseInt(stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as int value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Integer)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Integer;
    }

    @Override
    public String getPrimitiveValue(String responseVarName) {
        if (((PrimitiveOrWrapperType)this.getType()).isWrapper) {
            return responseVarName + ".intValue()";
        }
        return responseVarName;
    }
}

