/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCSupportedDataType;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;

public class ShortParam
extends PrimitiveOrWrapperParam<Short> {
    public ShortParam(String name, String type, String fullTypeName, Class<?> clazz, AccessibleSchema accessibleSchema) {
        super(name, type, fullTypeName, clazz, accessibleSchema);
    }

    public ShortParam(String name, PrimitiveOrWrapperType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public String getValueAsJavaString() {
        if (this.getValue() == null) {
            return null;
        }
        return "" + this.getValue();
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        dto.type.type = ((PrimitiveOrWrapperType)this.getType()).isWrapper ? RPCSupportedDataType.SHORT : RPCSupportedDataType.P_SHORT;
        if (this.getValue() != null) {
            dto.stringValue = ((Short)this.getValue()).toString();
        }
        return dto;
    }

    public ShortParam copyStructure() {
        return new ShortParam(this.getName(), (PrimitiveOrWrapperType)this.getType(), this.accessibleSchema);
    }

    @Override
    public void setValueBasedOnStringValue(String stringValue) {
        try {
            if (stringValue != null) {
                this.setValue(Short.parseShort(stringValue));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR: fail to convert " + stringValue + " as short value");
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        this.setValue((Short)instance);
    }

    @Override
    public boolean isValidInstance(Object instance) {
        return instance instanceof Short;
    }

    @Override
    public String getPrimitiveValue(String responseVarName) {
        if (((PrimitiveOrWrapperType)this.getType()).isWrapper) {
            return responseVarName + ".shortValue()";
        }
        return responseVarName;
    }

    @Override
    public String getCastType() {
        return Short.TYPE.getName();
    }
}

