/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Collection;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public abstract class CollectionsDistanceUtils {
    private static final int SCAN_LIMIT = 50;

    public static void evaluateTaint(Collection c, Object o) {
        String inputString = null;
        if (!(o instanceof String)) {
            return;
        }
        inputString = (String)o;
        if (inputString.equals("EMextraParam123")) {
            for (Object value : c) {
                if (value instanceof String) {
                    ExecutionTracer.addQueryParameter((String)value);
                    continue;
                }
                return;
            }
        }
        if (inputString.equals("x-EMextraHeader123")) {
            for (Object value : c) {
                if (value instanceof String) {
                    ExecutionTracer.addHeader((String)value);
                    continue;
                }
                return;
            }
        }
        if (c.size() <= 16) {
            for (Object value : c) {
                if (!(value instanceof String)) {
                    return;
                }
                if (value.equals("EMextraParam123")) {
                    ExecutionTracer.addQueryParameter(inputString);
                    break;
                }
                if (!value.equals("x-EMextraHeader123")) continue;
                ExecutionTracer.addHeader(inputString);
                break;
            }
        }
        if (ExecutionTracer.isTaintInput(inputString)) {
            int counter = 0;
            for (Object value : c) {
                if (value instanceof String) {
                    ExecutionTracer.addStringSpecialization(inputString, new StringSpecializationInfo(StringSpecialization.CONSTANT, (String)value));
                    if (++counter < 10) continue;
                    return;
                }
                return;
            }
        }
    }

    public static double getHeuristicToContains(Collection c, Object o) {
        return CollectionsDistanceUtils.getHeuristicToContains(c, o, 50);
    }

    public static double getHeuristicToContainsAll(Collection c, Collection other) {
        return CollectionsDistanceUtils.getHeuristicToContainsAll(c, other, 50);
    }

    public static double getHeuristicToContainsAny(Collection c, Collection other) {
        return CollectionsDistanceUtils.getHeuristicToContainsAny(c, other, 50);
    }

    public static double getHeuristicToContainsAny(Collection c, Collection other, int limit) {
        Objects.requireNonNull(c);
        double base = 0.016666666666666666;
        if (c.isEmpty()) {
            return base;
        }
        if (other == null) {
            return base * 2.0;
        }
        if (other.isEmpty()) {
            return base * 3.0;
        }
        double max = 0.05;
        for (Object obj : other) {
            if ((max = Math.max(max, CollectionsDistanceUtils.getHeuristicToContains(c, obj, limit))) != 1.0) continue;
            return 1.0;
        }
        return max;
    }

    public static double getHeuristicToContainsAll(Collection c, Collection other, int limit) {
        Objects.requireNonNull(c);
        boolean result = c.containsAll(other);
        if (result) {
            return 1.0;
        }
        if (c.isEmpty()) {
            return 0.05;
        }
        assert (c != null && other != null && !other.isEmpty());
        double sum = 0.0;
        for (Object x : other.toArray()) {
            sum += CollectionsDistanceUtils.getHeuristicToContains(c, x, limit);
        }
        assert ((sum /= (double)other.size() + Math.log(other.size())) >= 0.0 && sum <= 1.0);
        double h = DistanceHelper.scaleHeuristicWithBase(sum, 0.05);
        return h;
    }

    public static double getHeuristicToContains(Collection c, Object o, int limit) {
        Objects.requireNonNull(c);
        boolean result = c.contains(o);
        if (result) {
            return 1.0;
        }
        if (c.isEmpty()) {
            return 0.05;
        }
        if (o == null) {
            return 0.1;
        }
        int counter = 0;
        double base = 0.1;
        double max = 0.1;
        for (Object value : c) {
            double h;
            double distance;
            if (counter == limit) break;
            ++counter;
            if (value == null || (distance = DistanceHelper.getDistance(o, value)) == Double.MAX_VALUE || !((h = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance)) > max)) continue;
            max = h;
        }
        assert (max < 1.0);
        return max;
    }
}

