/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.objectweb.asm.Type;

public class ReplacementUtils {
    public static String getDescriptor(Method m, int skipFirsts, int skipLast) {
        return ReplacementUtils.getDescriptor(m, skipFirsts, skipLast, Type.getDescriptor(m.getReturnType()), false);
    }

    public static String getDescriptor(Method m, int skipFirsts, int skipLast, boolean applyThirdPartyCast) {
        Class<?> casted;
        Replacement r;
        String returnType = Type.getDescriptor(m.getReturnType());
        if (applyThirdPartyCast && !(r = m.getAnnotation(Replacement.class)).castTo().isEmpty() && !r.replacingConstructor() && (casted = ReplacementUtils.loadClass(r.castTo())) != null) {
            returnType = Type.getDescriptor(casted);
        }
        return ReplacementUtils.getDescriptor(m, skipFirsts, skipLast, returnType, applyThirdPartyCast);
    }

    private static String getDescriptor(Method m, int skipFirsts, int skipLast, String returnType, boolean applyThirdPartyCast) {
        List<Class<?>> types = ReplacementUtils.getParameterTypes(m, skipFirsts, skipLast, applyThirdPartyCast);
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        types.stream().forEach(t -> buf.append(Type.getDescriptor(t)));
        buf.append(')');
        buf.append(returnType);
        return buf.toString();
    }

    public static List<Class<?>> getParameterTypes(Method m, int skipFirsts, int skipLast, boolean applyThirdPartyCast) {
        Class<?>[] parameters = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        int start = skipFirsts;
        int end = parameters.length - skipLast;
        ArrayList types = new ArrayList(end - start + 1);
        for (int i = start; i < end; ++i) {
            Class<?> casted;
            Class<?> t = parameters[i];
            if (applyThirdPartyCast && (casted = ReplacementUtils.getCastedToThirdParty(annotations[i])) != null) {
                t = casted;
            }
            types.add(t);
        }
        return types;
    }

    public static Class<?> getCastedToThirdParty(Annotation[] annotations) {
        ThirdPartyCast thirdPartyCast = Arrays.stream(annotations).filter(a -> a instanceof ThirdPartyCast).findFirst().orElse(null);
        if (thirdPartyCast != null) {
            return ReplacementUtils.loadClass(thirdPartyCast.actualType());
        }
        return null;
    }

    private static Class<?> loadClass(String className) {
        try {
            return ReplacementUtils.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            SimpleLogger.error("Cannot load third-party cast class: " + className, e);
            return null;
        }
    }

    public static Optional<Method> chooseMethodFromCandidateReplacement(boolean isInSUT, String name, String desc, List<MethodReplacementClass> candidateClasses, boolean requirePure, String contextClassName) {
        Optional<Method> r = candidateClasses.stream().filter(i -> {
            try {
                i.getClass().getDeclaredMethods();
                return true;
            }
            catch (Throwable t) {
                String msg = "FAILED TO LOAD METHOD DECLARATIONS FOR: " + i.getClass().getName();
                SimpleLogger.error(msg);
                return false;
            }
        }).flatMap(i -> Stream.of(i.getClass().getDeclaredMethods())).filter(m -> m.getDeclaredAnnotation(Replacement.class) != null).filter(m -> {
            boolean isConstructor;
            Replacement br = m.getAnnotation(Replacement.class);
            if (isInSUT && br.usageFilter() == UsageFilter.ONLY_THIRD_PARTY) {
                return false;
            }
            if (!isInSUT && br.usageFilter() == UsageFilter.ONLY_SUT) {
                String ctx = ClassName.get(contextClassName).getFullNameWithDots();
                if (br.extraPackagesToConsider().length == 0 || Arrays.stream(br.packagesToSkip()).noneMatch(it -> ctx.startsWith((String)it))) {
                    return false;
                }
            }
            if (requirePure && !br.isPure()) {
                return false;
            }
            String ctg = br.category().toString();
            String categories = System.getProperty("evomaster.javaagent.replacement_categories");
            if (categories == null || !Arrays.stream(categories.split(",")).anyMatch(c -> c.equals(ctg))) {
                return false;
            }
            if (br.packagesToSkip().length > 0 && contextClassName != null) {
                String ctx = ClassName.get(contextClassName).getFullNameWithDots();
                if (Arrays.stream(br.packagesToSkip()).anyMatch(it -> ctx.startsWith((String)it) || it.startsWith(".") && ctx.contains((CharSequence)it))) {
                    return false;
                }
            }
            if (isConstructor = name.equals("<init>")) {
                int skipFirst = 0;
                int skipLast = br.type() == ReplacementType.TRACKER ? 0 : 1;
                return desc.equals(ReplacementUtils.getDescriptor(m, skipFirst, skipLast, true));
            }
            if (!m.getName().equals(name)) {
                return false;
            }
            int skipFirst = br.replacingStatic() ? 0 : 1;
            int skipLast = br.type() == ReplacementType.TRACKER ? 0 : 1;
            return desc.equals(ReplacementUtils.getDescriptor(m, skipFirst, skipLast, true));
        }).findAny();
        return r;
    }
}

