/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ReplacementUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;

public abstract class ThirdPartyMethodReplacementClass
implements MethodReplacementClass {
    private Class<?> targetClass;
    private boolean triedToLoad = false;
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private final Map<String, Constructor> constructors = new HashMap<String, Constructor>();

    protected ThirdPartyMethodReplacementClass() {
    }

    private void initMethods() {
        Class<?> subclass = this.getClass();
        for (Method m : subclass.getDeclaredMethods()) {
            Method targetMethod;
            Replacement r = m.getAnnotation(Replacement.class);
            if (r == null || r.id().isEmpty() || r.replacingConstructor()) continue;
            Class<?>[] inputs = m.getParameterTypes();
            Annotation[][] annotations = m.getParameterAnnotations();
            int start = 0;
            if (!r.replacingStatic()) {
                start = 1;
            }
            int end = inputs.length - 1;
            if (r.type() == ReplacementType.TRACKER) {
                end = inputs.length;
            }
            Class<?>[] reducedInputs = Arrays.copyOfRange(inputs, start, end);
            for (int i = start; i < end; ++i) {
                Class<?> klazz;
                if (annotations[i].length <= 0 || (klazz = ReplacementUtils.getCastedToThirdParty(annotations[i])) == null) continue;
                reducedInputs[i - start] = klazz;
            }
            try {
                targetMethod = this.getTargetClass().getMethod(m.getName(), reducedInputs);
            }
            catch (NoSuchMethodException e) {
                try {
                    targetMethod = this.targetClass.getDeclaredMethod(m.getName(), reducedInputs);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("BUG in EvoMaster: " + e);
                }
            }
            String id = r.id();
            if (this.methods.containsKey(id)) {
                throw new IllegalStateException("Non-unique id: " + id);
            }
            this.methods.put(id, targetMethod);
        }
    }

    private void initConstructors() {
        Class<?> subclass = this.getClass();
        for (Method m : subclass.getDeclaredMethods()) {
            Replacement r = m.getAnnotation(Replacement.class);
            if (r == null || r.id().isEmpty() || !r.replacingConstructor()) continue;
            Class<?>[] inputs = m.getParameterTypes();
            int start = 0;
            int end = inputs.length - 1;
            if (r.type() == ReplacementType.TRACKER) {
                end = inputs.length;
            }
            Class<?>[] reducedInputs = Arrays.copyOfRange(inputs, start, end);
            Constructor<?> targetConstructor = null;
            try {
                targetConstructor = this.targetClass.getConstructor(reducedInputs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("BUG in EvoMaster: " + e);
            }
            String id = r.id();
            if (this.constructors.containsKey(id)) {
                throw new IllegalStateException("Non-unique id: " + id);
            }
            this.constructors.put(id, targetConstructor);
        }
    }

    protected abstract String getNameOfThirdPartyTargetClass();

    public static Method getOriginal(ThirdPartyMethodReplacementClass singleton, String id, Object obj) {
        Method original;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        Objects.requireNonNull(obj);
        if (singleton.getTargetClass() == null) {
            singleton.retryLoadingClass(obj.getClass().getClassLoader());
        }
        if (singleton.methods.isEmpty()) {
            singleton.initMethods();
        }
        if ((original = singleton.methods.get(id)) == null) {
            throw new IllegalArgumentException("No method exists with id: " + id);
        }
        return original;
    }

    public static Constructor getOriginalConstructor(ThirdPartyMethodReplacementClass singleton, String id) {
        Constructor original;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        if (singleton.getTargetClass() == null) {
            String callerName = ExecutionTracer.getLastCallerClass();
            if (callerName == null) {
                throw new IllegalStateException("No access to last caller class");
            }
            ClassLoader loader = UnitsInfoRecorder.getInstance().getClassLoaders(callerName).get(0);
            singleton.retryLoadingClass(loader);
        }
        if (singleton.constructors.isEmpty()) {
            singleton.initConstructors();
        }
        if ((original = singleton.constructors.get(id)) == null) {
            throw new IllegalArgumentException("No constructor exists with id: " + id);
        }
        return original;
    }

    private void retryLoadingClass(ClassLoader classLoader) {
        try {
            this.targetClass = classLoader.loadClass(this.getTargetClassName());
            this.triedToLoad = true;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ISSUE IN EVOMASTER: classloader problems when dealing with: " + this.getTargetClassName());
        }
    }

    @Override
    public Class<?> getTargetClass() {
        if (this.targetClass != null) {
            return this.targetClass;
        }
        if (!this.triedToLoad) {
            this.triedToLoad = true;
            try {
                this.targetClass = Class.forName(this.getTargetClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.targetClass;
    }

    @Override
    public final String getTargetClassName() {
        return this.getNameOfThirdPartyTargetClass();
    }
}

