/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.CollectionsDistanceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.heuristic.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class MapClassReplacement
implements MethodReplacementClass {
    private static final Method linearCostContainsKey;
    private static final Map<Class<? extends Map>, Boolean> cacheIsLinearCost;

    private static boolean hasLinearCost(Class<? extends Map> klass) {
        Boolean isLinear = cacheIsLinearCost.get(klass);
        if (isLinear == null) {
            try {
                Method m = klass.getMethod("containsKey", Object.class);
                isLinear = m.equals(linearCostContainsKey);
            }
            catch (NoSuchMethodException e) {
                isLinear = false;
            }
            cacheIsLinearCost.put(klass, isLinear);
            return isLinear;
        }
        return isLinear;
    }

    @Override
    public Class<?> getTargetClass() {
        return Map.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0)
    public static boolean isEmpty(Map caller, String idTemplate) {
        Objects.requireNonNull(caller);
        boolean result = caller.isEmpty();
        if (idTemplate == null) {
            return result;
        }
        int len = caller.size();
        Truthness t = TruthnessUtils.getTruthnessToEmpty(len);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean containsKey(Map c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        if (c instanceof IdentityHashMap) {
            return c.containsKey(o);
        }
        Set keyCollection = c.keySet();
        CollectionsDistanceUtils.evaluateTaint(keyCollection, o);
        if (!keyCollection.getClass().getName().startsWith("java.util")) {
            return c.containsKey(o);
        }
        boolean result = keyCollection.contains(o);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(keyCollection, o);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.OBJECT, category=ReplacementCategory.EXT_0)
    public static Object get(Map map, Object key, String idTemplate) {
        Objects.requireNonNull(map);
        if (!(map instanceof IdentityHashMap)) {
            try {
                if (!MapClassReplacement.hasLinearCost(map.getClass())) {
                    MapClassReplacement.containsKey(map, key, idTemplate);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map.get(key);
    }

    @Replacement(type=ReplacementType.OBJECT, category=ReplacementCategory.EXT_0)
    public static Object getOrDefault(Map map, Object key, Object defaultValue, String idTemplate) {
        MapClassReplacement.get(map, key, idTemplate);
        return map.getOrDefault(key, defaultValue);
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0)
    public static boolean containsValue(Map c, Object o, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(c);
        if (idTemplate == null || c instanceof IdentityHashMap) {
            return c.containsValue(o);
        }
        Collection data = c.values();
        CollectionsDistanceUtils.evaluateTaint(data, o);
        boolean result = data.contains(o);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double h = CollectionsDistanceUtils.getHeuristicToContains(data, o);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0, isPure=false)
    public static boolean remove(Map map, Object key, Object value, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(map);
        CollectionsDistanceUtils.evaluateTaint(map.keySet(), key);
        Object curValue = map.get(key);
        if (curValue != null) {
            CollectionsDistanceUtils.evaluateTaint(Arrays.asList(curValue), value);
        }
        boolean result = map.remove(key, value);
        if (idTemplate == null) {
            return result;
        }
        if (result) {
            t = new Truthness(1.0, 0.1);
        } else {
            double hb = CollectionsDistanceUtils.getHeuristicToContains(map.keySet(), key) / 2.0;
            double dv = DistanceHelper.getDistance(value, curValue);
            double hv = DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, dv) / 2.0;
            double h = hb + hv;
            assert (h >= 0.1 && h <= 1.0);
            t = new Truthness(h, 1.0);
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return result;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.EXT_0, isPure=false)
    public static boolean replace(Map map, Object key, Object oldValue, Object newValue, String idTemplate) {
        Objects.requireNonNull(map);
        boolean removed = MapClassReplacement.remove(map, key, oldValue, idTemplate);
        if (removed) {
            map.put(key, newValue);
        }
        return removed;
    }

    static {
        cacheIsLinearCost = new ConcurrentHashMap<Class<? extends Map>, Boolean>();
        try {
            linearCostContainsKey = AbstractMap.class.getMethod("containsKey", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

