/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.regex.Matcher;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.PatternMatchingHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.RegexSharedUtils;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.shared.TaintType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class MatcherClassReplacement
implements MethodReplacementClass {
    private static Field textField = null;

    @Override
    public Class<?> getTargetClass() {
        return Matcher.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean matches(Matcher caller, String idTemplate) {
        if (caller == null) {
            caller.matches();
        }
        String text = MatcherClassReplacement.getText(caller);
        String pattern = caller.pattern().toString();
        boolean patternMatchesResult = PatternMatchingHelper.matches(pattern, text, idTemplate);
        TaintType taintType = ExecutionTracer.getTaintType(text);
        if (taintType.isTainted()) {
            String regex = caller.pattern().toString();
            ExecutionTracer.addStringSpecialization(text, new StringSpecializationInfo(StringSpecialization.REGEX_WHOLE, regex, taintType));
        }
        boolean matcherMatchesResults = caller.matches();
        assert (patternMatchesResult == matcherMatchesResults);
        return matcherMatchesResults;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean find(Matcher caller, String idTemplate) {
        int end;
        Objects.requireNonNull(caller);
        String input = MatcherClassReplacement.getText(caller);
        String regex = caller.pattern().toString();
        try {
            end = caller.end();
        }
        catch (IllegalStateException ex) {
            end = 0;
        }
        String substring = input.substring(end);
        TaintType taintType = ExecutionTracer.getTaintType(substring);
        if (taintType.isTainted()) {
            ExecutionTracer.addStringSpecialization(substring, new StringSpecializationInfo(StringSpecialization.REGEX_PARTIAL, regex, taintType));
        }
        String anyPositionRegexMatch = RegexSharedUtils.handlePartialMatch(regex);
        boolean patternMatchResult = PatternMatchingHelper.matches(anyPositionRegexMatch, substring, idTemplate);
        boolean matcherFindResult = caller.find();
        assert (patternMatchResult == matcherFindResult);
        return matcherFindResult;
    }

    private static String getText(Matcher match) {
        try {
            return ((CharSequence)textField.get(match)).toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            textField = Matcher.class.getDeclaredField("text");
            textField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

