/*
 * Decompiled with CFR 0.152.
 */
package shaded.dk.brics.automaton;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import shaded.dk.brics.automaton.Transition;
import shaded.dk.brics.automaton.TransitionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements Serializable,
Comparable<State> {
    static final long serialVersionUID = 30001L;
    boolean accept;
    Set<Transition> transitions;
    int number;
    int id;
    static int next_id;

    public State() {
        this.resetTransitions();
        this.id = next_id++;
    }

    final void resetTransitions() {
        this.transitions = new HashSet<Transition>();
    }

    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public void setAccept(boolean bl) {
        this.accept = bl;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public State step(char c) {
        for (Transition transition : this.transitions) {
            if (transition.min > c || c > transition.max) continue;
            return transition.to;
        }
        return null;
    }

    public void step(char c, Collection<State> collection) {
        for (Transition transition : this.transitions) {
            if (transition.min > c || c > transition.max) continue;
            collection.add(transition.to);
        }
    }

    void addEpsilon(State state) {
        if (state.accept) {
            this.accept = true;
        }
        for (Transition transition : state.transitions) {
            this.transitions.add(transition);
        }
    }

    Transition[] getSortedTransitionArray(boolean bl) {
        Transition[] transitionArray = this.transitions.toArray(new Transition[this.transitions.size()]);
        Arrays.sort(transitionArray, new TransitionComparator(bl));
        return transitionArray;
    }

    public List<Transition> getSortedTransitions(boolean bl) {
        return Arrays.asList(this.getSortedTransitionArray(bl));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state ").append(this.number);
        if (this.accept) {
            stringBuilder.append(" [accept]");
        } else {
            stringBuilder.append(" [reject]");
        }
        stringBuilder.append(":\n");
        for (Transition transition : this.transitions) {
            stringBuilder.append("  ").append(transition.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(State state) {
        return state.id - this.id;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

