/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.execution.MongoExecutionDto;
import org.evomaster.client.java.controller.api.dto.database.execution.MongoFailedQuery;
import org.evomaster.client.java.controller.internal.db.MongoOperationDistance;
import org.evomaster.client.java.controller.mongo.MongoHeuristicsCalculator;
import org.evomaster.client.java.controller.mongo.MongoOperation;
import org.evomaster.client.java.instrumentation.MongoCollectionInfo;
import org.evomaster.client.java.instrumentation.MongoInfo;

public class MongoHandler {
    private final List<MongoInfo> operations;
    private volatile boolean extractMongoExecution = true;
    private final List<MongoOperationDistance> distances = new ArrayList<MongoOperationDistance>();
    private volatile boolean calculateHeuristics = true;
    private final List<MongoOperation> failedQueries;
    private final Map<String, String> collectionInfo;

    public MongoHandler() {
        this.operations = new ArrayList<MongoInfo>();
        this.failedQueries = new ArrayList<MongoOperation>();
        this.collectionInfo = new HashMap<String, String>();
    }

    public void reset() {
        this.operations.clear();
        this.distances.clear();
        this.failedQueries.clear();
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractMongoExecution() {
        return this.extractMongoExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractMongoExecution(boolean extractMongoExecution) {
        this.extractMongoExecution = extractMongoExecution;
    }

    public void handle(MongoInfo info) {
        if (this.extractMongoExecution) {
            this.operations.add(info);
        }
    }

    public void handle(MongoCollectionInfo info) {
        if (this.extractMongoExecution) {
            this.collectionInfo.put(info.getCollectionName(), info.getDocumentsType());
        }
    }

    public List<MongoOperationDistance> getDistances() {
        this.operations.stream().filter(info -> info.getQuery() != null).forEach(mongoInfo -> {
            double dist;
            try {
                dist = this.computeDistance((MongoInfo)mongoInfo);
            }
            catch (Exception e) {
                dist = Double.MAX_VALUE;
            }
            this.distances.add(new MongoOperationDistance(mongoInfo.getQuery(), dist));
        });
        this.operations.clear();
        return this.distances;
    }

    public MongoExecutionDto getExecutionDto() {
        MongoExecutionDto dto = new MongoExecutionDto();
        dto.failedQueries = this.failedQueries.stream().map(this::extractRelevantInfo).collect(Collectors.toList());
        return dto;
    }

    private double computeDistance(MongoInfo info) {
        boolean collectionIsEmpty;
        Iterable<?> documents = info.getDocuments();
        boolean bl = collectionIsEmpty = !documents.iterator().hasNext();
        if (collectionIsEmpty) {
            this.failedQueries.add(new MongoOperation(info.getCollectionName(), info.getQuery(), info.getDatabaseName(), info.getDocumentsType()));
        }
        MongoHeuristicsCalculator calculator = new MongoHeuristicsCalculator();
        double min = Double.MAX_VALUE;
        for (Object doc : documents) {
            double dist = calculator.computeExpression(info.getQuery(), doc);
            if (dist == 0.0) {
                return 0.0;
            }
            if (!(dist < min)) continue;
            min = dist;
        }
        return min;
    }

    private MongoFailedQuery extractRelevantInfo(MongoOperation operation) {
        String documentsType = this.collectionTypeIsRegistered(operation.getCollectionName()) ? this.collectionInfo.get(operation.getCollectionName()) : operation.getDocumentsType();
        return new MongoFailedQuery(operation.getDatabaseName(), operation.getCollectionName(), documentsType);
    }

    private boolean collectionTypeIsRegistered(String collectionName) {
        return this.collectionInfo.containsKey(collectionName);
    }
}

