/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.mongo.QueryParser;
import org.evomaster.client.java.controller.mongo.operations.AllOperation;
import org.evomaster.client.java.controller.mongo.operations.AndOperation;
import org.evomaster.client.java.controller.mongo.operations.ComparisonOperation;
import org.evomaster.client.java.controller.mongo.operations.ElemMatchOperation;
import org.evomaster.client.java.controller.mongo.operations.EqualsOperation;
import org.evomaster.client.java.controller.mongo.operations.ExistsOperation;
import org.evomaster.client.java.controller.mongo.operations.GreaterThanEqualsOperation;
import org.evomaster.client.java.controller.mongo.operations.GreaterThanOperation;
import org.evomaster.client.java.controller.mongo.operations.InOperation;
import org.evomaster.client.java.controller.mongo.operations.LessThanEqualsOperation;
import org.evomaster.client.java.controller.mongo.operations.LessThanOperation;
import org.evomaster.client.java.controller.mongo.operations.ModOperation;
import org.evomaster.client.java.controller.mongo.operations.NorOperation;
import org.evomaster.client.java.controller.mongo.operations.NotEqualsOperation;
import org.evomaster.client.java.controller.mongo.operations.NotInOperation;
import org.evomaster.client.java.controller.mongo.operations.NotOperation;
import org.evomaster.client.java.controller.mongo.operations.OrOperation;
import org.evomaster.client.java.controller.mongo.operations.QueryOperation;
import org.evomaster.client.java.controller.mongo.operations.SizeOperation;
import org.evomaster.client.java.controller.mongo.operations.TypeOperation;
import org.evomaster.client.java.controller.mongo.operations.synthetic.InvertedAllOperation;
import org.evomaster.client.java.controller.mongo.operations.synthetic.InvertedModOperation;
import org.evomaster.client.java.controller.mongo.operations.synthetic.InvertedSizeOperation;
import org.evomaster.client.java.controller.mongo.operations.synthetic.InvertedTypeOperation;
import org.evomaster.client.java.controller.mongo.utils.BsonHelper;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;

public class MongoHeuristicsCalculator {
    public static final double MIN_DISTANCE_TO_TRUE_VALUE = 1.0;

    public double computeExpression(Object query, Object doc) {
        QueryOperation operation = this.getOperation(query);
        return this.calculateDistance(operation, doc);
    }

    private QueryOperation getOperation(Object query) {
        return new QueryParser().parse(query);
    }

    private double calculateDistance(QueryOperation operation, Object doc) {
        if (operation instanceof EqualsOperation) {
            return this.calculateDistanceForEquals((EqualsOperation)operation, doc);
        }
        if (operation instanceof NotEqualsOperation) {
            return this.calculateDistanceForNotEquals((NotEqualsOperation)operation, doc);
        }
        if (operation instanceof GreaterThanOperation) {
            return this.calculateDistanceForGreaterThan((GreaterThanOperation)operation, doc);
        }
        if (operation instanceof GreaterThanEqualsOperation) {
            return this.calculateDistanceForGreaterEqualsThan((GreaterThanEqualsOperation)operation, doc);
        }
        if (operation instanceof LessThanOperation) {
            return this.calculateDistanceForLessThan((LessThanOperation)operation, doc);
        }
        if (operation instanceof LessThanEqualsOperation) {
            return this.calculateDistanceForLessEqualsThan((LessThanEqualsOperation)operation, doc);
        }
        if (operation instanceof AndOperation) {
            return this.calculateDistanceForAnd((AndOperation)operation, doc);
        }
        if (operation instanceof OrOperation) {
            return this.calculateDistanceForOr((OrOperation)operation, doc);
        }
        if (operation instanceof NorOperation) {
            return this.calculateDistanceForNor((NorOperation)operation, doc);
        }
        if (operation instanceof InOperation) {
            return this.calculateDistanceForIn((InOperation)operation, doc);
        }
        if (operation instanceof NotInOperation) {
            return this.calculateDistanceForNotIn((NotInOperation)operation, doc);
        }
        if (operation instanceof AllOperation) {
            return this.calculateDistanceForAll((AllOperation)operation, doc);
        }
        if (operation instanceof InvertedAllOperation) {
            return this.calculateDistanceForInvertedAll((InvertedAllOperation)operation, doc);
        }
        if (operation instanceof SizeOperation) {
            return this.calculateDistanceForSize((SizeOperation)operation, doc);
        }
        if (operation instanceof InvertedSizeOperation) {
            return this.calculateDistanceForInvertedSize((InvertedSizeOperation)operation, doc);
        }
        if (operation instanceof ElemMatchOperation) {
            return this.calculateDistanceForElemMatch((ElemMatchOperation)operation, doc);
        }
        if (operation instanceof ExistsOperation) {
            return this.calculateDistanceForExists((ExistsOperation)operation, doc);
        }
        if (operation instanceof ModOperation) {
            return this.calculateDistanceForMod((ModOperation)operation, doc);
        }
        if (operation instanceof InvertedModOperation) {
            return this.calculateDistanceForInvertedMod((InvertedModOperation)operation, doc);
        }
        if (operation instanceof NotOperation) {
            return this.calculateDistanceForNot((NotOperation)operation, doc);
        }
        if (operation instanceof TypeOperation) {
            return this.calculateDistanceForType((TypeOperation)operation, doc);
        }
        if (operation instanceof InvertedTypeOperation) {
            return this.calculateDistanceForInvertedType((InvertedTypeOperation)operation, doc);
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForEquals(EqualsOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, Math::abs);
    }

    private double calculateDistanceForNotEquals(NotEqualsOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, dif -> dif != 0.0 ? 0.0 : 1.0);
    }

    private double calculateDistanceForGreaterThan(GreaterThanOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, dif -> dif > 0.0 ? 0.0 : 1.0 - dif);
    }

    private double calculateDistanceForGreaterEqualsThan(GreaterThanEqualsOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, dif -> dif >= 0.0 ? 0.0 : -dif);
    }

    private double calculateDistanceForLessThan(LessThanOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, dif -> dif < 0.0 ? 0.0 : 1.0 + dif);
    }

    private double calculateDistanceForLessEqualsThan(LessThanEqualsOperation<?> operation, Object doc) {
        return this.calculateDistanceForComparisonOperation(operation, doc, dif -> dif <= 0.0 ? 0.0 : dif);
    }

    private double calculateDistanceForComparisonOperation(ComparisonOperation<?> operation, Object doc, DoubleUnaryOperator calculateDistance) {
        Object expectedValue = operation.getValue();
        String field = operation.getFieldName();
        if (!BsonHelper.documentContainsField(doc, field).booleanValue()) {
            return operation instanceof NotEqualsOperation ? 0.0 : Double.MAX_VALUE;
        }
        Object actualValue = BsonHelper.getValue(doc, field);
        double dif = this.compareValues(actualValue, expectedValue);
        return calculateDistance.applyAsDouble(dif);
    }

    private double calculateDistanceForOr(OrOperation operation, Object doc) {
        return operation.getConditions().stream().mapToDouble(condition -> this.calculateDistance((QueryOperation)condition, doc)).min().getAsDouble();
    }

    private double calculateDistanceForAnd(AndOperation operation, Object doc) {
        return operation.getConditions().stream().mapToDouble(condition -> this.calculateDistance((QueryOperation)condition, doc)).sum();
    }

    private double calculateDistanceForIn(InOperation<?> operation, Object doc) {
        List<?> expectedValues = operation.getValues();
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof List) {
            return expectedValues.stream().mapToDouble(value -> this.distanceToClosestElem((List)actualValue, value)).min().getAsDouble();
        }
        return this.distanceToClosestElem(expectedValues, actualValue);
    }

    private double calculateDistanceForNotIn(NotInOperation<?> operation, Object doc) {
        List<?> unexpectedValues = operation.getValues();
        if (!BsonHelper.documentContainsField(doc, operation.getFieldName()).booleanValue()) {
            return 0.0;
        }
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        boolean hasUnexpectedElement = unexpectedValues.stream().anyMatch(value -> this.compareValues(actualValue, value) == 0.0);
        return hasUnexpectedElement ? 1.0 : 0.0;
    }

    private double calculateDistanceForAll(AllOperation<?> operation, Object doc) {
        List<?> expectedValues = operation.getValues();
        Object actualValues = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValues instanceof Iterable) {
            return expectedValues.stream().mapToDouble(value -> this.distanceToClosestElem((List)actualValues, value)).sum();
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForInvertedAll(InvertedAllOperation<?> operation, Object doc) {
        List<?> expectedValues = operation.getValues();
        Object actualValues = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValues instanceof List) {
            boolean containsAll = ((List)actualValues).containsAll(expectedValues);
            return containsAll ? 1.0 : 0.0;
        }
        return 0.0;
    }

    private double calculateDistanceForSize(SizeOperation operation, Object doc) {
        Integer expectedSize = operation.getValue();
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof List) {
            Integer actualSize = ((List)actualValue).size();
            return Math.abs(actualSize - expectedSize);
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForInvertedSize(InvertedSizeOperation operation, Object doc) {
        Integer expectedSize = operation.getValue();
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof List) {
            Integer actualSize = ((List)actualValue).size();
            return actualSize.equals(expectedSize) ? 1.0 : 0.0;
        }
        return 0.0;
    }

    private double calculateDistanceForElemMatch(ElemMatchOperation operation, Object doc) {
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof List) {
            List val = (List)actualValue;
            return val.stream().mapToDouble(elem -> {
                Object newDoc = BsonHelper.newDocument(doc);
                BsonHelper.appendToDocument(newDoc, operation.getFieldName(), elem);
                return this.calculateDistance(operation.getCondition(), newDoc);
            }).min().getAsDouble();
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForExists(ExistsOperation operation, Object doc) {
        String expectedField = operation.getFieldName();
        Set<String> actualFields = BsonHelper.documentKeys(doc);
        if (operation.getBoolean().booleanValue()) {
            return actualFields.stream().mapToDouble(field -> DistanceHelper.getLeftAlignmentDistance(field, expectedField)).min().getAsDouble();
        }
        return BsonHelper.documentContainsField(doc, expectedField) == false ? 0.0 : 1.0;
    }

    private double calculateDistanceForMod(ModOperation operation, Object doc) {
        Long expectedRemainder = operation.getRemainder();
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof Integer) {
            long actualRemainder = (long)((Integer)actualValue).intValue() % operation.getDivisor();
            return Math.abs(actualRemainder - expectedRemainder);
        }
        return Double.MAX_VALUE;
    }

    private double calculateDistanceForInvertedMod(InvertedModOperation operation, Object doc) {
        Long expectedRemainder = operation.getRemainder();
        Object actualValue = BsonHelper.getValue(doc, operation.getFieldName());
        if (actualValue instanceof Integer) {
            long actualRemainder = (long)((Integer)actualValue).intValue() % operation.getDivisor();
            return actualRemainder == expectedRemainder ? 1.0 : 0.0;
        }
        return 0.0;
    }

    private double calculateDistanceForNot(NotOperation operation, Object doc) {
        String fieldName = operation.getFieldName();
        if (BsonHelper.getValue(doc, fieldName) == null) {
            return 0.0;
        }
        QueryOperation condition = operation.getCondition();
        QueryOperation invertedOperation = this.invertOperation(condition);
        return this.calculateDistance(invertedOperation, doc);
    }

    private double calculateDistanceForNor(NorOperation operation, Object doc) {
        return operation.getConditions().stream().mapToDouble(condition -> this.calculateDistance(this.invertOperation((QueryOperation)condition), doc)).sum();
    }

    private double calculateDistanceForType(TypeOperation operation, Object doc) {
        String field = operation.getFieldName();
        String expectedType = BsonHelper.getType(operation.getType());
        Object value = BsonHelper.getValue(doc, field);
        String actualType = value == null ? "null" : value.getClass().getTypeName();
        return DistanceHelper.getLeftAlignmentDistance(actualType, expectedType);
    }

    private double calculateDistanceForInvertedType(InvertedTypeOperation operation, Object doc) {
        String field = operation.getFieldName();
        String expectedType = BsonHelper.getType(operation.getType());
        Object value = BsonHelper.getValue(doc, field);
        String actualType = value == null ? null : value.getClass().getTypeName();
        return !Objects.equals(actualType, expectedType) ? 0.0 : 1.0;
    }

    private QueryOperation invertOperation(QueryOperation operation) {
        if (operation instanceof EqualsOperation) {
            EqualsOperation op = (EqualsOperation)operation;
            return new NotEqualsOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof NotEqualsOperation) {
            NotEqualsOperation op = (NotEqualsOperation)operation;
            return new EqualsOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof GreaterThanOperation) {
            GreaterThanOperation op = (GreaterThanOperation)operation;
            return new LessThanEqualsOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof GreaterThanEqualsOperation) {
            GreaterThanEqualsOperation op = (GreaterThanEqualsOperation)operation;
            return new LessThanOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof LessThanOperation) {
            LessThanOperation op = (LessThanOperation)operation;
            return new GreaterThanEqualsOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof LessThanEqualsOperation) {
            LessThanEqualsOperation op = (LessThanEqualsOperation)operation;
            return new GreaterThanOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof NotOperation) {
            NotOperation op = (NotOperation)operation;
            return op.getCondition();
        }
        if (operation instanceof AllOperation) {
            AllOperation op = (AllOperation)operation;
            return new InvertedAllOperation(op.getFieldName(), op.getValues());
        }
        if (operation instanceof InvertedAllOperation) {
            InvertedAllOperation op = (InvertedAllOperation)operation;
            return new AllOperation(op.getFieldName(), op.getValues());
        }
        if (operation instanceof AndOperation) {
            AndOperation op = (AndOperation)operation;
            List<QueryOperation> invertedConditions = op.getConditions().stream().map(this::invertOperation).collect(Collectors.toList());
            return new OrOperation(invertedConditions);
        }
        if (operation instanceof OrOperation) {
            OrOperation op = (OrOperation)operation;
            return new NorOperation(op.getConditions());
        }
        if (operation instanceof ExistsOperation) {
            ExistsOperation op = (ExistsOperation)operation;
            return new ExistsOperation(op.getFieldName(), op.getBoolean() == false);
        }
        if (operation instanceof InOperation) {
            InOperation op = (InOperation)operation;
            return new NotInOperation(op.getFieldName(), op.getValues());
        }
        if (operation instanceof NotInOperation) {
            NotInOperation op = (NotInOperation)operation;
            return new InOperation(op.getFieldName(), op.getValues());
        }
        if (operation instanceof ModOperation) {
            ModOperation op = (ModOperation)operation;
            return new InvertedModOperation(op.getFieldName(), op.getDivisor(), op.getRemainder());
        }
        if (operation instanceof InvertedModOperation) {
            InvertedModOperation op = (InvertedModOperation)operation;
            return new ModOperation(op.getFieldName(), op.getDivisor(), op.getRemainder());
        }
        if (operation instanceof NorOperation) {
            NorOperation op = (NorOperation)operation;
            return new OrOperation(op.getConditions());
        }
        if (operation instanceof SizeOperation) {
            SizeOperation op = (SizeOperation)operation;
            return new InvertedSizeOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof InvertedSizeOperation) {
            InvertedSizeOperation op = (InvertedSizeOperation)operation;
            return new SizeOperation(op.getFieldName(), op.getValue());
        }
        if (operation instanceof TypeOperation) {
            TypeOperation op = (TypeOperation)operation;
            return new InvertedTypeOperation(op.getFieldName(), op.getType());
        }
        if (operation instanceof InvertedTypeOperation) {
            InvertedTypeOperation op = (InvertedTypeOperation)operation;
            return new TypeOperation(op.getFieldName(), op.getType());
        }
        return operation;
    }

    private double compareValues(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double x = ((Number)val1).doubleValue();
            double y = ((Number)val2).doubleValue();
            return x - y;
        }
        if (val1 instanceof String && val2 instanceof String) {
            return DistanceHelper.getLeftAlignmentDistance((String)val1, (String)val2);
        }
        if (val1 instanceof Boolean && val2 instanceof Boolean) {
            return val1 == val2 ? 0.0 : 1.0;
        }
        if (val1 instanceof List && val2 instanceof List) {
            return Double.MAX_VALUE;
        }
        return Double.MAX_VALUE;
    }

    private double distanceToClosestElem(List<?> list, Object value) {
        double minDist = Double.MAX_VALUE;
        for (Object o : list) {
            double dif = this.compareValues(o, value);
            double absDif = Math.abs(dif);
            if (!(absDif < minDist)) continue;
            minDist = absDif;
        }
        return minDist;
    }
}

