/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.params;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ParamDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigDecimalParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.BigIntegerParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.CollectionParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.DateParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.MapParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.params.PrimitiveOrWrapperParam;
import org.evomaster.client.java.controller.problem.rpc.schema.params.Protobuf3ByteStringParam;
import org.evomaster.client.java.controller.problem.rpc.schema.types.AccessibleSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.ObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.PrimitiveOrWrapperType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;

public class ObjectParam
extends NamedTypedValue<ObjectType, List<NamedTypedValue>> {
    public static final String PROTO3_BUILDER_METHOD = "newBuilder";
    public static final String PROTO3_OBJECT_BUILD_METHOD = "build";

    public ObjectParam(String name, ObjectType type, AccessibleSchema accessibleSchema) {
        super(name, type, accessibleSchema);
    }

    @Override
    public Object newInstance() throws ClassNotFoundException {
        if (this.getValue() == null) {
            return null;
        }
        String clazzName = ((ObjectType)this.getType()).getFullTypeName();
        Class<?> clazz = Class.forName(clazzName);
        try {
            Object instance = null;
            if (((ObjectType)this.getType()).spec == JavaDtoSpec.PROTO3) {
                Object instanceBuilder = null;
                Method builderMethod = clazz.getMethod(PROTO3_BUILDER_METHOD, new Class[0]);
                instanceBuilder = builderMethod.invoke(null, new Object[0]);
                Class<?> builderClazz = instanceBuilder.getClass();
                for (NamedTypedValue v : (List)this.getValue()) {
                    Class<?> setterInputClazz = ((TypeSchema)v.getType()).getClazz();
                    if (v.accessibleSchema.setterInputParams != null && v.accessibleSchema.setterInputParams.length > 0) {
                        setterInputClazz = v.accessibleSchema.setterInputParams[0];
                    }
                    Method builderSetter = builderClazz.getMethod(v.accessibleSchema.setterMethodName, setterInputClazz);
                    builderSetter.invoke(instanceBuilder, v.newInstance());
                }
                Method buildMethod = builderClazz.getMethod(PROTO3_OBJECT_BUILD_METHOD, new Class[0]);
                instance = buildMethod.invoke(instanceBuilder, new Object[0]);
            } else if (((ObjectType)this.getType()).spec == JavaDtoSpec.DEFAULT) {
                instance = clazz.newInstance();
                for (NamedTypedValue v : (List)this.getValue()) {
                    boolean setWithSetter = false;
                    if (v.accessibleSchema != null && v.accessibleSchema.setterMethodName != null) {
                        Method m = this.getSetter(clazz, v.accessibleSchema.setterMethodName, (TypeSchema)v.getType(), ((TypeSchema)v.getType()).getClazz(), 0);
                        try {
                            m.invoke(instance, v.newInstance());
                            setWithSetter = true;
                        }
                        catch (InvocationTargetException e) {
                            SimpleLogger.uniqueWarn("fail to access the method:" + clazzName + " with error msg:" + e.getMessage());
                        }
                    }
                    if (setWithSetter) continue;
                    Field f = clazz.getField(v.getName());
                    f.setAccessible(true);
                    Object vins = v.newInstance();
                    if (vins == null) continue;
                    f.set(instance, vins);
                }
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("fail to construct the class:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("fail to access the class:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("fail to access the field:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("fail to access the method:" + clazzName + " with error msg:" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("fail to find the builder:" + clazzName + " with error msg:" + e.getMessage());
        }
    }

    private Method getSetter(Class<?> clazz, String setterName, TypeSchema type, Class<?> typeClass, int attemptTimes) throws NoSuchMethodException {
        try {
            Method m = clazz.getMethod(setterName, typeClass);
            return m;
        }
        catch (NoSuchMethodException e) {
            Type p;
            if (type instanceof PrimitiveOrWrapperType && attemptTimes == 0 && (p = PrimitiveOrWrapperParam.getPrimitiveOrWrapper(type.getClazz())) instanceof Class) {
                return this.getSetter(clazz, setterName, type, (Class)p, 1);
            }
            throw e;
        }
    }

    public ObjectParam copyStructure() {
        return new ObjectParam(this.getName(), (ObjectType)this.getType(), this.accessibleSchema);
    }

    @Override
    public ParamDto getDto() {
        ParamDto dto = super.getDto();
        if (this.getValue() != null) {
            dto.innerContent = ((List)this.getValue()).stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
            dto.setNotNullValue();
        } else {
            dto.innerContent = ((ObjectType)this.getType()).getFields().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }

    @Override
    public void setValueBasedOnDto(ParamDto dto) {
        if (dto.stringValue == null) {
            this.setValue(null);
            return;
        }
        if (dto.innerContent != null && !dto.innerContent.isEmpty()) {
            List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
            ArrayList values = new ArrayList();
            for (ParamDto p : dto.innerContent) {
                NamedTypedValue f = fields.stream().filter(s -> s.sameParam(p)).findFirst().get().copyStructureWithProperties();
                f.setValueBasedOnDto(p);
                values.add(f);
            }
            this.setValue(values);
        }
    }

    @Override
    protected void setValueBasedOnValidInstance(Object instance) {
        Class<?> clazz;
        ArrayList values = new ArrayList();
        List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
        try {
            clazz = Class.forName(((ObjectType)this.getType()).getFullTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ERROR: fail to get class with the name" + ((ObjectType)this.getType()).getFullTypeName() + " Msg:" + e.getMessage());
        }
        for (NamedTypedValue f : fields) {
            NamedTypedValue copy = f.copyStructureWithProperties();
            try {
                if (f.accessibleSchema == null || f.accessibleSchema.isAccessible) {
                    Field fi = clazz.getField(f.getName());
                    fi.setAccessible(true);
                    Object fiv = fi.get(instance);
                    copy.setValueBasedOnInstance(fiv);
                } else if (f.accessibleSchema.getterMethodName != null) {
                    Method m = clazz.getMethod(f.accessibleSchema.getterMethodName, new Class[0]);
                    copy.setValueBasedOnInstance(m.invoke(instance, new Object[0]));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("ERROR: fail to get value of the field with the name (" + f.getName() + ") and error Msg:" + e.getMessage());
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("ERROR: fail to get/invoke getter method for the field with the name (" + f.getName() + ") and error Msg:" + e.getMessage());
            }
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public void setValueBasedOnInstanceOrJson(Object json) throws JsonProcessingException {
        Object instance = json;
        if (json instanceof String) {
            instance = this.parseValueWithJson((String)json);
        }
        if (instance == null) {
            this.setValue(null);
            return;
        }
        if (this.isValidInstance(instance)) {
            this.setValueBasedOnValidInstance(instance);
            return;
        }
        ArrayList values = new ArrayList();
        List<NamedTypedValue> fields = ((ObjectType)this.getType()).getFields();
        if (!(instance instanceof Map)) {
            throw new RuntimeException("cannot parse the map param " + this.getName() + " with the type" + instance.getClass().getName());
        }
        for (NamedTypedValue f : fields) {
            NamedTypedValue copy = f.copyStructureWithProperties();
            Object fiv = ((Map)instance).get(f.getName());
            copy.setValueBasedOnInstanceOrJson(fiv);
            values.add(copy);
        }
        this.setValue(values);
    }

    @Override
    public List<String> newInstanceWithJavaOrKotlin(boolean isDeclaration, boolean doesIncludeName, String variableName, int indent, boolean isJava, boolean isVariableNullable) {
        String typeName = ((ObjectType)this.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        String varName = variableName;
        ArrayList<String> codes = new ArrayList<String>();
        boolean isNull = this.getValue() == null;
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.oneLineInstance(isDeclaration, doesIncludeName, typeName, varName, null, isJava, this.isNullable()), indent);
        if (isNull) {
            return codes;
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockStart(isJava), indent);
        String ownVarName = null;
        if (((ObjectType)this.getType()).spec == JavaDtoSpec.DEFAULT) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstanceObject(typeName, varName, isJava), indent + 1);
            ownVarName = varName;
        } else {
            String varBuilderName = varName + "builder";
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.newBuilderProto3(typeName, varBuilderName, isJava), indent + 1);
            ownVarName = varBuilderName;
        }
        for (NamedTypedValue f : (List)this.getValue()) {
            if (f.accessibleSchema != null && f.accessibleSchema.setterMethodName != null) {
                String fName = ownVarName;
                boolean fdeclar = false;
                if (this.needRenameField(f)) {
                    fName = varName + "_" + f.getName();
                    fdeclar = true;
                }
                codes.addAll(f.newInstanceWithJavaOrKotlin(fdeclar, true, fName, indent + 1, isJava, this.isNullable()));
                if (!this.needRenameField(f)) continue;
                CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.methodInvocation(ownVarName, f.accessibleSchema.setterMethodName, fName, isJava, this.isNullable(), false) + CodeJavaOrKotlinGenerator.getStatementLast(isJava), indent + 1);
                continue;
            }
            codes.addAll(f.newInstanceWithJavaOrKotlin(false, true, CodeJavaOrKotlinGenerator.fieldAccess(varName, f.getName(), isJava, this.isNullable(), false), indent + 1, isJava, this.isNullable()));
        }
        if (((ObjectType)this.getType()).spec == JavaDtoSpec.PROTO3) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.setInstance(true, varName, CodeJavaOrKotlinGenerator.methodInvocation(ownVarName, PROTO3_OBJECT_BUILD_METHOD, "", isJava, this.isNullable(), false), isJava), indent + 1);
        }
        CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.codeBlockEnd(isJava), indent);
        return codes;
    }

    private boolean needRenameField(NamedTypedValue f) {
        return f instanceof ObjectParam || f instanceof MapParam || f instanceof CollectionParam || f instanceof DateParam || f instanceof BigDecimalParam || f instanceof BigIntegerParam || f instanceof Protobuf3ByteStringParam;
    }

    @Override
    public List<String> newAssertionWithJavaOrKotlin(int indent, String responseVarName, int maxAssertionForDataInCollection, boolean isJava) {
        ArrayList<String> codes = new ArrayList<String>();
        if (this.getValue() == null) {
            CodeJavaOrKotlinGenerator.addCode(codes, CodeJavaOrKotlinGenerator.junitAssertNull(responseVarName, isJava), indent);
            return codes;
        }
        for (NamedTypedValue f : (List)this.getValue()) {
            String fName = null;
            if (f.accessibleSchema == null || f.accessibleSchema.isAccessible) {
                fName = CodeJavaOrKotlinGenerator.fieldAccess(responseVarName, f.getName(), isJava, this.isNullable(), true);
            } else if (f.accessibleSchema.getterMethodName == null) {
                String msg = "Error: Object(" + ((ObjectType)this.getType()).getFullTypeName() + ") has private field " + f.getName() + ", but there is no getter method";
                SimpleLogger.uniqueWarn(msg);
                CodeJavaOrKotlinGenerator.addComment(codes, msg, indent);
            } else {
                fName = CodeJavaOrKotlinGenerator.methodInvocation(responseVarName, f.accessibleSchema.getterMethodName, "", isJava, this.isNullable(), true);
            }
            if (fName == null) continue;
            codes.addAll(f.newAssertionWithJavaOrKotlin(indent, fName, maxAssertionForDataInCollection, isJava));
        }
        return codes;
    }

    @Override
    public String getValueAsJavaString(boolean isJava) {
        return null;
    }

    @Override
    public List<String> referenceTypes() {
        ArrayList<String> references = new ArrayList<String>();
        for (NamedTypedValue ref : ((ObjectType)this.getType()).getFields()) {
            List<String> refrefTypes;
            if (ref instanceof ObjectParam) {
                references.add(((TypeSchema)ref.getType()).getFullTypeName());
                List<String> genericTypes = ((ObjectType)ref.getType()).getGenericTypes();
                if (genericTypes != null && !genericTypes.isEmpty()) {
                    references.addAll(genericTypes);
                }
            }
            if ((refrefTypes = ref.referenceTypes()) == null) continue;
            references.addAll(refrefTypes);
        }
        if (references.isEmpty()) {
            return null;
        }
        return references;
    }
}

