/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.heuristic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.DistanceHelper;
import org.evomaster.client.java.instrumentation.heuristic.Truthness;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.utils.SimpleLogger;

public class ValidatorHeuristics {
    private static final double defaultFailed = 0.001;
    private static final String PREFIX_JAVAX = "javax.validation.constraints.";
    private static final String PREFIX_JAKARTA = "TODO";
    private static final String PREFIX_HIBERNATE = "org.hibernate.validator.constraints.";
    private static final String PREFIX_JIRUKTA = "cz.jirutka.validator.collection.constraints.";

    public static Truthness computeTruthness(Object validator, Object bean) {
        Objects.requireNonNull(validator);
        Objects.requireNonNull(bean);
        Class<?> validatorClass = validator.getClass();
        Class<?> beanClass = bean.getClass();
        try {
            Object beanDescriptor = validatorClass.getMethod("getConstraintsForClass", Class.class).invoke(validator, beanClass);
            boolean isConstrained = (Boolean)beanDescriptor.getClass().getMethod("isBeanConstrained", new Class[0]).invoke(beanDescriptor, new Object[0]);
            if (!isConstrained) {
                throw new IllegalArgumentException("Bean has no constraints: " + beanClass.getName());
            }
            int n = ValidatorHeuristics.getNumberOfTotalConstraints(beanDescriptor);
            Set constraintViolations = (Set)validatorClass.getMethod("validate", Object.class, Class[].class).invoke(validator, bean, new Class[0]);
            double solved = Math.max(0, (n *= 1000) - constraintViolations.size());
            for (Object violation : constraintViolations) {
                double h = ValidatorHeuristics.computeHeuristicToSolveFailedConstraint(violation);
                assert (h >= 0.0 && h <= 1.0);
                solved += h;
            }
            if (constraintViolations.isEmpty()) {
                return new Truthness(1.0, 0.1);
            }
            double t = solved / (double)n;
            return new Truthness(t, 1.0);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static double computeHeuristicToSolveFailedConstraint(Object violation) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object invalidValue = violation.getClass().getMethod("getInvalidValue", new Class[0]).invoke(violation, new Object[0]);
        Object descriptor = violation.getClass().getMethod("getConstraintDescriptor", new Class[0]).invoke(violation, new Object[0]);
        Map attributes = (Map)descriptor.getClass().getMethod("getAttributes", new Class[0]).invoke(descriptor, new Object[0]);
        Annotation annotation = (Annotation)descriptor.getClass().getMethod("getAnnotation", new Class[0]).invoke(descriptor, new Object[0]);
        String annotationType = annotation.annotationType().getName();
        boolean javax = annotationType.startsWith(PREFIX_JAVAX);
        boolean jakarta = annotationType.startsWith(PREFIX_JAKARTA);
        boolean hibernate = annotationType.startsWith(PREFIX_HIBERNATE);
        boolean jirukta = annotationType.startsWith(PREFIX_JIRUKTA);
        if (!(javax || jakarta || hibernate || jirukta)) {
            SimpleLogger.warn("Not recognized constraint library. Not able to handle constraint type: " + annotationType);
            return 0.001;
        }
        if (jirukta) {
            return ValidatorHeuristics.handleJiruktaConstraint(annotationType, invalidValue, attributes);
        }
        if (hibernate && annotationType.endsWith(".Range")) {
            return ValidatorHeuristics.computeHeuristicForRange(invalidValue, attributes);
        }
        if (javax) {
            if (annotationType.endsWith(".Min")) {
                return ValidatorHeuristics.computeHeuristicForMin(invalidValue, attributes);
            }
            if (annotationType.endsWith(".Max")) {
                return ValidatorHeuristics.computeHeuristicForMax(invalidValue, attributes);
            }
            if (annotationType.endsWith(".Positive")) {
                return ValidatorHeuristics.computeHeuristicForPositive(invalidValue, attributes);
            }
            if (annotationType.endsWith(".PositiveOrZero")) {
                return ValidatorHeuristics.computeHeuristicForPositiveOrZero(invalidValue, attributes);
            }
            if (annotationType.endsWith(".Negative")) {
                return ValidatorHeuristics.computeHeuristicForNegative(invalidValue, attributes);
            }
            if (annotationType.endsWith(".NegativeOrZero")) {
                return ValidatorHeuristics.computeHeuristicForNegativeOrZero(invalidValue, attributes);
            }
            if (annotationType.endsWith(".Size")) {
                return ValidatorHeuristics.computeHeuristicForSize(invalidValue, attributes);
            }
            if (annotationType.endsWith(".NotEmpty") || annotationType.endsWith(".NotBlank")) {
                return ValidatorHeuristics.computeHeuristicForNoGradientButNullIsNotValid(invalidValue);
            }
            if (annotationType.endsWith(".Null") || annotationType.endsWith(".NotNull") || annotationType.endsWith(".AssertTrue") || annotationType.endsWith(".AssertFalse")) {
                return 0.001;
            }
            if (annotationType.endsWith(".Pattern")) {
                assert (invalidValue != null);
                String value = invalidValue.toString();
                if (ExecutionTracer.isTaintInput(value)) {
                    ExecutionTracer.addStringSpecialization(value, new StringSpecializationInfo(StringSpecialization.REGEX_WHOLE, attributes.get("regexp").toString()));
                }
                return 0.001;
            }
        }
        SimpleLogger.warn("Not able to handle constrain type: " + annotationType);
        return 0.001;
    }

    private static double handleJiruktaConstraint(String annotationType, Object invalidValue, Map<String, Object> attributes) {
        if (annotationType.endsWith(".EachRange")) {
            Collection values = (Collection)invalidValue;
            long sum = 0L;
            for (Integer k : values) {
                sum += (long)ValidatorHeuristics.getDistanceForRange(k, attributes);
            }
            return DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, sum);
        }
        if (annotationType.endsWith(".EachPattern")) {
            Collection values = (Collection)invalidValue;
            String regexp = attributes.get("regexp").toString();
            int mismatches = 0;
            for (String value : values) {
                boolean matched;
                if (ExecutionTracer.isTaintInput(value)) {
                    ExecutionTracer.addStringSpecialization(value, new StringSpecializationInfo(StringSpecialization.REGEX_WHOLE, regexp));
                }
                if (matched = value.matches(regexp)) continue;
                ++mismatches;
            }
            assert (mismatches > 0);
            return DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, mismatches);
        }
        SimpleLogger.warn("Not able to handle constrain type: " + annotationType);
        return 0.001;
    }

    private static double computeHeuristicForNoGradientButNullIsNotValid(Object invalidValue) {
        if (invalidValue == null) {
            return 0.05;
        }
        return 0.1;
    }

    private static double computeHeuristicForSize(Object invalidValue, Map<String, Object> attributes) {
        assert (invalidValue != null);
        Integer size = ValidatorHeuristics.computeSize(invalidValue);
        if (size == null) {
            SimpleLogger.warn("Cannot handle @Size for type: " + invalidValue.getClass().getName());
            return 0.1;
        }
        return ValidatorHeuristics.computeHeuristicForRange(size, attributes);
    }

    private static int getDistanceForRange(Object invalidValue, Map<String, Object> attributes) {
        int max;
        int value = ((Number)invalidValue).intValue();
        int min = ((Number)attributes.get("min")).intValue();
        if (min > (max = ((Number)attributes.get("max")).intValue())) {
            SimpleLogger.warn("Impossible to satisfy constraint min>max : " + min + ">" + max);
            return -1;
        }
        return DistanceHelper.distanceToRange(value, min, max);
    }

    private static double computeHeuristicForRange(Object invalidValue, Map<String, Object> attributes) {
        int distance = ValidatorHeuristics.getDistanceForRange(invalidValue, attributes);
        if (distance < 0) {
            return 0.1;
        }
        assert (distance != 0);
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.1, distance);
    }

    private static Integer computeSize(Object invalidValue) {
        int size;
        if (invalidValue instanceof CharSequence) {
            size = ((CharSequence)invalidValue).length();
        } else if (invalidValue instanceof Collection) {
            size = ((Collection)invalidValue).size();
        } else if (invalidValue instanceof Map) {
            size = ((Map)invalidValue).size();
        } else if (invalidValue.getClass().isArray()) {
            size = Array.getLength(invalidValue);
        } else {
            SimpleLogger.warn("Cannot compute size for type: " + invalidValue.getClass().getName());
            return null;
        }
        return size;
    }

    private static double computeHeuristicForMin(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double min = ((Number)attributes.get("value")).doubleValue();
        assert (x < min);
        double distance = min - x;
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static double computeHeuristicForMax(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double max = ((Number)attributes.get("value")).doubleValue();
        assert (x > max);
        double distance = x - max;
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static double computeHeuristicForPositive(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double min = 0.0;
        assert (x <= min);
        double distance = 1.0 + (min - x);
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static double computeHeuristicForPositiveOrZero(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double min = 0.0;
        assert (x < min);
        double distance = min - x;
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static double computeHeuristicForNegative(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double max = 0.0;
        assert (x >= max);
        double distance = 1.0 + (x - max);
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static double computeHeuristicForNegativeOrZero(Object invalidValue, Map<String, Object> attributes) {
        double x = ((Number)invalidValue).doubleValue();
        double max = 0.0;
        assert (x > max);
        double distance = x - max;
        return DistanceHelper.heuristicFromScaledDistanceWithBase(0.001, distance);
    }

    private static int getNumberOfTotalConstraints(Object beanDescriptor) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Set properties = (Set)beanDescriptor.getClass().getMethod("getConstrainedProperties", new Class[0]).invoke(beanDescriptor, new Object[0]);
        long n = properties.stream().mapToInt(it -> {
            Set constraints = null;
            Set collectionConstraints = null;
            try {
                constraints = (Set)it.getClass().getMethod("getConstraintDescriptors", new Class[0]).invoke(it, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                collectionConstraints = (Set)it.getClass().getMethod("getConstrainedContainerElementTypes", new Class[0]).invoke(it, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                collectionConstraints = new HashSet();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return constraints.size() + collectionConstraints.size();
        }).sum();
        Set classConstraints = (Set)beanDescriptor.getClass().getMethod("getConstraintDescriptors", new Class[0]).invoke(beanDescriptor, new Object[0]);
        return (int)(n += (long)classConstraints.size());
    }
}

