/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCActionDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCInterfaceSchemaDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.RPCType;
import org.evomaster.client.java.controller.api.dto.problem.rpc.SeededRPCActionDto;
import org.evomaster.client.java.controller.problem.rpc.schema.EndpointSchema;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.CycleObjectType;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;
import org.evomaster.client.java.utils.SimpleLogger;

public final class InterfaceSchema {
    private final String name;
    private final String clientInfo;
    private List<EndpointSchema> endpoints;
    private Map<Integer, EndpointSchema> authEndpoints;
    private List<EndpointSchema> endpointsForAuth;
    private Map<String, TypeSchema> typeCollections = new HashMap<String, TypeSchema>();
    private Map<String, NamedTypedValue> objParamCollections = new HashMap<String, NamedTypedValue>();
    private final RPCType rpcType;
    private final List<String> skippedEndpoints;
    private Map<String, NamedTypedValue> identifiedResponseTypes = new HashMap<String, NamedTypedValue>();

    public Map<Integer, EndpointSchema> getAuthEndpoints() {
        return this.authEndpoints;
    }

    public InterfaceSchema(String name, List<EndpointSchema> endpoints, String client, RPCType rpcType) {
        this(name, endpoints, client, rpcType, null, null, null);
    }

    public InterfaceSchema(String name, List<EndpointSchema> endpoints, String client, RPCType rpcType, List<String> skippedEndpoints, Map<Integer, EndpointSchema> authEndpoints, List<EndpointSchema> endpointsForAuth) {
        this.name = name;
        this.endpoints = endpoints;
        this.clientInfo = client;
        this.rpcType = rpcType;
        this.skippedEndpoints = skippedEndpoints;
        this.authEndpoints = authEndpoints;
        this.endpointsForAuth = endpointsForAuth;
    }

    public void registerType(TypeSchema type, NamedTypedValue param, boolean isTypeToIdentify) {
        if (isTypeToIdentify) {
            NamedTypedValue r;
            if (!(type instanceof CycleObjectType || (r = this.identifiedResponseTypes.get(((TypeSchema)param.getType()).getFullTypeNameWithGenericType())) != null && ((TypeSchema)param.getType()).depth <= ((TypeSchema)r.getType()).depth)) {
                this.identifiedResponseTypes.put(((TypeSchema)param.getType()).getFullTypeNameWithGenericType(), param);
            }
        } else {
            NamedTypedValue p;
            TypeSchema t;
            String typeName = type.getFullTypeNameWithGenericType();
            if (!(type instanceof CycleObjectType || (t = this.typeCollections.get(typeName)) != null && t.depth >= type.depth)) {
                this.typeCollections.put(typeName, type);
            }
            if (!(param.getType() instanceof CycleObjectType || (p = this.objParamCollections.get(((TypeSchema)param.getType()).getFullTypeNameWithGenericType())) != null && ((TypeSchema)param.getType()).depth <= ((TypeSchema)p.getType()).depth)) {
                this.objParamCollections.put(((TypeSchema)param.getType()).getFullTypeNameWithGenericType(), param);
            }
        }
    }

    public Map<String, NamedTypedValue> getObjParamCollections() {
        return this.objParamCollections;
    }

    public TypeSchema getTypeOrNull(String name) {
        return this.typeCollections.get(name);
    }

    public List<EndpointSchema> getEndpoints() {
        return this.endpoints;
    }

    public RPCType getRpcType() {
        return this.rpcType;
    }

    public List<EndpointSchema> findEndpoints(String name) {
        List<EndpointSchema> found = this.endpoints.stream().filter(s -> s.getName().equals(name)).collect(Collectors.toList());
        if (found.isEmpty() && this.endpointsForAuth != null && !this.endpointsForAuth.isEmpty()) {
            return this.endpointsForAuth.stream().filter(s -> s.getName().equals(name)).collect(Collectors.toList());
        }
        return found;
    }

    public EndpointSchema getOneEndpoint(RPCActionDto dto) {
        List list = this.endpoints.stream().filter(s -> s.sameEndpoint(dto)).collect(Collectors.toList());
        if (list.isEmpty()) {
            list.addAll(this.endpointsForAuth.stream().filter(s -> s.sameEndpoint(dto)).collect(Collectors.toList()));
        }
        if (list.size() == 1) {
            return (EndpointSchema)list.get(0);
        }
        if (list.size() > 1) {
            throw new RuntimeException("ERROR: there exists more than 1 endpoint which conforms with the specified dto " + dto.descriptiveInfo());
        }
        throw new RuntimeException("ERROR: there does not exist any endpoint which conforms with the specified dto " + dto.descriptiveInfo());
    }

    public EndpointSchema getOneEndpointWithSeededDto(SeededRPCActionDto dto) {
        List list = this.endpoints.stream().filter(s -> s.sameEndpoint(dto)).collect(Collectors.toList());
        if (list.size() == 1) {
            return (EndpointSchema)list.get(0);
        }
        if (list.size() > 1) {
            throw new RuntimeException("ERROR: there exists more than 1 endpoint which conforms with the specified seeded test dto " + dto.descriptiveInfo());
        }
        if (this.skippedEndpoints.contains(dto.functionName)) {
            SimpleLogger.uniqueWarn("Fail to handle the ");
            return null;
        }
        throw new RuntimeException("ERROR: there does not exist any endpoint which conforms with the specified seeded test dto " + dto.descriptiveInfo());
    }

    public String getName() {
        return this.name;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public Map<String, TypeSchema> getTypeCollections() {
        return this.typeCollections;
    }

    public RPCInterfaceSchemaDto getDto() {
        RPCInterfaceSchemaDto dto = new RPCInterfaceSchemaDto();
        dto.types = this.objParamCollections.values().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        dto.interfaceId = this.getName();
        dto.clientInfo = this.getClientInfo();
        dto.endpoints = this.endpoints.stream().map(EndpointSchema::getDto).collect(Collectors.toList());
        if (this.skippedEndpoints != null) {
            dto.skippedEndpoints = new ArrayList<String>(this.skippedEndpoints);
        }
        if (this.authEndpoints != null && !this.authEndpoints.isEmpty()) {
            dto.authEndpointReferences = new ArrayList<Integer>();
            dto.authEndpoints = new ArrayList<RPCActionDto>();
            this.authEndpoints.forEach((k, v) -> {
                dto.authEndpointReferences.add((Integer)k);
                dto.authEndpoints.add(v.getDto());
            });
        }
        if (!this.identifiedResponseTypes.isEmpty()) {
            dto.identifiedResponseTypes = this.identifiedResponseTypes.values().stream().map(NamedTypedValue::getDto).collect(Collectors.toList());
        }
        return dto;
    }
}

