/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem.rpc.schema.types;

import java.util.List;
import java.util.Set;
import org.evomaster.client.java.controller.api.dto.problem.rpc.TypeDto;
import org.evomaster.client.java.controller.problem.rpc.CodeJavaOrKotlinGenerator;
import org.evomaster.client.java.controller.problem.rpc.schema.params.NamedTypedValue;
import org.evomaster.client.java.controller.problem.rpc.schema.types.JavaDtoSpec;
import org.evomaster.client.java.controller.problem.rpc.schema.types.TypeSchema;

public class CollectionType
extends TypeSchema {
    private static final String KOTLIN_LIST = "MutableList";
    private static final String KOTLIN_SET = "MutableSet";
    private static final String KOTLIN_ARRAY = "Array";
    private final NamedTypedValue template;

    public CollectionType(String type, String fullTypeName, NamedTypedValue template, Class<?> clazz, JavaDtoSpec spec) {
        super(type, fullTypeName, clazz, spec);
        this.template = template;
    }

    public NamedTypedValue getTemplate() {
        return this.template;
    }

    @Override
    public TypeDto getDto() {
        TypeDto dto = super.getDto();
        dto.example = this.template.getDto();
        return dto;
    }

    @Override
    public String getTypeNameForInstanceInJavaOrKotlin(boolean isJava) {
        String generic = ((TypeSchema)this.template.getType()).getTypeNameForInstanceInJavaOrKotlin(isJava);
        String collectionType = this.getFullTypeName();
        if (!isJava) {
            if (List.class.isAssignableFrom(this.getClazz())) {
                collectionType = KOTLIN_LIST;
            } else if (Set.class.isAssignableFrom(this.getClazz())) {
                collectionType = KOTLIN_SET;
            } else if (this.getClazz().isArray()) {
                collectionType = KOTLIN_ARRAY;
            }
        }
        return CodeJavaOrKotlinGenerator.typeNameOfArrayOrCollection(collectionType, this.getClazz().isArray(), generic, isJava);
    }

    @Override
    public CollectionType copy() {
        return new CollectionType(this.getSimpleTypeName(), this.getFullTypeName(), this.template, this.getClazz(), this.spec);
    }

    @Override
    public String getFullTypeNameWithGenericType() {
        String generic = ((TypeSchema)this.template.getType()).getFullTypeNameWithGenericType();
        if (this.getClazz().isArray()) {
            return super.getFullTypeNameWithGenericType();
        }
        return this.getFullTypeName() + "<" + generic + ">";
    }
}

