/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Date;
import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class DateClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Date.class;
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean equals(Date caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Date)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Date anotherDate = (Date)anObject;
            if (caller.equals(anotherDate)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double distance = DistanceHelper.getDistanceToEquality(caller, anotherDate);
                double base = 0.1;
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean before(Date caller, Date when, String idTemplate) {
        Objects.requireNonNull(caller);
        boolean res = caller.before(when);
        if (idTemplate == null) {
            return res;
        }
        Truthness t = DateClassReplacement.getBeforeTruthness(caller, when);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return res;
    }

    private static Truthness getBeforeTruthness(Date caller, Date when) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(when);
        long a = caller.getTime();
        long b = when.getTime();
        return TruthnessUtils.getLessThanTruthness(a, b);
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean after(Date caller, Date when, String idTemplate) {
        Objects.requireNonNull(caller);
        boolean res = caller.after(when);
        if (idTemplate == null) {
            return res;
        }
        Truthness t = DateClassReplacement.getBeforeTruthness(when, caller);
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return res;
    }
}

