/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.instrumentation.MongoInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.object.ClassToSchema;
import org.evomaster.client.java.instrumentation.object.CustomTypeToOasConverter;
import org.evomaster.client.java.instrumentation.object.GeoJsonPointToOasConverter;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public abstract class MongoOperationClassReplacement
extends ThirdPartyMethodReplacementClass {
    protected static void handleMongo(Object mongoCollection, Object bson, boolean successfullyExecuted, long executionTime) {
        List<CustomTypeToOasConverter> converters = Collections.singletonList(new GeoJsonPointToOasConverter());
        String schema = ClassToSchema.getOrDeriveSchemaWithItsRef(MongoOperationClassReplacement.extractDocumentsType(mongoCollection), true, converters);
        MongoInfo info = new MongoInfo(MongoOperationClassReplacement.getCollectionName(mongoCollection), MongoOperationClassReplacement.getDatabaseName(mongoCollection), schema, MongoOperationClassReplacement.getDocuments(mongoCollection), bson, successfullyExecuted, executionTime);
        ExecutionTracer.addMongoInfo(info);
    }

    private static Iterable<?> getDocuments(Object collection) {
        ArrayList documentsAsList = new ArrayList();
        try {
            Class<?> collectionClass = MongoOperationClassReplacement.getCollectionClass(collection);
            Iterable findIterable = (Iterable)collectionClass.getMethod("find", new Class[0]).invoke(collection, new Object[0]);
            findIterable.forEach(documentsAsList::add);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve all documents from a mongo collection", e);
        }
        return documentsAsList;
    }

    private static Class<?> extractDocumentsType(Object collection) {
        try {
            Class<?> collectionClass = MongoOperationClassReplacement.getCollectionClass(collection);
            return (Class)collectionClass.getMethod("getDocumentClass", new Class[0]).invoke(collection, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve document's type from collection", e);
        }
    }

    private static String getDatabaseName(Object collection) {
        try {
            Class<?> collectionClass = MongoOperationClassReplacement.getCollectionClass(collection);
            Object namespace = collectionClass.getMethod("getNamespace", new Class[0]).invoke(collection, new Object[0]);
            return (String)namespace.getClass().getMethod("getDatabaseName", new Class[0]).invoke(namespace, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve name of the database in which collection is", e);
        }
    }

    private static String getCollectionName(Object collection) {
        try {
            Class<?> collectionClass = MongoOperationClassReplacement.getCollectionClass(collection);
            Object namespace = collectionClass.getMethod("getNamespace", new Class[0]).invoke(collection, new Object[0]);
            return (String)namespace.getClass().getMethod("getCollectionName", new Class[0]).invoke(namespace, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to retrieve collection name", e);
        }
    }

    private static Class<?> getCollectionClass(Object collection) throws ClassNotFoundException {
        return collection.getClass().getInterfaces()[0];
    }
}

