/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import org.evomaster.client.java.controller.EmbeddedSutController;
import org.evomaster.client.java.controller.ExternalSutController;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.instrumentation.InstrumentingAgent;
import shaded.com.ea.agentloader.AgentLoader;

public class InstrumentedSutStarter {
    public static final String JDK_17_JVM_OPTIONS = "--add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED";
    private static boolean alreadyLoaded = false;
    private final SutController sutController;

    public static void loadAgent() {
        if (!alreadyLoaded) {
            alreadyLoaded = true;
            try {
                AgentLoader.loadAgentClass(InstrumentingAgent.class.getName(), "foobar_packagenameshouldnotexist.");
            }
            catch (Exception e) {
                throw new RuntimeException("\nFailed to apply bytecode instrumentation with JavaAgent.\nIf you are using JDK 11 or above, are you sure you added the following JVM option?\n -Djdk.attach.allowAttachSelf=true \nAlso, if you are using JDK 17 or above, you also need the following:\n--add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED\nThis can also be set globally with the JDK_JAVA_OPTIONS environment variable.\nSee documentation at https://github.com/WebFuzzing/EvoMaster/blob/master/docs/jdks.md", e);
            }
        }
    }

    public InstrumentedSutStarter(SutController sutController) {
        String toSkip = sutController.packagesToSkipInstrumentation();
        if (toSkip != null && !toSkip.isEmpty()) {
            System.setProperty("em.skipClasses", toSkip);
        }
        this.sutController = sutController;
        if (sutController instanceof EmbeddedSutController) {
            InstrumentedSutStarter.loadAgent();
            InstrumentingAgent.changePackagesToInstrument(sutController.getPackagePrefixesToCover());
        } else if (sutController instanceof ExternalSutController) {
            ((ExternalSutController)sutController).setInstrumentation(true);
            System.setProperty("shaded.org.eclipse.jetty.util.log.class", "shaded.org.eclipse.jetty.util.log.StdErrLog");
            System.setProperty("shaded.org.eclipse.jetty.LEVEL", "WARN");
        } else {
            throw new IllegalArgumentException("Invalid SUT controller type");
        }
    }

    public boolean start() {
        return this.sutController.startTheControllerServer();
    }

    public boolean stop() {
        return this.sutController.stopTheControllerServer();
    }

    public int getControllerServerPort() {
        return this.sutController.getControllerServerPort();
    }
}

