/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.evomaster.client.java.controller.api.dto.ActionDto;
import org.evomaster.client.java.controller.api.dto.ActionResponseDto;
import org.evomaster.client.java.controller.api.dto.AdditionalInfoDto;
import org.evomaster.client.java.controller.api.dto.ControllerInfoDto;
import org.evomaster.client.java.controller.api.dto.ExternalServiceInfoDto;
import org.evomaster.client.java.controller.api.dto.HostnameResolutionInfoDto;
import org.evomaster.client.java.controller.api.dto.PostSearchActionDto;
import org.evomaster.client.java.controller.api.dto.StringSpecializationInfoDto;
import org.evomaster.client.java.controller.api.dto.SutInfoDto;
import org.evomaster.client.java.controller.api.dto.SutRunDto;
import org.evomaster.client.java.controller.api.dto.TargetInfoDto;
import org.evomaster.client.java.controller.api.dto.TestResultsDto;
import org.evomaster.client.java.controller.api.dto.WrappedResponseDto;
import org.evomaster.client.java.controller.api.dto.database.operations.DatabaseCommandDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionResultsDto;
import org.evomaster.client.java.controller.api.dto.database.operations.MongoDatabaseCommandDto;
import org.evomaster.client.java.controller.api.dto.database.operations.MongoInsertionResultsDto;
import org.evomaster.client.java.controller.api.dto.problem.ExternalServiceDto;
import org.evomaster.client.java.controller.api.dto.problem.GraphQLProblemDto;
import org.evomaster.client.java.controller.api.dto.problem.RestProblemDto;
import org.evomaster.client.java.controller.api.dto.problem.WebProblemDto;
import org.evomaster.client.java.controller.api.dto.problem.param.DeriveParamResponseDto;
import org.evomaster.client.java.controller.api.dto.problem.param.DerivedParamChangeReqDto;
import org.evomaster.client.java.controller.api.dto.problem.param.RestDerivedParamDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ScheduleTaskInvocationsDto;
import org.evomaster.client.java.controller.api.dto.problem.rpc.ScheduleTaskInvocationsResult;
import org.evomaster.client.java.controller.internal.SutController;
import org.evomaster.client.java.controller.mongo.MongoScriptRunner;
import org.evomaster.client.java.controller.problem.ExternalService;
import org.evomaster.client.java.controller.problem.GraphQlProblem;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.controller.problem.RPCProblem;
import org.evomaster.client.java.controller.problem.RestProblem;
import org.evomaster.client.java.controller.problem.WebProblem;
import org.evomaster.client.java.controller.problem.param.RestDerivedParam;
import org.evomaster.client.java.controller.problem.rpc.schema.LocalAuthSetupSchema;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.org.glassfish.jersey.internal.util.Producer;

@Path(value="")
@Produces(value={"application/json;charset=utf8;version=1"})
public class EMController {
    private final SutController sutController;
    private volatile Integer lastSqlCommandId = null;
    private String baseUrlOfSUT;
    private static final Set<String> connectedClientsSoFar = new CopyOnWriteArraySet<String>();
    private static final String htmlWarning = new Scanner(EMController.class.getResourceAsStream("/warning.html"), "UTF-8").useDelimiter("\\A").next();

    public EMController(SutController sutController) {
        this.sutController = Objects.requireNonNull(sutController);
    }

    private boolean trackRequestSource(HttpServletRequest request) {
        String source = request.getRemoteAddr() + ":" + request.getRemotePort();
        connectedClientsSoFar.add(source);
        return true;
    }

    public static Set<String> getConnectedClientsSoFar() {
        return connectedClientsSoFar;
    }

    public static void resetConnectedClientsSoFar() {
        connectedClientsSoFar.clear();
    }

    private static String removePrefix(String s, String prefix) {
        if (s != null && prefix != null && s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    @Path(value="/")
    @GET
    @Produces(value={"text/html"})
    public Response getWarning() {
        return Response.status(400).entity(htmlWarning).build();
    }

    private <T> T noKillSwitch(Producer<T> lambda) {
        boolean previous = ExecutionTracer.isKillSwitch();
        ExecutionTracer.setKillSwitch(false);
        T t = lambda.call();
        ExecutionTracer.setKillSwitch(previous);
        return t;
    }

    private void noKillSwitch(Runnable lambda) {
        boolean previous = ExecutionTracer.isKillSwitch();
        ExecutionTracer.setKillSwitch(false);
        lambda.run();
        ExecutionTracer.setKillSwitch(previous);
    }

    private void noKillSwitchForceCheck(Runnable lambda) {
        boolean previous = ExecutionTracer.isKillSwitch();
        this.sutController.setKillSwitch(false);
        lambda.run();
        this.sutController.setKillSwitch(previous);
    }

    @Path(value="/infoSUT")
    @GET
    public Response getSutInfo(@Context HttpServletRequest httpServletRequest) {
        ProblemInfo p2;
        ProblemInfo info;
        assert (!ExecutionTracer.isExecutingAction());
        String connectionHeader = httpServletRequest.getHeader("Connection");
        if (connectionHeader == null || !connectionHeader.equalsIgnoreCase("keep-alive")) {
            return Response.status(400).entity(WrappedResponseDto.withError("Requests should always contain a 'Connection: keep-alive'")).build();
        }
        assert (this.trackRequestSource(httpServletRequest));
        if (!this.noKillSwitch(() -> this.sutController.verifySqlConnection()).booleanValue()) {
            String msg = "SQL drivers are misconfigured. You must use a 'p6spy' wrapper when you run the SUT. For example, a database connection URL like 'jdbc:h2:mem:testdb' should be changed into 'jdbc:p6spy:h2:mem:testdb'. See documentation on how to configure P6Spy.";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        SutInfoDto dto = new SutInfoDto();
        try {
            dto.isSutRunning = this.noKillSwitch(() -> this.sutController.isSutRunning());
            dto.baseUrlOfSUT = this.baseUrlOfSUT;
            dto.infoForAuthentication = this.noKillSwitch(() -> this.sutController.getInfoForAuthentication());
            dto.sqlSchemaDto = this.noKillSwitch(() -> this.sutController.getSqlDatabaseSchema());
            dto.defaultOutputFormat = this.noKillSwitch(() -> this.sutController.getPreferredOutputFormat());
            info = this.noKillSwitch(() -> this.sutController.getProblemInfo());
            dto.bootTimeInfoDto = this.noKillSwitch(() -> this.sutController.getBootTimeInfoDto());
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        if (info == null) {
            String msg = "Undefined problem type in the EM Controller";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        List servicesToNotMock = info.getServicesToNotMock().stream().map(s -> new ExternalServiceDto((ExternalService)s){
            final /* synthetic */ ExternalService val$s;
            {
                this.val$s = externalService;
                this.hostname = this.val$s.getHostname();
                this.port = this.val$s.getPort();
            }
        }).collect(Collectors.toList());
        if (info instanceof RestProblem) {
            RestProblem rp = (RestProblem)info;
            dto.restProblem = new RestProblemDto();
            dto.restProblem.openApiUrl = rp.getOpenApiUrl();
            dto.restProblem.endpointsToSkip = rp.getEndpointsToSkip();
            dto.restProblem.openApiSchema = rp.getOpenApiSchema();
            dto.restProblem.servicesToNotMock = servicesToNotMock;
            dto.restProblem.derivedParams = rp.getDerivedParams().stream().map(p -> new RestDerivedParamDto((RestDerivedParam)p){
                final /* synthetic */ RestDerivedParam val$p;
                {
                    this.val$p = restDerivedParam;
                    this.paramName = this.val$p.paramName;
                    this.context = this.val$p.context.toString();
                    this.endpointPaths = this.val$p.endpointPaths;
                    this.order = this.val$p.order;
                }
            }).collect(Collectors.toList());
        } else if (info instanceof GraphQlProblem) {
            p2 = (GraphQlProblem)info;
            dto.graphQLProblem = new GraphQLProblemDto();
            dto.graphQLProblem.endpoint = EMController.removePrefix(((GraphQlProblem)p2).getEndpoint(), this.baseUrlOfSUT);
            dto.graphQLProblem.servicesToNotMock = servicesToNotMock;
        } else if (info instanceof RPCProblem) {
            try {
                dto.rpcProblem = this.noKillSwitch(() -> this.sutController.extractRPCProblemDto(dto.isSutRunning));
                dto.rpcProblem.servicesToNotMock = servicesToNotMock;
                dto.errorMsg = SimpleLogger.getRecordedErrorMsg();
            }
            catch (RuntimeException e) {
                String msg = e.getMessage();
                SimpleLogger.error(msg, e);
                return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            }
        } else if (info instanceof WebProblem) {
            p2 = (WebProblem)info;
            dto.webProblem = new WebProblemDto();
            dto.webProblem.urlPathOfStartingPage = ((WebProblem)p2).getUrlPathOfStartingPage();
            dto.webProblem.servicesToNotMock = servicesToNotMock;
        } else {
            String msg = "Unrecognized problem type: " + info.getClass().getName();
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        dto.unitsInfoDto = this.noKillSwitch(() -> this.sutController.getUnitsInfoDto());
        if (dto.unitsInfoDto == null) {
            String msg = "Failed to extract units info";
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
    }

    @Path(value="/controllerInfo")
    @GET
    public Response getControllerInfoDto(@Context HttpServletRequest httpServletRequest, @QueryParam(value="methodReplacementCategories") String methodReplacementCategories) {
        if (methodReplacementCategories != null && !methodReplacementCategories.isEmpty()) {
            System.setProperty("evomaster.javaagent.replacement_categories", methodReplacementCategories);
        }
        assert (this.trackRequestSource(httpServletRequest));
        ControllerInfoDto dto = new ControllerInfoDto();
        dto.fullName = this.noKillSwitch(() -> this.sutController.getClass().getName());
        dto.isInstrumentationOn = this.noKillSwitch(() -> this.sutController.isInstrumentationActivated());
        dto.executableFullPath = this.noKillSwitch(() -> this.sutController.getExecutableFullPath());
        return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
    }

    @Path(value="/newSearch")
    @POST
    public Response newSearch(@Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        this.lastSqlCommandId = null;
        this.noKillSwitch(() -> this.sutController.newSearch());
        return Response.status(201).entity(WrappedResponseDto.withNoData()).build();
    }

    @Path(value="/postSearchAction")
    @POST
    @Consumes(value={"application/json;charset=utf8;version=1"})
    public Response postSearchAction(PostSearchActionDto dto, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        try {
            this.noKillSwitch(() -> this.sutController.postSearchAction(dto));
        }
        catch (RuntimeException e) {
            String msg = "Failed to process post actions after search:" + e.getMessage();
            SimpleLogger.error(msg);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(201).entity(WrappedResponseDto.withNoData()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/runSUT")
    @PUT
    @Consumes(value={"application/json;charset=utf8;version=1"})
    public Response runSut(SutRunDto dto, @Context HttpServletRequest httpServletRequest) {
        if (dto != null && dto.methodReplacementCategories != null && !dto.methodReplacementCategories.isEmpty()) {
            System.setProperty("evomaster.javaagent.replacement_categories", dto.methodReplacementCategories);
        }
        assert (this.trackRequestSource(httpServletRequest));
        ExecutionTracer.setKillSwitch(false);
        if (this.sutController.isSutRunning()) {
            this.sutController.setKillSwitch(false);
        }
        try {
            if (dto.run == null) {
                String msg = "Invalid JSON: 'run' field is required";
                SimpleLogger.warn(msg);
                return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
            }
            boolean sqlHeuristics = dto.calculateSqlHeuristics != null && dto.calculateSqlHeuristics != false;
            boolean sqlExecution = dto.extractSqlExecutionInfo != null && dto.extractSqlExecutionInfo != false;
            boolean advancedHeuristics = dto.advancedHeuristics != null && dto.advancedHeuristics != false;
            this.noKillSwitch(() -> this.sutController.enableComputeSqlHeuristicsOrExtractExecution(sqlHeuristics, sqlExecution, advancedHeuristics));
            boolean doReset = dto.resetState != null && dto.resetState != false;
            EMController eMController = this;
            synchronized (eMController) {
                if (!dto.run.booleanValue()) {
                    if (doReset) {
                        String msg = "Invalid JSON: cannot reset state and stop service at same time";
                        SimpleLogger.warn(msg);
                        return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                    }
                    if (this.noKillSwitch(() -> this.sutController.isSutRunning()).booleanValue()) {
                        this.noKillSwitch(() -> this.sutController.stopSut());
                        this.baseUrlOfSUT = null;
                    }
                } else {
                    if (!this.noKillSwitch(() -> this.sutController.isSutRunning()).booleanValue()) {
                        this.noKillSwitch(() -> this.sutController.bootingSut(true));
                        this.baseUrlOfSUT = this.noKillSwitch(() -> this.sutController.startSut());
                        this.noKillSwitch(() -> this.sutController.bootingSut(false));
                        if (this.baseUrlOfSUT == null) {
                            String msg = "Internal failure: cannot start SUT based on given configuration";
                            SimpleLogger.warn(msg);
                            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
                        }
                        this.noKillSwitch(() -> this.sutController.initSqlHandler());
                        this.noKillSwitch(() -> this.sutController.registerOrExecuteInitSqlCommandsIfNeeded(true));
                        this.noKillSwitch(() -> this.sutController.initMongoHandler());
                    } else {
                        this.noKillSwitch(() -> this.sutController.bootingSut(false));
                    }
                    if (dto.resetState != null && dto.resetState.booleanValue()) {
                        try {
                            this.noKillSwitchForceCheck(() -> this.sutController.cleanAccessedTables());
                            if (dto.resetCustomizedMethodForMockObject != null && dto.resetCustomizedMethodForMockObject.booleanValue()) {
                                this.noKillSwitch(() -> this.sutController.resetCustomizedMethodForMockObject());
                            }
                            this.noKillSwitchForceCheck(() -> this.sutController.resetStateOfSUT());
                        }
                        finally {
                            this.noKillSwitch(() -> this.sutController.newTest());
                        }
                    }
                }
            }
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
    }

    @Path(value="/testResults")
    @GET
    public Response getTestResults(@QueryParam(value="ids") @DefaultValue(value="") String idList, @QueryParam(value="killSwitch") @DefaultValue(value="false") boolean killSwitch, @QueryParam(value="fullyCovered") @DefaultValue(value="false") boolean fullyCovered, @QueryParam(value="descriptiveIds") @DefaultValue(value="false") boolean descriptiveIds, @QueryParam(value="queryFromDatabase") @DefaultValue(value="true") boolean queryFromDatabase, @Context HttpServletRequest httpServletRequest) {
        this.noKillSwitch(() -> this.sutController.setExecutingAction(false));
        assert (this.trackRequestSource(httpServletRequest));
        try {
            Set ids;
            if (idList != null && !idList.isEmpty()) {
                try {
                    ids = Arrays.stream(idList.split(",")).filter(s -> !s.trim().isEmpty()).map(Integer::parseInt).collect(Collectors.toSet());
                }
                catch (NumberFormatException e) {
                    String msg = "Invalid parameter 'ids': " + e.getMessage();
                    SimpleLogger.warn(msg);
                    return Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                }
            } else {
                ids = null;
            }
            List targetInfos = this.noKillSwitch(() -> this.sutController.getTargetInfos(ids, fullyCovered, descriptiveIds));
            if (targetInfos == null) {
                String label = "all";
                if (ids != null) {
                    label = "" + ids.size();
                }
                String msg = "Failed to collect target information for " + label + " ids";
                SimpleLogger.error(msg);
                return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            }
            TestResultsDto dto = new TestResultsDto();
            targetInfos.forEach(t -> {
                TargetInfoDto info = new TargetInfoDto();
                info.id = t.mappedId;
                info.value = t.value;
                info.descriptiveId = t.descriptiveId;
                info.actionIndex = t.actionIndex;
                dto.targets.add(info);
            });
            dto.extraHeuristics = this.noKillSwitch(() -> this.sutController.getExtraHeuristics(queryFromDatabase));
            List additionalInfos = this.noKillSwitch(() -> this.sutController.getAdditionalInfoList());
            if (additionalInfos == null) {
                String msg = "Failed to collect additional info";
                SimpleLogger.error(msg);
                return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            }
            additionalInfos.forEach(a -> {
                AdditionalInfoDto info = new AdditionalInfoDto();
                info.queryParameters = new HashSet<String>(a.getQueryParametersView());
                info.headers = new HashSet<String>(a.getHeadersView());
                info.lastExecutedStatement = a.getLastExecutedStatement();
                info.rawAccessOfHttpBodyPayload = a.isRawAccessOfHttpBodyPayload();
                info.parsedDtoNames = new HashSet<String>(a.getParsedDtoNamesView());
                info.hostnameResolutionInfoDtos = a.getHostnameInfos().stream().map(hn -> new HostnameResolutionInfoDto(hn.getHostname(), hn.getResolvedAddress())).collect(Collectors.toList());
                info.externalServices = a.getExternalServices().stream().map(es -> new ExternalServiceInfoDto(es.getProtocol(), es.getHostname(), es.getRemotePort())).collect(Collectors.toList());
                info.employedDefaultWM = a.getEmployedDefaultWM().stream().map(des -> new ExternalServiceInfoDto(des.getProtocol(), des.getHostname(), des.getRemotePort())).collect(Collectors.toList());
                info.stringSpecializations = new LinkedHashMap<String, List<StringSpecializationInfoDto>>();
                for (Map.Entry<String, Set<StringSpecializationInfo>> entry : a.getStringSpecializationsView().entrySet()) {
                    assert (!entry.getValue().isEmpty());
                    List list = entry.getValue().stream().map(it -> new StringSpecializationInfoDto(it.getStringSpecialization().toString(), it.getValue(), it.getType().toString())).collect(Collectors.toList());
                    info.stringSpecializations.put(entry.getKey(), list);
                }
                dto.additionalInfoList.add(info);
            });
            if (killSwitch) {
                this.sutController.setKillSwitch(true);
            }
            return Response.status(200).entity(WrappedResponseDto.withData(dto)).build();
        }
        catch (RuntimeException e) {
            String msg = "Thrown exception: " + e.getMessage();
            SimpleLogger.error(msg, e);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
    }

    @Path(value="/scheduleTasksCommand")
    @Consumes(value={"application/json"})
    @POST
    public Response scheduleTasksCommand(ScheduleTaskInvocationsDto command, @QueryParam(value="killSwitch") @DefaultValue(value="false") boolean killSwitch, @QueryParam(value="queryFromDatabase") @DefaultValue(value="true") boolean queryFromDatabase, @Context HttpServletRequest httpServletRequest) {
        ScheduleTaskInvocationsResult responseDto = new ScheduleTaskInvocationsResult();
        if (command.tasks != null && !command.tasks.isEmpty()) {
            try {
                this.noKillSwitchForceCheck(() -> this.sutController.invokeScheduleTasks(command.tasks, responseDto, queryFromDatabase));
            }
            catch (Exception e) {
                String msg = "Thrown exception in executing schedule task: " + e.getMessage();
                SimpleLogger.error(msg, e);
                responseDto.error500Msg = msg;
                return Response.status(500).entity(WrappedResponseDto.withData(responseDto)).build();
            }
        }
        if (killSwitch) {
            this.sutController.setKillSwitch(true);
        }
        return Response.status(200).entity(WrappedResponseDto.withData(responseDto)).build();
    }

    @Path(value="/deriveParams")
    @Consumes(value={"application/json"})
    @POST
    public Response deriveParams(List<DerivedParamChangeReqDto> dtos) {
        ArrayList results = new ArrayList();
        ArrayList errors = new ArrayList();
        for (DerivedParamChangeReqDto dto : dtos) {
            this.noKillSwitch(() -> {
                try {
                    String value = this.sutController.deriveObjectParameterData(dto.paramName, dto.jsonData, dto.entryPoint);
                    DeriveParamResponseDto response = new DeriveParamResponseDto();
                    response.paramName = dto.paramName;
                    response.paramValue = value;
                    response.actionIndex = dto.actionIndex;
                    results.add(response);
                }
                catch (Exception e) {
                    String msg = "ERROR: failed to derived object parameter for '" + dto.paramName + "': " + e.getMessage();
                    SimpleLogger.error(msg, e);
                    errors.add(msg);
                }
            });
        }
        if (!errors.isEmpty()) {
            String msg = "There were " + errors.size() + " errors.\n";
            msg = msg + String.join((CharSequence)"\n", errors);
            return Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
        }
        return Response.status(200).entity(WrappedResponseDto.withData(results)).build();
    }

    @Path(value="/newAction")
    @Consumes(value={"application/json"})
    @PUT
    public Response newAction(ActionDto dto, @QueryParam(value="queryFromDatabase") @DefaultValue(value="true") boolean queryFromDatabase, @Context HttpServletRequest httpServletRequest) {
        this.noKillSwitch(() -> this.sutController.setExecutingAction(true));
        assert (!ExecutionTracer.isExecutingInitSql());
        Integer index = dto.index;
        Integer current = this.sutController.getActionIndex();
        if (index == current) {
            SimpleLogger.warn("Repeated PUT on newAction for same index " + index);
        } else {
            assert (this.trackRequestSource(httpServletRequest));
            this.sutController.newAction(dto, queryFromDatabase);
            if (dto.rpcCall != null) {
                ActionResponseDto authResponseDto = null;
                if (dto.rpcCall.authSetup != null) {
                    authResponseDto = new ActionResponseDto();
                    try {
                        if (LocalAuthSetupSchema.isLocalAuthSetup(dto.rpcCall.authSetup)) {
                            this.sutController.executeHandleLocalAuthenticationSetup(dto.rpcCall.authSetup, authResponseDto);
                        } else {
                            this.sutController.executeAction(dto.rpcCall.authSetup, authResponseDto);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Fail to execute auth setup and thrown exception: " + e.getMessage();
                        SimpleLogger.error(msg, e);
                    }
                }
                ActionResponseDto responseDto = new ActionResponseDto();
                responseDto.index = index;
                try {
                    this.sutController.executeAction(dto.rpcCall, responseDto);
                    if (authResponseDto != null && authResponseDto.testScript != null && !authResponseDto.testScript.isEmpty()) {
                        responseDto.testScript.addAll(0, authResponseDto.testScript);
                    }
                    return Response.status(200).entity(WrappedResponseDto.withData(responseDto)).build();
                }
                catch (Exception e) {
                    String msg = "Thrown exception: " + e.getMessage();
                    SimpleLogger.error(msg, e);
                    responseDto.error500Msg = msg;
                    return Response.status(500).entity(WrappedResponseDto.withData(responseDto)).build();
                }
            }
        }
        return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/databaseCommand")
    @Consumes(value={"application/json;charset=utf8;version=1"})
    @POST
    public Response executeDatabaseCommand(DatabaseCommandDto dto, @Context HttpServletRequest httpServletRequest) {
        Integer id = dto.idCounter;
        if (id != null) {
            if (this.lastSqlCommandId != null && id <= this.lastSqlCommandId) {
                SimpleLogger.warn("SQL command with id " + id + " has not arrived in order. Last received id : " + this.lastSqlCommandId);
                if (dto.insertions != null && !dto.insertions.isEmpty()) {
                    return Response.status(204).entity(WrappedResponseDto.withNoData()).build();
                }
            }
            this.lastSqlCommandId = id;
        }
        assert (this.trackRequestSource(httpServletRequest));
        try {
            InsertionResultsDto insertionResultsDto;
            this.sutController.setExecutingInitSql(true);
            this.noKillSwitch(() -> this.sutController.addTableToInserted(dto.insertions.stream().map(x -> x.targetTable).collect(Collectors.toList())));
            SimpleLogger.debug("Received database command");
            Connection connection = this.noKillSwitch(() -> this.sutController.getConnectionIfExist());
            if (connection == null) {
                String msg = "No active database connection";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            if (dto.command == null && (dto.insertions == null || dto.insertions.isEmpty())) {
                String msg = "No input command";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            if (dto.command != null && dto.insertions != null && !dto.insertions.isEmpty()) {
                String msg = "Only 1 command can be specified";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            if (dto.insertions != null && dto.insertions.stream().anyMatch(i -> i.targetTable == null || i.targetTable.isEmpty())) {
                String msg = "Insertion with no target table";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            QueryResult queryResult = null;
            try {
                if (dto.command != null) {
                    insertionResultsDto = null;
                    queryResult = SqlScriptRunner.execCommand(connection, dto.command);
                } else {
                    insertionResultsDto = SqlScriptRunner.execInsert(connection, dto.insertions, new InsertionResultsDto[0]);
                    this.noKillSwitch(() -> {
                        for (int i = 0; i < insertionResultsDto.executionResults.size(); ++i) {
                            if (!insertionResultsDto.executionResults.get(i).booleanValue()) continue;
                            this.sutController.addSuccessfulInitSqlInsertion(dto.insertions.get(i));
                        }
                    });
                }
            }
            catch (Exception e) {
                String msg = "Failed to execute database command: " + e.getMessage();
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                this.sutController.setExecutingInitSql(false);
                return response;
            }
            if (queryResult != null) {
                Response response = Response.status(200).entity(WrappedResponseDto.withData(queryResult.toDto())).build();
                return response;
            }
            if (insertionResultsDto != null) {
                Response response = Response.status(200).entity(WrappedResponseDto.withData(insertionResultsDto)).build();
                return response;
            }
            Response response = Response.status(204).entity(WrappedResponseDto.withNoData()).build();
            return response;
        }
        catch (RuntimeException e) {
            String msg = "Thrown exception: " + e.getMessage();
            SimpleLogger.error(msg, e);
            Response response = Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            return response;
        }
        finally {
            this.sutController.setExecutingInitSql(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/mongoInsertion")
    @Consumes(value={"application/json;charset=utf8;version=1"})
    @POST
    public Response executeMongoInsertion(MongoDatabaseCommandDto dto, @Context HttpServletRequest httpServletRequest) {
        assert (this.trackRequestSource(httpServletRequest));
        try {
            this.sutController.setExecutingInitMongo(true);
            SimpleLogger.debug("Received mongo database command");
            Object connection = this.noKillSwitch(this.sutController::getMongoConnection);
            if (connection == null) {
                String msg = "No active database connection";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            if (dto.insertions == null || dto.insertions.isEmpty()) {
                String msg = "No input command";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            if (dto.insertions.stream().anyMatch(i -> i.collectionName.isEmpty() || i.databaseName.isEmpty())) {
                String msg = "Insertion with no target collection or database";
                SimpleLogger.warn(msg);
                Response response = Response.status(400).entity(WrappedResponseDto.withError(msg)).build();
                return response;
            }
            MongoInsertionResultsDto mongoInsertionResultsDto = null;
            try {
                mongoInsertionResultsDto = MongoScriptRunner.executeInsert(connection, dto.insertions);
            }
            catch (Exception e) {
                String msg = "Failed to execute database command: " + e.getMessage();
                SimpleLogger.warn(msg);
                mongoInsertionResultsDto = new MongoInsertionResultsDto();
                mongoInsertionResultsDto.handleFailedInsertion(dto.insertions, e);
                Response response = Response.status(400).entity(WrappedResponseDto.withData(mongoInsertionResultsDto)).build();
                this.sutController.setExecutingInitMongo(false);
                return response;
            }
            if (mongoInsertionResultsDto != null) {
                Response response = Response.status(200).entity(WrappedResponseDto.withData(mongoInsertionResultsDto)).build();
                return response;
            }
            Response response = Response.status(204).entity(WrappedResponseDto.withNoData()).build();
            return response;
        }
        catch (RuntimeException e) {
            String msg = "Thrown exception: " + e.getMessage();
            SimpleLogger.error(msg, e);
            Response response = Response.status(500).entity(WrappedResponseDto.withError(msg)).build();
            return response;
        }
        finally {
            this.sutController.setExecutingInitMongo(false);
        }
    }
}

