/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.Base64DecoderClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.BooleanClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ByteClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.CharacterClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.CollectionClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DateClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DateFormatClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.DoubleClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.EnumClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.FloatClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.InetAddressClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.InetSocketAddressClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.IntegerClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalDateClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalDateTimeClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LocalTimeClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.LongClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MapClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MatcherClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.MethodClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ObjectClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ObjectsClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.PatternClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.PreparedStatementClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ShortClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.SocketClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.StatementClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.StringClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.ThreadMethodReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.URIClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.URLClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes.UUIDClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.AbstractEndpointClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.CursorPreparerClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.DocumentClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.GsonClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.Http11ProcessorReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.HttpServletRequestClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.JacksonObjectMapperClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.MappingMongoEntityInformationClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.MessageBodyReaderClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.MongoCollectionClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.MongoTemplateClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.ObjectIdClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.OkHttpClient3BuilderClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.OkHttpClient3ClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.OkHttpClientClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.OkUrlFactoryClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.OpenSearchClientClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.ProviderBaseClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.ServletRequestClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.ValidatorClassReplacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses.WebRequestClassReplacement;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.utils.SimpleLogger;

public class ReplacementList {
    private static List<MethodReplacementClass> listCache;

    public static List<MethodReplacementClass> getList() {
        List shaded;
        if (listCache == null && (shaded = (listCache = Arrays.asList(new AbstractEndpointClassReplacement(), new Base64DecoderClassReplacement(), new BooleanClassReplacement(), new ByteClassReplacement(), new CharacterClassReplacement(), new CollectionClassReplacement(), new CursorPreparerClassReplacement(), new DateClassReplacement(), new DateFormatClassReplacement(), new DocumentClassReplacement(), new DoubleClassReplacement(), new EnumClassReplacement(), new FloatClassReplacement(), new GsonClassReplacement(), new Http11ProcessorReplacementClass(), new HttpServletRequestClassReplacement(), new IntegerClassReplacement(), new InetAddressClassReplacement(), new InetSocketAddressClassReplacement(), new JacksonObjectMapperClassReplacement(), new LocalDateClassReplacement(), new LocalDateTimeClassReplacement(), new LocalTimeClassReplacement(), new LongClassReplacement(), new MapClassReplacement(), new MatcherClassReplacement(), new MessageBodyReaderClassReplacement(), new MethodClassReplacement(), new MongoCollectionClassReplacement(), new MongoTemplateClassReplacement(), new OpenSearchClientClassReplacement(), new MappingMongoEntityInformationClassReplacement(), new OkHttpClient3BuilderClassReplacement(), new OkHttpClient3ClassReplacement(), new OkHttpClientClassReplacement(), new OkUrlFactoryClassReplacement(), new ObjectClassReplacement(), new ObjectIdClassReplacement(), new ObjectsClassReplacement(), new PatternClassReplacement(), new PreparedStatementClassReplacement(), new ProviderBaseClassReplacement(), new StatementClassReplacement(), new StringClassReplacement(), new ShortClassReplacement(), new ServletRequestClassReplacement(), new SocketClassReplacement(), new ThreadMethodReplacement(), new URIClassReplacement(), new URLClassReplacement(), new UUIDClassReplacement(), new ValidatorClassReplacement(), new WebRequestClassReplacement())).stream().map(c -> c.getTargetClassName()).filter(n -> n.startsWith("shaded.")).collect(Collectors.toList())).size() > 0) {
            throw new IllegalStateException("Shaded dependencies ended up in the ReplacementList: " + String.join((CharSequence)",", shaded));
        }
        return listCache;
    }

    public static List<MethodReplacementClass> getReplacements(String target) {
        return ReplacementList.getReplacements(target, false);
    }

    public static List<MethodReplacementClass> getReplacements(String target, boolean strict) {
        Objects.requireNonNull(target);
        String targetClassName = ClassName.get(target).getFullNameWithDots();
        List<MethodReplacementClass> list = ReplacementList.getList().stream().filter(t -> {
            boolean jdk;
            if (strict) {
                return t.getTargetClassName().equals(targetClassName);
            }
            if (targetClassName.equals("java.lang.Module")) {
                return false;
            }
            HashSet<String> prefixes = new HashSet<String>();
            prefixes.add("java.lang.");
            prefixes.add("java.util.");
            prefixes.add("java.time.");
            prefixes.add("java.net.");
            prefixes.add("java.sql.Statement");
            prefixes.add("java.sql.CallableStatement");
            prefixes.add("java.sql.PreparedStatement");
            boolean bl = jdk = prefixes.stream().anyMatch(k -> targetClassName.startsWith((String)k)) && prefixes.stream().anyMatch(k -> t.getTargetClassName().startsWith((String)k));
            if (jdk) {
                Class<?> klass;
                try {
                    klass = Class.forName(targetClassName);
                }
                catch (Exception e) {
                    SimpleLogger.warn("Cannot load JDK class " + targetClassName);
                    return false;
                }
                return t.getTargetClass(ReplacementList.class.getClassLoader()).isAssignableFrom(klass);
            }
            return t.getTargetClassName().equals(targetClassName);
        }).collect(Collectors.toList());
        assert (!strict || list.size() <= 1);
        return list;
    }
}

