/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.evomaster.client.java.instrumentation.ExecutedSqlCommand;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import shaded.net.sf.jsqlparser.JSQLParserException;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;

public class StatementClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Statement.class;
    }

    static void handleSql(String sqlCommand, boolean threwSqlException, long executionTime) {
        if (sqlCommand != null) {
            String formattedSqlCommand = StatementClassReplacement.formatSqlCommand(sqlCommand);
            ExecutedSqlCommand info = new ExecutedSqlCommand(formattedSqlCommand, threwSqlException, executionTime);
            ExecutionTracer.addSqlInfo(info);
        }
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static ResultSet executeQuery(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeQuery(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static int executeUpdate(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static boolean execute(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static int executeUpdate(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static int executeUpdate(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static int executeUpdate(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeUpdate(sql, columnNames), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static boolean execute(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static boolean execute(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static boolean execute(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.execute(sql, columnNames), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static long executeLargeUpdate(Statement caller, String sql) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static long executeLargeUpdate(Statement caller, String sql, int autoGeneratedKeys) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, autoGeneratedKeys), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static long executeLargeUpdate(Statement caller, String sql, int[] columnIndexes) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, columnIndexes), sql);
    }

    @Replacement(type=ReplacementType.TRACKER, isPure=false, category=ReplacementCategory.SQL)
    public static long executeLargeUpdate(Statement caller, String sql, String[] columnNames) throws SQLException {
        return StatementClassReplacement.executeSql(() -> caller.executeLargeUpdate(sql, columnNames), sql);
    }

    public static <T> T executeSql(SqlExecutionSupplier<T, SQLException> executeStatement, String sql) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            T result = executeStatement.get();
            long end = System.currentTimeMillis();
            StatementClassReplacement.handleSql(sql, false, end - start);
            return result;
        }
        catch (SQLException e) {
            StatementClassReplacement.handleSql(sql, true, -1L);
            throw e;
        }
    }

    private static String formatSqlCommand(String sqlCommand) {
        if (!sqlCommand.equals("")) {
            try {
                return CCJSqlParserUtil.parse(sqlCommand).toString();
            }
            catch (JSQLParserException jSQLParserException) {
                // empty catch block
            }
        }
        return sqlCommand;
    }

    @FunctionalInterface
    public static interface SqlExecutionSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

