/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.shared;

import java.util.HashMap;
import java.util.Objects;

public class RegexSharedUtils {
    public static String removeParentheses(String regex) {
        String s = regex.trim();
        if (!s.startsWith("(") || s.endsWith(")")) {
            // empty if block
        }
        return s;
    }

    public static String forceFullMatch(String regex) {
        String s = RegexSharedUtils.removeParentheses(regex);
        if (s.startsWith("^") && s.endsWith("$")) {
            return s;
        }
        if (s.startsWith("^")) {
            return s + "$";
        }
        if (s.endsWith("$")) {
            return "^" + s;
        }
        return "^(" + s + ")$";
    }

    public static String handlePartialMatch(String regex) {
        String s = RegexSharedUtils.removeParentheses(regex);
        if (s.startsWith("^") && s.endsWith("$")) {
            return s;
        }
        if (s.startsWith("^")) {
            return s + "([\\s\\S]*)";
        }
        if (s.endsWith("$")) {
            return "([\\s\\S]*)" + s;
        }
        return String.format("([\\s\\S]*)(%s)([\\s\\S]*)", regex);
    }

    public static String translateSqlLikePattern(String likePattern) {
        Objects.requireNonNull(likePattern);
        String escapeSymbol = "\\";
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("%", ".*");
        replacements.put("_", ".");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < likePattern.length(); ++i) {
            String currentSymbol = String.valueOf(likePattern.charAt(i));
            if (currentSymbol.equals(escapeSymbol) && i < likePattern.length() - 1) {
                builder.append(likePattern.charAt(++i));
                continue;
            }
            if (replacements.containsKey(currentSymbol)) {
                builder.append((String)replacements.get(currentSymbol));
                continue;
            }
            builder.append(currentSymbol);
        }
        return builder.toString();
    }

    public static String translateSqlSimilarToPattern(String similarToPattern) {
        Objects.requireNonNull(similarToPattern);
        return RegexSharedUtils.translateSqlLikePattern(similarToPattern);
    }

    public static String translatePostgresqlPosix(String posixPattern, boolean caseSensitive) {
        Objects.requireNonNull(posixPattern);
        if (!caseSensitive) {
            throw new IllegalArgumentException("Case insensitive handling not implemented yet");
        }
        return RegexSharedUtils.translateSqlSimilarToPattern(posixPattern);
    }
}

