/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.distance.heuristics.TruthnessUtils;
import org.evomaster.client.java.instrumentation.shared.RegexSharedUtils;
import org.evomaster.client.java.sql.DataRow;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.SqlDataType;
import org.evomaster.client.java.sql.VariableDescriptor;
import org.evomaster.client.java.sql.heuristic.BooleanLiteralsHelper;
import org.evomaster.client.java.sql.heuristic.ConversionHelper;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlCastHelper;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicResult;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicsCalculator;
import org.evomaster.client.java.sql.heuristic.SqlStringUtils;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.heuristic.function.FunctionFinder;
import org.evomaster.client.java.sql.heuristic.function.SqlAggregateFunction;
import org.evomaster.client.java.sql.heuristic.function.SqlFunction;
import org.evomaster.client.java.sql.internal.TaintHandler;
import shaded.net.sf.jsqlparser.expression.AllValue;
import shaded.net.sf.jsqlparser.expression.AnalyticExpression;
import shaded.net.sf.jsqlparser.expression.AnyComparisonExpression;
import shaded.net.sf.jsqlparser.expression.AnyType;
import shaded.net.sf.jsqlparser.expression.ArrayConstructor;
import shaded.net.sf.jsqlparser.expression.ArrayExpression;
import shaded.net.sf.jsqlparser.expression.BinaryExpression;
import shaded.net.sf.jsqlparser.expression.CaseExpression;
import shaded.net.sf.jsqlparser.expression.CastExpression;
import shaded.net.sf.jsqlparser.expression.CollateExpression;
import shaded.net.sf.jsqlparser.expression.ConnectByRootOperator;
import shaded.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import shaded.net.sf.jsqlparser.expression.DateValue;
import shaded.net.sf.jsqlparser.expression.DoubleValue;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.expression.ExtractExpression;
import shaded.net.sf.jsqlparser.expression.Function;
import shaded.net.sf.jsqlparser.expression.HexValue;
import shaded.net.sf.jsqlparser.expression.IntervalExpression;
import shaded.net.sf.jsqlparser.expression.JdbcNamedParameter;
import shaded.net.sf.jsqlparser.expression.JdbcParameter;
import shaded.net.sf.jsqlparser.expression.JsonAggregateFunction;
import shaded.net.sf.jsqlparser.expression.JsonExpression;
import shaded.net.sf.jsqlparser.expression.JsonFunction;
import shaded.net.sf.jsqlparser.expression.KeepExpression;
import shaded.net.sf.jsqlparser.expression.LongValue;
import shaded.net.sf.jsqlparser.expression.MySQLGroupConcat;
import shaded.net.sf.jsqlparser.expression.NextValExpression;
import shaded.net.sf.jsqlparser.expression.NotExpression;
import shaded.net.sf.jsqlparser.expression.NullValue;
import shaded.net.sf.jsqlparser.expression.NumericBind;
import shaded.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import shaded.net.sf.jsqlparser.expression.OracleHint;
import shaded.net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import shaded.net.sf.jsqlparser.expression.OverlapsCondition;
import shaded.net.sf.jsqlparser.expression.Parenthesis;
import shaded.net.sf.jsqlparser.expression.RangeExpression;
import shaded.net.sf.jsqlparser.expression.RowConstructor;
import shaded.net.sf.jsqlparser.expression.RowGetExpression;
import shaded.net.sf.jsqlparser.expression.SignedExpression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.TimeKeyExpression;
import shaded.net.sf.jsqlparser.expression.TimeValue;
import shaded.net.sf.jsqlparser.expression.TimestampValue;
import shaded.net.sf.jsqlparser.expression.TimezoneExpression;
import shaded.net.sf.jsqlparser.expression.TranscodingFunction;
import shaded.net.sf.jsqlparser.expression.TrimFunction;
import shaded.net.sf.jsqlparser.expression.UserVariable;
import shaded.net.sf.jsqlparser.expression.VariableAssignment;
import shaded.net.sf.jsqlparser.expression.WhenClause;
import shaded.net.sf.jsqlparser.expression.XMLSerializeExpr;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import shaded.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import shaded.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import shaded.net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Between;
import shaded.net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.ContainedBy;
import shaded.net.sf.jsqlparser.expression.operators.relational.Contains;
import shaded.net.sf.jsqlparser.expression.operators.relational.DoubleAnd;
import shaded.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import shaded.net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.InExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.Matches;
import shaded.net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import shaded.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import shaded.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import shaded.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperatorType;
import shaded.net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import shaded.net.sf.jsqlparser.expression.operators.relational.TSQLLeftJoin;
import shaded.net.sf.jsqlparser.expression.operators.relational.TSQLRightJoin;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.create.table.ColDataType;
import shaded.net.sf.jsqlparser.statement.select.AllColumns;
import shaded.net.sf.jsqlparser.statement.select.AllTableColumns;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;

public class SqlExpressionEvaluator
extends ExpressionVisitorAdapter {
    public static final char BITWISE_NOT = '~';
    public static final char MINUS = '-';
    public static final char PLUS = '+';
    private final SqlHeuristicsCalculator parentStatementEvaluator;
    private final TableColumnResolver tableColumnResolver;
    private final TaintHandler taintHandler;
    private final QueryResultSet queryResultSet;
    private final Stack<Object> evaluationStack = new Stack();
    private final Deque<DataRow> dataRowStack = new ArrayDeque<DataRow>();
    private final Deque<QueryResult> queryResultStack = new ArrayDeque<QueryResult>();

    private SqlExpressionEvaluator(SqlHeuristicsCalculator parentStatementEvaluator, TableColumnResolver tableColumnResolver, TaintHandler taintHandler, QueryResultSet queryResultSet, Deque<DataRow> dataRowStack, DataRow currentDataRow, Deque<QueryResult> queryResultStack, QueryResult currentQueryResult) {
        this.parentStatementEvaluator = parentStatementEvaluator;
        this.tableColumnResolver = tableColumnResolver;
        this.taintHandler = taintHandler;
        this.queryResultSet = queryResultSet;
        if (dataRowStack != null) {
            this.dataRowStack.addAll(dataRowStack);
        }
        if (currentDataRow != null) {
            this.dataRowStack.push(currentDataRow);
        }
        if (queryResultStack != null) {
            this.queryResultStack.addAll(queryResultStack);
        }
        if (currentQueryResult != null) {
            this.queryResultStack.push(currentQueryResult);
        }
    }

    private Object popAsSingleValue() {
        Object value = this.evaluationStack.pop();
        if (value instanceof List) {
            return ((List)value).get(0);
        }
        if (value instanceof QueryResult) {
            QueryResult queryResult = (QueryResult)value;
            return queryResult.seeRows().get(0).getValue(0);
        }
        return value;
    }

    private List<Object> popAsListOfValues() {
        List rightValuesList;
        Object rightValues = this.evaluationStack.pop();
        if (rightValues instanceof QueryResult) {
            QueryResult queryResult = (QueryResult)rightValues;
            rightValuesList = queryResult.seeRows().stream().map(row -> row.getValue(0)).collect(Collectors.toList());
        } else {
            rightValuesList = (List)rightValues;
        }
        return rightValuesList;
    }

    public Truthness getEvaluatedTruthness() {
        if (this.evaluationStack.isEmpty()) {
            throw new IllegalStateException("no Truthness was computed");
        }
        return ConversionHelper.convertToTruthness(this.evaluationStack.peek());
    }

    public Object getEvaluatedValue() {
        if (this.evaluationStack.isEmpty()) {
            throw new IllegalStateException("no value was computed");
        }
        return this.evaluationStack.peek();
    }

    private static ComparisonOperatorType toComparisonOperatorType(ComparisonOperator comparisonOperator) {
        if (comparisonOperator instanceof EqualsTo) {
            return ComparisonOperatorType.EQUALS_TO;
        }
        if (comparisonOperator instanceof NotEqualsTo) {
            return ComparisonOperatorType.NOT_EQUALS_TO;
        }
        if (comparisonOperator instanceof GreaterThan) {
            return ComparisonOperatorType.GREATER_THAN;
        }
        if (comparisonOperator instanceof GreaterThanEquals) {
            return ComparisonOperatorType.GREATER_THAN_EQUALS;
        }
        if (comparisonOperator instanceof MinorThan) {
            return ComparisonOperatorType.MINOR_THAN;
        }
        if (comparisonOperator instanceof MinorThanEquals) {
            return ComparisonOperatorType.MINOR_THAN_EQUALS;
        }
        throw new IllegalArgumentException("Unsupported ComparisonOperator: " + comparisonOperator.getClass().getName());
    }

    private void visitComparisonOperator(ComparisonOperator comparisonOperator) {
        Truthness truthness;
        ComparisonOperatorType comparisonOperatorType = SqlExpressionEvaluator.toComparisonOperatorType(comparisonOperator);
        if (this.evaluationStack.peek() instanceof EvaluatedAnyComparisonExpression) {
            EvaluatedAnyComparisonExpression evaluatedAnyComparisonExpression = (EvaluatedAnyComparisonExpression)this.evaluationStack.pop();
            Object concreteLeftValue = this.popAsSingleValue();
            List<Object> rightValues = evaluatedAnyComparisonExpression.getValues();
            switch (evaluatedAnyComparisonExpression.getAnyType()) {
                case ALL: {
                    truthness = this.all(concreteLeftValue, rightValues, comparisonOperatorType);
                    break;
                }
                default: {
                    truthness = this.any(concreteLeftValue, rightValues, comparisonOperatorType);
                    break;
                }
            }
        } else {
            Object concreteRightValue = this.popAsSingleValue();
            Object concreteLeftValue = this.popAsSingleValue();
            truthness = this.evaluateTruthnessForComparisonOperator(concreteLeftValue, concreteRightValue, comparisonOperatorType);
        }
        this.evaluationStack.push(truthness);
    }

    private Truthness any(Object concreteLeftValue, List<Object> concreteRightValues, ComparisonOperatorType comparisonOperatorType) {
        Truthness truthness;
        if (concreteRightValues.isEmpty()) {
            truthness = SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        } else {
            Truthness[] truthnesses = concreteRightValues.stream().map(rightValue -> this.evaluateTruthnessForComparisonOperator(concreteLeftValue, rightValue, comparisonOperatorType)).collect(Collectors.toList()).toArray(new Truthness[0]);
            truthness = TruthnessUtils.buildOrAggregationTruthness(truthnesses);
        }
        return truthness;
    }

    private Truthness all(Object concreteLeftValue, List<Object> conocreteRightValues, ComparisonOperatorType comparisonOperatorType) {
        Truthness truthness;
        if (conocreteRightValues.isEmpty()) {
            truthness = SqlHeuristicsCalculator.TRUE_TRUTHNESS;
        } else {
            Truthness[] truthnesses = conocreteRightValues.stream().map(rightValue -> this.evaluateTruthnessForComparisonOperator(concreteLeftValue, rightValue, comparisonOperatorType)).collect(Collectors.toList()).toArray(new Truthness[0]);
            truthness = TruthnessUtils.buildAndAggregationTruthness(truthnesses);
        }
        return truthness;
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        super.visit(equalsTo);
        this.visitComparisonOperator(equalsTo);
    }

    private Truthness evaluateTruthnessForComparisonOperator(Object concreteLeftValue, Object concreteRightValue, ComparisonOperatorType comparisonOperatorType) {
        Truthness truthness;
        if (concreteLeftValue == null && concreteRightValue == null) {
            truthness = SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        } else if (concreteLeftValue == null || concreteRightValue == null) {
            truthness = SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER;
        } else {
            Truthness truthnessOfExpression;
            if (concreteLeftValue instanceof Number && concreteRightValue instanceof Number) {
                truthnessOfExpression = SqlExpressionEvaluator.calculateTruthnessForNumberComparison((Number)concreteLeftValue, (Number)concreteRightValue, comparisonOperatorType);
            } else if (concreteRightValue instanceof String && concreteLeftValue instanceof String) {
                truthnessOfExpression = this.calculateTruthnessForStringComparison((String)concreteLeftValue, (String)concreteRightValue, comparisonOperatorType);
            } else if (concreteLeftValue instanceof Boolean || concreteRightValue instanceof Boolean) {
                truthnessOfExpression = SqlExpressionEvaluator.calculateTruthnessForBooleanComparison(ConversionHelper.convertToBoolean(concreteLeftValue), ConversionHelper.convertToBoolean(concreteRightValue), comparisonOperatorType);
            } else if (concreteLeftValue instanceof Date || concreteRightValue instanceof Date) {
                truthnessOfExpression = SqlExpressionEvaluator.calculateTruthnessForInstantComparison(ConversionHelper.convertToInstant(concreteLeftValue), ConversionHelper.convertToInstant(concreteRightValue), comparisonOperatorType);
            } else if (concreteLeftValue instanceof OffsetDateTime || concreteRightValue instanceof OffsetDateTime) {
                truthnessOfExpression = SqlExpressionEvaluator.calculateTruthnessForInstantComparison(ConversionHelper.convertToInstant(concreteLeftValue), ConversionHelper.convertToInstant(concreteRightValue), comparisonOperatorType);
            } else if (concreteLeftValue instanceof OffsetTime || concreteRightValue instanceof OffsetTime) {
                truthnessOfExpression = SqlExpressionEvaluator.calculateTruthnessForInstantComparison(ConversionHelper.convertToInstant(concreteLeftValue), ConversionHelper.convertToInstant(concreteLeftValue), comparisonOperatorType);
            } else if (concreteLeftValue instanceof Object[] && concreteRightValue instanceof Object[]) {
                truthnessOfExpression = this.calculateTruthnessForArrayComparison((Object[])concreteLeftValue, (Object[])concreteRightValue, comparisonOperatorType);
            } else {
                throw new UnsupportedOperationException("types not supported " + concreteLeftValue.getClass().getName() + " and " + concreteRightValue.getClass().getName());
            }
            truthness = truthnessOfExpression.isTrue() ? truthnessOfExpression : TruthnessUtils.buildScaledTruthness(SqlHeuristicsCalculator.C_BETTER, truthnessOfExpression.getOfTrue());
        }
        return truthness;
    }

    private static Truthness calculateTruthnessForInstantComparison(Instant leftInstant, Instant rightInstant, ComparisonOperatorType comparisonOperatorType) {
        Objects.requireNonNull(leftInstant);
        Objects.requireNonNull(rightInstant);
        long leftInstantMillis = leftInstant.toEpochMilli();
        long rightInstantMillis = rightInstant.toEpochMilli();
        return SqlExpressionEvaluator.calculateTruthnessForDoubleComparison(leftInstantMillis, rightInstantMillis, comparisonOperatorType);
    }

    private static Truthness calculateTruthnessForBooleanComparison(Boolean concreteLeftValue, Boolean concreteRightValue, ComparisonOperatorType comparisonOperatorType) {
        Objects.requireNonNull(concreteLeftValue);
        Objects.requireNonNull(concreteRightValue);
        double leftValueAsDouble = SqlExpressionEvaluator.toDouble(concreteLeftValue);
        double rightValueAsDouble = SqlExpressionEvaluator.toDouble(concreteRightValue);
        switch (comparisonOperatorType) {
            case EQUALS_TO: {
                return TruthnessUtils.getEqualityTruthness(leftValueAsDouble, rightValueAsDouble);
            }
            case NOT_EQUALS_TO: {
                return TruthnessUtils.getEqualityTruthness(leftValueAsDouble, rightValueAsDouble).invert();
            }
        }
        throw new IllegalArgumentException("Unsupported binary operator: " + (Object)((Object)comparisonOperatorType));
    }

    private Truthness calculateTruthnessForArrayComparison(Object[] leftArray, Object[] rightArray, ComparisonOperatorType comparisonOperatorType) {
        Truthness truthness;
        Objects.requireNonNull(leftArray);
        Objects.requireNonNull(rightArray);
        boolean leftArrayHasNullValue = Stream.of(leftArray).anyMatch(Objects::isNull);
        boolean rightArrayHasNullValue = Stream.of(rightArray).anyMatch(Objects::isNull);
        if (leftArrayHasNullValue || rightArrayHasNullValue) {
            return SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        }
        List<Object> leftList = Arrays.asList(leftArray);
        List<Object> rightList = Arrays.asList(rightArray);
        if (rightList.size() != leftList.size()) {
            truthness = SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        } else {
            Truthness[] truthnesses = new Truthness[leftList.size()];
            for (int i = 0; i < leftList.size(); ++i) {
                truthnesses[i] = this.evaluateTruthnessForComparisonOperator(leftList.get(i), rightList.get(i), ComparisonOperatorType.EQUALS_TO);
            }
            truthness = TruthnessUtils.buildAndAggregationTruthness(truthnesses);
        }
        switch (comparisonOperatorType) {
            case EQUALS_TO: {
                return truthness;
            }
            case NOT_EQUALS_TO: {
                return truthness.invert();
            }
        }
        throw new IllegalArgumentException("Unsupported binary operator: " + (Object)((Object)comparisonOperatorType));
    }

    private static double toDouble(Boolean booleanValue) {
        return booleanValue != false ? 1.0 : 0.0;
    }

    public static Truthness getEqualityTruthness(String a, String b) {
        if (a.equals(b)) {
            return SqlHeuristicsCalculator.TRUE_TRUTHNESS;
        }
        double base = SqlHeuristicsCalculator.C;
        double distance = DistanceHelper.getLeftAlignmentDistance(a, b);
        double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
        return new Truthness(h, 1.0);
    }

    private Truthness calculateTruthnessForStringComparison(String leftString, String rightString, ComparisonOperatorType comparisonOperatorType) {
        Objects.requireNonNull(leftString);
        Objects.requireNonNull(rightString);
        switch (comparisonOperatorType) {
            case EQUALS_TO: {
                if (this.taintHandler != null) {
                    this.taintHandler.handleTaintForStringEquals(leftString, rightString, false);
                }
                return SqlExpressionEvaluator.getEqualityTruthness(leftString, rightString);
            }
            case NOT_EQUALS_TO: {
                return SqlExpressionEvaluator.getEqualityTruthness(leftString, rightString).invert();
            }
            case GREATER_THAN: {
                return leftString.compareTo(rightString) > 0 ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            }
            case GREATER_THAN_EQUALS: {
                return leftString.compareTo(rightString) >= 0 ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            }
            case MINOR_THAN: {
                return leftString.compareTo(rightString) < 0 ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            }
            case MINOR_THAN_EQUALS: {
                return leftString.compareTo(rightString) <= 0 ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            }
        }
        throw new IllegalArgumentException("Unsupported binary operator: " + (Object)((Object)comparisonOperatorType));
    }

    private static Truthness calculateTruthnessForNumberComparison(Number leftNumber, Number rightNumber, ComparisonOperatorType comparisonOperatorType) {
        Objects.requireNonNull(leftNumber);
        Objects.requireNonNull(rightNumber);
        double leftValueAsDouble = leftNumber.doubleValue();
        double rightValueAsDouble = rightNumber.doubleValue();
        return SqlExpressionEvaluator.calculateTruthnessForDoubleComparison(leftValueAsDouble, rightValueAsDouble, comparisonOperatorType);
    }

    private static Truthness calculateTruthnessForDoubleComparison(double leftValueAsDouble, double rightValueAsDouble, ComparisonOperatorType comparisonOperatorType) {
        switch (comparisonOperatorType) {
            case EQUALS_TO: {
                return TruthnessUtils.getEqualityTruthness(leftValueAsDouble, rightValueAsDouble);
            }
            case NOT_EQUALS_TO: {
                return TruthnessUtils.getEqualityTruthness(leftValueAsDouble, rightValueAsDouble).invert();
            }
            case GREATER_THAN: {
                return TruthnessUtils.getLessThanTruthness(rightValueAsDouble, leftValueAsDouble);
            }
            case MINOR_THAN: {
                return TruthnessUtils.getLessThanTruthness(leftValueAsDouble, rightValueAsDouble);
            }
            case MINOR_THAN_EQUALS: {
                return TruthnessUtils.getLessThanTruthness(rightValueAsDouble, leftValueAsDouble).invert();
            }
            case GREATER_THAN_EQUALS: {
                return TruthnessUtils.getLessThanTruthness(leftValueAsDouble, rightValueAsDouble).invert();
            }
        }
        throw new IllegalArgumentException("Unsupported binary operator: " + (Object)((Object)comparisonOperatorType));
    }

    @Override
    public void visit(BitwiseRightShift bitwiseRightShift) {
        super.visit(bitwiseRightShift);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            int leftValueAsInt = ((Number)leftConcreteValue).intValue();
            int rightValueAsInt = ((Number)rightConcreteValue).intValue();
            int result = leftValueAsInt >> rightValueAsInt;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(BitwiseLeftShift bitwiseLeftShift) {
        super.visit(bitwiseLeftShift);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            int leftValueAsInt = ((Number)leftConcreteValue).intValue();
            int rightValueAsInt = ((Number)rightConcreteValue).intValue();
            int result = leftValueAsInt << rightValueAsInt;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(NullValue nullValue) {
        this.evaluationStack.push(null);
    }

    @Override
    public void visit(Function function) {
        Object functionResult;
        String functionName = function.getName();
        SqlFunction sqlFunction = FunctionFinder.getInstance().getFunction(functionName);
        if (sqlFunction == null) {
            throw new UnsupportedOperationException("Function " + functionName + " needs to be implemented");
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (sqlFunction instanceof SqlAggregateFunction) {
            Expression parameterExpression = (Expression)function.getParameters().get(0);
            if (parameterExpression instanceof Column) {
                for (DataRow dataRow : this.getCurrentQueryResult().seeRows()) {
                    SqlExpressionEvaluator expressionEvaluator = new SqlExpressionEvaluatorBuilder().withTaintHandler(this.taintHandler).withTableColumnResolver(this.tableColumnResolver).withQueryResultSet(this.queryResultSet).withCurrentQueryResult(this.getCurrentQueryResult()).withDataRowStack(this.dataRowStack).withCurrentDataRow(dataRow).withParentStatementEvaluator(this.parentStatementEvaluator).build();
                    parameterExpression.accept(expressionEvaluator);
                    Object value = expressionEvaluator.popAsSingleValue();
                    values.add(value);
                }
            } else if (parameterExpression instanceof AllColumns) {
                for (DataRow dataRow : this.getCurrentQueryResult().seeRows()) {
                    values.add(dataRow);
                }
            } else {
                parameterExpression.accept(this);
                Object value = this.popAsSingleValue();
                values.add(value);
            }
            functionResult = sqlFunction.evaluate(values);
        } else {
            super.visit(function);
            for (int i = 0; i < function.getParameters().size(); ++i) {
                Object concreteParameter = this.popAsSingleValue();
                values.add(concreteParameter);
            }
            Collections.reverse(values);
            functionResult = sqlFunction.evaluate(values.toArray(new Object[0]));
        }
        this.evaluationStack.push(functionResult);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        super.visit(signedExpression);
        Object expressionValue = this.popAsSingleValue();
        if (expressionValue == null) {
            this.evaluationStack.push(null);
        } else {
            Number result;
            Number numberWithoutSign = (Number)expressionValue;
            switch (signedExpression.getSign()) {
                case '+': {
                    result = numberWithoutSign.doubleValue();
                    break;
                }
                case '-': {
                    result = -numberWithoutSign.doubleValue();
                    break;
                }
                case '~': {
                    result = ~numberWithoutSign.intValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported sign: " + signedExpression.getSign());
                }
            }
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        throw new UnsupportedOperationException("JdbcParameter not supported");
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        throw new UnsupportedOperationException("JdbcNamedParameter not supported");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        double concreteValue = doubleValue.getValue();
        this.evaluationStack.push(concreteValue);
    }

    @Override
    public void visit(LongValue longValue) {
        long concreteValue = longValue.getValue();
        this.evaluationStack.push(concreteValue);
    }

    @Override
    public void visit(HexValue hexValue) {
        String hexString = hexValue.getValue();
        int intValue = Integer.parseInt(hexString.substring(2), 16);
        this.evaluationStack.push(intValue);
    }

    @Override
    public void visit(DateValue dateValue) {
        java.sql.Date value = dateValue.getValue();
        this.evaluationStack.push(value);
    }

    @Override
    public void visit(TimeValue timeValue) {
        Time value = timeValue.getValue();
        this.evaluationStack.push(value);
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        Timestamp value = timestampValue.getValue();
        this.evaluationStack.push(value);
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        super.visit(parenthesis);
    }

    @Override
    public void visit(IntegerDivision integerDivision) {
        super.visit(integerDivision);
        this.visitArithmeticBinaryExpression(integerDivision);
    }

    @Override
    public void visit(Multiplication multiplication) {
        super.visit(multiplication);
        this.visitArithmeticBinaryExpression(multiplication);
    }

    @Override
    public void visit(Subtraction subtraction) {
        super.visit(subtraction);
        this.visitArithmeticBinaryExpression(subtraction);
    }

    @Override
    public void visit(AndExpression andExpression) {
        super.visit(andExpression);
        Truthness rightTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness leftTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness andTruthness = TruthnessUtils.buildAndAggregationTruthness(leftTruthnessValue, rightTruthnessValue);
        this.evaluationStack.push(andTruthness);
    }

    @Override
    public void visit(OrExpression orExpression) {
        super.visit(orExpression);
        Truthness rightTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness leftTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness orTruthness = TruthnessUtils.buildOrAggregationTruthness(leftTruthnessValue, rightTruthnessValue);
        this.evaluationStack.push(orTruthness);
    }

    @Override
    public void visit(XorExpression xorExpression) {
        super.visit(xorExpression);
        Truthness rightTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness leftTruthnessValue = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness xorTruthness = TruthnessUtils.buildXorAggregationTruthness(leftTruthnessValue, rightTruthnessValue);
        this.evaluationStack.push(xorTruthness);
    }

    @Override
    public void visit(Between between) {
        super.visit(between);
        Object endRangeValue = this.popAsSingleValue();
        Object startRangeValue = this.popAsSingleValue();
        Object leftExpressionValue = this.popAsSingleValue();
        if (leftExpressionValue == null || startRangeValue == null || endRangeValue == null) {
            this.evaluationStack.push(SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER);
        } else {
            Truthness startCondition = this.evaluateTruthnessForComparisonOperator(leftExpressionValue, startRangeValue, ComparisonOperatorType.GREATER_THAN_EQUALS);
            Truthness endCondition = this.evaluateTruthnessForComparisonOperator(leftExpressionValue, endRangeValue, ComparisonOperatorType.MINOR_THAN_EQUALS);
            Truthness betweenCondition = TruthnessUtils.buildAndAggregationTruthness(startCondition, endCondition);
            this.evaluationStack.push(betweenCondition);
        }
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        super.visit(overlapsCondition);
        List rightRange = (List)this.evaluationStack.pop();
        List leftRange = (List)this.evaluationStack.pop();
        Object leftStart = leftRange.get(0);
        Object leftEnd = leftRange.get(1);
        Object rightStart = rightRange.get(0);
        Object rightEnd = rightRange.get(1);
        Truthness rangeStart = this.evaluateTruthnessForComparisonOperator(leftStart, rightEnd, ComparisonOperatorType.MINOR_THAN_EQUALS);
        Truthness rangeEnd = this.evaluateTruthnessForComparisonOperator(rightStart, leftEnd, ComparisonOperatorType.MINOR_THAN_EQUALS);
        Truthness overlaps = TruthnessUtils.buildAndAggregationTruthness(rangeStart, rangeEnd);
        this.evaluationStack.push(overlaps);
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        super.visit(greaterThan);
        this.visitComparisonOperator(greaterThan);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        super.visit(greaterThanEquals);
        this.visitComparisonOperator(greaterThanEquals);
    }

    @Override
    public void visit(InExpression inExpression) {
        super.visit(inExpression);
        List<Object> concreteRightValues = this.popAsListOfValues();
        Object concreteLeftValue = this.evaluationStack.pop();
        Truthness truthness = concreteLeftValue == null || concreteRightValues == null ? SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER : (inExpression.isNot() ? this.all(concreteLeftValue, concreteRightValues, ComparisonOperatorType.NOT_EQUALS_TO) : this.any(concreteLeftValue, concreteRightValues, ComparisonOperatorType.EQUALS_TO));
        this.evaluationStack.push(truthness);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        throw new UnsupportedOperationException("visit(FullTextSearch) not supported");
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        super.visit(isNullExpression);
        Object concreteLeftValue = this.popAsSingleValue();
        Truthness truthness = isNullExpression.isNot() ? SqlExpressionEvaluator.getTruthnessToIsNull(concreteLeftValue).invert() : SqlExpressionEvaluator.getTruthnessToIsNull(concreteLeftValue);
        this.evaluationStack.push(truthness);
    }

    public static Truthness getTruthnessToIsNull(Object concreteValue) {
        Truthness truthness = concreteValue == null ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
        return truthness;
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        super.visit(isBooleanExpression);
        Object leftConcreteValue = this.popAsSingleValue();
        boolean rightBooleanValue = isBooleanExpression.isNot() ? !isBooleanExpression.isTrue() : isBooleanExpression.isTrue();
        Truthness truthness = SqlExpressionEvaluator.getTruthnessForIsBooleanExpression(ConversionHelper.convertToBoolean(leftConcreteValue), rightBooleanValue);
        this.evaluationStack.push(truthness);
    }

    private static Truthness getTruthnessForIsBooleanExpression(Object leftConcreteValue, boolean rightBooleanValue) {
        boolean leftBoolean;
        Truthness truthness = leftConcreteValue == null ? SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER : ((leftBoolean = ((Boolean)leftConcreteValue).booleanValue()) == rightBooleanValue ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS);
        return truthness;
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        super.visit(likeExpression);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(SqlHeuristicsCalculator.FALSE_TRUTHNESS_BETTER);
        } else {
            Truthness truthness;
            String likePattern;
            String javaRegexPattern;
            String string = String.valueOf(leftConcreteValue);
            boolean matches = string.matches(javaRegexPattern = RegexSharedUtils.translateSqlLikePattern(likePattern = String.valueOf(rightConcreteValue)));
            Truthness truthness2 = truthness = matches ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            if (likeExpression.isNot()) {
                truthness = truthness.invert();
            }
            this.evaluationStack.push(truthness);
        }
    }

    @Override
    public void visit(MinorThan minorThan) {
        super.visit(minorThan);
        this.visitComparisonOperator(minorThan);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        super.visit(minorThanEquals);
        this.visitComparisonOperator(minorThanEquals);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        super.visit(notEqualsTo);
        this.visitComparisonOperator(notEqualsTo);
    }

    @Override
    public void visit(DoubleAnd doubleAnd) {
        throw new UnsupportedOperationException("visit(DoubleAnd) not supported");
    }

    @Override
    public void visit(Contains contains) {
        throw new UnsupportedOperationException("visit(Contains) not supported");
    }

    @Override
    public void visit(ContainedBy containedBy) {
        throw new UnsupportedOperationException("visit(ContainedBy) not supported");
    }

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
        throw new UnsupportedOperationException("visit(ParenthesedSelect) not supported");
    }

    @Override
    public void visit(Column column) {
        Object value = this.getValueForColumn(column);
        this.evaluationStack.push(value);
    }

    private Object getValueForColumn(Column column) {
        Object value;
        if (BooleanLiteralsHelper.isBooleanLiteral(column.getColumnName()).booleanValue()) {
            value = BooleanLiteralsHelper.isTrueLiteral(column.getColumnName());
        } else {
            String baseTableName;
            SqlColumnReference sqlColumnReference = this.tableColumnResolver.resolve(column);
            if (sqlColumnReference.getTableReference() instanceof SqlBaseTableReference) {
                SqlBaseTableReference sqlBaseTableReference = (SqlBaseTableReference)sqlColumnReference.getTableReference();
                baseTableName = sqlBaseTableReference.getName();
            } else {
                baseTableName = null;
            }
            String columnName = sqlColumnReference.getColumnName();
            if (this.getCurrentDataRow().getVariableDescriptors().stream().filter(vd -> SqlStringUtils.nullSafeEqualsIgnoreCase(vd.getTableName(), baseTableName) && SqlStringUtils.nullSafeEqualsIgnoreCase(vd.getColumnName(), columnName)).count() > 1L) {
                String aliasTableName = column.getTable().getFullyQualifiedName();
                value = this.getCurrentDataRow().getValueByName(columnName, baseTableName, aliasTableName);
            } else {
                value = this.getValueByName(columnName, baseTableName);
            }
        }
        return value;
    }

    DataRow getCurrentDataRow() {
        return this.dataRowStack.peek();
    }

    QueryResult getCurrentQueryResult() {
        return this.queryResultStack.peek();
    }

    private Object getValueByName(String columnName, String baseTableName) {
        for (DataRow dataRow : this.dataRowStack) {
            if (!dataRow.hasValueByName(columnName, baseTableName)) continue;
            return dataRow.getValueByName(columnName, baseTableName);
        }
        throw new IllegalArgumentException(String.format("Column '%s' not found in table '%s'", columnName, baseTableName));
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        boolean switchExpressionIsValid;
        Object switchExpression;
        boolean elseExpressionIsValid;
        Object elseExpression;
        super.visit(caseExpression);
        if (caseExpression.getElseExpression() != null) {
            elseExpression = this.popAsSingleValue();
            elseExpressionIsValid = true;
        } else {
            elseExpression = null;
            elseExpressionIsValid = false;
        }
        ArrayList<Object> thenExpressions = new ArrayList<Object>();
        ArrayList<Object> whenExpressions = new ArrayList<Object>();
        for (int i = 0; i < caseExpression.getWhenClauses().size(); ++i) {
            Object thenExpression = this.popAsSingleValue();
            thenExpressions.add(thenExpression);
            Object whenExpression = this.popAsSingleValue();
            whenExpressions.add(whenExpression);
        }
        Collections.reverse(thenExpressions);
        Collections.reverse(whenExpressions);
        if (caseExpression.getSwitchExpression() != null) {
            switchExpression = this.popAsSingleValue();
            switchExpressionIsValid = true;
        } else {
            switchExpression = null;
            switchExpressionIsValid = false;
        }
        for (int i = 0; i < whenExpressions.size(); ++i) {
            Object whenExpression = whenExpressions.get(i);
            Object thenExpression = thenExpressions.get(i);
            Truthness truthness = switchExpressionIsValid ? this.evaluateTruthnessForComparisonOperator(switchExpression, whenExpression, ComparisonOperatorType.EQUALS_TO) : ConversionHelper.convertToTruthness(whenExpression);
            if (!truthness.isTrue()) continue;
            this.evaluationStack.push(thenExpression);
            return;
        }
        if (!elseExpressionIsValid) {
            throw new IllegalStateException("elseExpression is null but it should not be");
        }
        this.evaluationStack.push(elseExpression);
    }

    @Override
    public void visit(WhenClause whenClause) {
        super.visit(whenClause);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        Expression rightExpression = existsExpression.getRightExpression();
        if (!(rightExpression instanceof Select)) {
            throw new IllegalArgumentException("Expected a Select expression, but got: " + rightExpression.getClass().getName());
        }
        Select select = (Select)rightExpression;
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        builder.withParentExpressionEvaluator(this).withTableColumnResolver(this.tableColumnResolver).withTaintHandler(this.taintHandler).withSourceQueryResultSet(this.queryResultSet).withStackOfDataRows(this.dataRowStack);
        SqlHeuristicsCalculator sqlHeuristicsCalculator = builder.build();
        SqlHeuristicResult heuristicResult = sqlHeuristicsCalculator.computeHeuristic(select);
        if (existsExpression.isNot()) {
            this.evaluationStack.push(heuristicResult.getTruthness().invert());
        } else {
            this.evaluationStack.push(heuristicResult.getTruthness());
        }
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        throw new UnsupportedOperationException("visit(MemberOfExpression) not supported");
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSelect().accept(this);
        List<Object> values = this.popAsListOfValues();
        this.evaluationStack.push(new EvaluatedAnyComparisonExpression(values, anyComparisonExpression.getAnyType()));
    }

    @Override
    public void visit(Concat concat) {
        super.visit(concat);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            String result = String.valueOf(leftConcreteValue) + String.valueOf(rightConcreteValue);
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(Matches matches) {
        throw new UnsupportedOperationException("visit(Matches) not supported");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        super.visit(bitwiseAnd);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            int leftValueAsInt = ((Number)leftConcreteValue).intValue();
            int rightValueAsInt = ((Number)rightConcreteValue).intValue();
            int result = leftValueAsInt & rightValueAsInt;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        super.visit(bitwiseOr);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            int leftValueAsInt = ((Number)leftConcreteValue).intValue();
            int rightValueAsInt = ((Number)rightConcreteValue).intValue();
            int result = leftValueAsInt | rightValueAsInt;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        super.visit(bitwiseXor);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            int leftValueAsInt = ((Number)leftConcreteValue).intValue();
            int rightValueAsInt = ((Number)rightConcreteValue).intValue();
            int result = leftValueAsInt ^ rightValueAsInt;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(CastExpression castExpression) {
        super.visit(castExpression);
        if (castExpression.getColumnDefinitions().size() >= 1) {
            throw new UnsupportedOperationException("CAST AS ROW must be implemented");
        }
        Object value = this.popAsSingleValue();
        if (value == null) {
            this.evaluationStack.push(null);
        } else {
            ColDataType colDataType = castExpression.getColDataType();
            String dataTypeName = colDataType.getDataType();
            SqlDataType dataType = SqlDataType.fromString(dataTypeName);
            Object castedValue = SqlCastHelper.castTo(dataType, value);
            this.evaluationStack.push(castedValue);
        }
    }

    @Override
    public void visit(Modulo modulo) {
        super.visit(modulo);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(null);
        } else {
            double leftValueAsDouble = ((Number)leftConcreteValue).doubleValue();
            double rightValueAsDouble = ((Number)rightConcreteValue).doubleValue();
            double result = leftValueAsDouble % rightValueAsDouble;
            this.evaluationStack.push(result);
        }
    }

    @Override
    public void visit(AnalyticExpression analyticExpression) {
        throw new UnsupportedOperationException("visit(AnalyticExpression) not supported");
    }

    @Override
    public void visit(ExtractExpression extractExpression) {
        throw new UnsupportedOperationException("visit(ExtractExpression) not supported");
    }

    @Override
    public void visit(IntervalExpression intervalExpression) {
        throw new UnsupportedOperationException("visit(IntervalExpression) not supported");
    }

    @Override
    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
        throw new UnsupportedOperationException("visit(OracleHierarchicalExpression) not supported");
    }

    @Override
    public void visit(RegExpMatchOperator regExpMatchOperator) {
        super.visit(regExpMatchOperator);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(SqlHeuristicsCalculator.FALSE_TRUTHNESS);
        } else {
            Truthness truthness;
            boolean negate;
            boolean caseSensitive;
            RegExpMatchOperatorType operatorType = regExpMatchOperator.getOperatorType();
            String string = leftConcreteValue.toString();
            String posixPattern = rightConcreteValue.toString();
            switch (operatorType) {
                case MATCH_CASESENSITIVE: {
                    caseSensitive = true;
                    negate = false;
                    break;
                }
                case NOT_MATCH_CASESENSITIVE: {
                    caseSensitive = true;
                    negate = true;
                    break;
                }
                case MATCH_CASEINSENSITIVE: {
                    caseSensitive = false;
                    negate = false;
                    break;
                }
                case NOT_MATCH_CASEINSENSITIVE: {
                    caseSensitive = false;
                    negate = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operator type: " + (Object)((Object)operatorType));
                }
            }
            String javaRegexPattern = RegexSharedUtils.translatePostgresqlPosix(posixPattern, caseSensitive);
            boolean matches = string.matches(javaRegexPattern);
            Truthness truthness2 = truthness = matches ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            if (negate) {
                truthness = truthness.invert();
            }
            this.evaluationStack.push(truthness);
        }
    }

    @Override
    public void visit(JsonExpression jsonExpression) {
        throw new UnsupportedOperationException("visit(JsonExpression) not supported");
    }

    @Override
    public void visit(JsonOperator jsonOperator) {
        throw new UnsupportedOperationException("visit(JsonOperator) not supported");
    }

    @Override
    public void visit(UserVariable userVariable) {
        throw new UnsupportedOperationException("visit(UserVariable) not supported");
    }

    @Override
    public void visit(NumericBind numericBind) {
        throw new UnsupportedOperationException("visit(NumericBind) not supported");
    }

    @Override
    public void visit(KeepExpression keepExpression) {
        throw new UnsupportedOperationException("visit(KeepExpression) not supported");
    }

    @Override
    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        throw new UnsupportedOperationException("visit(MySQLGroupConcat) not supported");
    }

    @Override
    public void visit(ExpressionList<?> expressionList) {
        super.visit(expressionList);
        List list = Stream.generate(this.evaluationStack::pop).limit(expressionList.size()).collect(Collectors.toList());
        Collections.reverse(list);
        this.evaluationStack.push(list);
    }

    @Override
    public void visit(RowConstructor<?> rowConstructor) {
        throw new UnsupportedOperationException("visit(RowConstructor) not supported");
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        throw new UnsupportedOperationException("visit(RowGetExpression) not supported");
    }

    @Override
    public void visit(OracleHint oracleHint) {
        throw new UnsupportedOperationException("visit(OracleHint) not supported");
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
        throw new UnsupportedOperationException("visit(TimeKeyExpression) not supported");
    }

    @Override
    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
        String dateTimeAsString = dateTimeLiteralExpression.getValue();
        String dateTimeWithoutEnclosingQuotes = SqlStringUtils.removeEnclosingQuotes(dateTimeAsString);
        this.evaluationStack.push(dateTimeWithoutEnclosingQuotes);
    }

    @Override
    public void visit(NotExpression notExpression) {
        super.visit(notExpression);
        Truthness truthness = ConversionHelper.convertToTruthness(this.popAsSingleValue());
        Truthness notTruthness = truthness.invert();
        this.evaluationStack.push(notTruthness);
    }

    @Override
    public void visit(NextValExpression nextValExpression) {
        throw new UnsupportedOperationException("visit(NextValExpression) not supported");
    }

    @Override
    public void visit(CollateExpression collateExpression) {
        throw new UnsupportedOperationException("visit(CollateExpression) not supported");
    }

    @Override
    public void visit(SimilarToExpression similarToExpression) {
        super.visit(similarToExpression);
        Object rightConcreteValue = this.popAsSingleValue();
        Object leftConcreteValue = this.popAsSingleValue();
        if (leftConcreteValue == null || rightConcreteValue == null) {
            this.evaluationStack.push(SqlHeuristicsCalculator.FALSE_TRUTHNESS);
        } else {
            Truthness truthness;
            String similarToPattern;
            String javaRegexPattern;
            String string = leftConcreteValue.toString();
            boolean matches = string.matches(javaRegexPattern = RegexSharedUtils.translateSqlSimilarToPattern(similarToPattern = rightConcreteValue.toString()));
            Truthness truthness2 = truthness = matches ? SqlHeuristicsCalculator.TRUE_TRUTHNESS : SqlHeuristicsCalculator.FALSE_TRUTHNESS;
            if (similarToExpression.isNot()) {
                truthness = truthness.invert();
            }
            this.evaluationStack.push(truthness);
        }
    }

    @Override
    public void visit(ArrayExpression arrayExpression) {
        super.visit(arrayExpression);
        Number sqlStopIndex = arrayExpression.getStopIndexExpression() != null ? (Number)((Number)this.popAsSingleValue()) : (Number)null;
        Number sqlStartIndex = arrayExpression.getStartIndexExpression() != null ? (Number)((Number)this.popAsSingleValue()) : (Number)1;
        Number sqlIndex = arrayExpression.getIndexExpression() != null ? (Number)((Number)this.popAsSingleValue()) : (Number)null;
        Object[] objectArray = (Object[])this.evaluationStack.pop();
        if (sqlStopIndex == null) {
            sqlStopIndex = objectArray.length;
        }
        int startIndex = SqlExpressionEvaluator.toJavaIndex(sqlStartIndex);
        int stopIndex = SqlExpressionEvaluator.toJavaIndex(sqlStopIndex);
        Object[] subArray = Arrays.copyOfRange(objectArray, startIndex, stopIndex + 1);
        if (sqlIndex == null) {
            this.evaluationStack.push(subArray);
        } else {
            int index = SqlExpressionEvaluator.toJavaIndex(sqlIndex);
            Object item = subArray[index];
            this.evaluationStack.push(item);
        }
    }

    private static int toJavaIndex(Number sqlStartIndex) {
        return sqlStartIndex.intValue() - 1;
    }

    @Override
    public void visit(ArrayConstructor arrayConstructor) {
        super.visit(arrayConstructor);
        List list = Stream.generate(this.evaluationStack::pop).limit(arrayConstructor.getExpressions().size()).collect(Collectors.toList());
        Collections.reverse(list);
        this.evaluationStack.push(list.toArray());
    }

    @Override
    public void visit(VariableAssignment variableAssignment) {
        throw new UnsupportedOperationException("visit(VariableAssignment) not supported");
    }

    @Override
    public void visit(XMLSerializeExpr xmlSerializeExpr) {
        throw new UnsupportedOperationException("visit(XMLSerializeExpr) not supported");
    }

    @Override
    public void visit(TimezoneExpression timezoneExpression) {
        throw new UnsupportedOperationException("visit(TimezoneExpression) not supported");
    }

    @Override
    public void visit(JsonAggregateFunction jsonAggregateFunction) {
        throw new UnsupportedOperationException("visit(JsonAggregateFunction) not supported");
    }

    @Override
    public void visit(JsonFunction jsonFunction) {
        throw new UnsupportedOperationException("visit(JsonFunction) not supported");
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        throw new UnsupportedOperationException("visit(ConnectByRootOperator) not supported");
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        throw new UnsupportedOperationException("visit(OracleNamedFunctionParameter) not supported");
    }

    @Override
    public void visit(AllColumns allColumns) {
        ArrayList<Object> values = new ArrayList<Object>(this.getCurrentDataRow().seeValues());
        this.evaluationStack.push(values);
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        String tableName = allTableColumns.getTable().getName();
        ArrayList<Object> values = new ArrayList<Object>();
        for (VariableDescriptor vd : this.getCurrentDataRow().getVariableDescriptors()) {
            if (!tableName.equalsIgnoreCase(vd.getAliasTableName()) && !tableName.equalsIgnoreCase(vd.getTableName())) continue;
            Object value = this.getCurrentDataRow().getValueByName(vd.getColumnName(), vd.getTableName(), vd.getAliasTableName());
            values.add(value);
        }
        this.evaluationStack.push(values);
    }

    @Override
    public void visit(AllValue allValue) {
        throw new UnsupportedOperationException("visit(AllValue) not supported");
    }

    @Override
    public void visit(IsDistinctExpression isDistinctExpression) {
        throw new UnsupportedOperationException("visit(IsDistinctExpression) not supported");
    }

    @Override
    public void visit(GeometryDistance geometryDistance) {
        throw new UnsupportedOperationException("visit(GeometryDistance) not supported");
    }

    @Override
    public void visit(Select select) {
        SqlHeuristicsCalculator sqlHeuristicsCalculator = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder().withParentExpressionEvaluator(this).withTableColumnResolver(this.tableColumnResolver).withTaintHandler(this.taintHandler).withSourceQueryResultSet(this.queryResultSet).withStackOfDataRows(this.dataRowStack).build();
        SqlHeuristicResult heuristicResult = sqlHeuristicsCalculator.computeHeuristic(select);
        this.evaluationStack.push(heuristicResult.getQueryResult());
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        throw new UnsupportedOperationException("visit(TranscodingFunction) not supported");
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        throw new UnsupportedOperationException("visit(TrimFunction) not supported");
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        throw new UnsupportedOperationException("visit(RangeExpression) not supported");
    }

    @Override
    public void visit(TSQLLeftJoin tsqlLeftJoin) {
        throw new UnsupportedOperationException("visit(TSQLLeftJoin) not supported");
    }

    @Override
    public void visit(TSQLRightJoin tsqlRightJoin) {
        throw new UnsupportedOperationException("visit(TSQLRightJoin) not supported");
    }

    @Override
    public void visit(StringValue stringValue) {
        String concreteValue = stringValue.getValue();
        this.evaluationStack.push(concreteValue);
    }

    @Override
    public void visit(Addition addition) {
        super.visit(addition);
        this.visitArithmeticBinaryExpression(addition);
    }

    @Override
    public void visit(Division division) {
        super.visit(division);
        this.visitArithmeticBinaryExpression(division);
    }

    private static ArithmeticOperationType toArithmeticOperationType(BinaryExpression binaryExpression) {
        if (binaryExpression instanceof Addition) {
            return ArithmeticOperationType.ADDITION;
        }
        if (binaryExpression instanceof Subtraction) {
            return ArithmeticOperationType.SUBTRACTION;
        }
        if (binaryExpression instanceof Multiplication) {
            return ArithmeticOperationType.MULTIPLICATION;
        }
        if (binaryExpression instanceof Division) {
            return ArithmeticOperationType.DIVISION;
        }
        if (binaryExpression instanceof IntegerDivision) {
            return ArithmeticOperationType.INTEGER_DIVISION;
        }
        throw new IllegalArgumentException("Unsupported BinaryExpression: " + binaryExpression.getClass().getName());
    }

    private void visitArithmeticBinaryExpression(BinaryExpression binaryExpression) {
        Object concreteRightValue = this.popAsSingleValue();
        Object concreteLeftValue = this.popAsSingleValue();
        if (concreteLeftValue == null || concreteRightValue == null) {
            this.evaluationStack.push(null);
        } else {
            ArithmeticOperationType arithmeticOperationType = SqlExpressionEvaluator.toArithmeticOperationType(binaryExpression);
            if (concreteLeftValue instanceof Number && concreteRightValue instanceof Number) {
                Number leftNumber = (Number)concreteLeftValue;
                Number rightNumber = (Number)concreteRightValue;
                double resultAsDouble = SqlExpressionEvaluator.computeNumberArithmeticOperation(leftNumber, rightNumber, arithmeticOperationType);
                this.evaluationStack.push(resultAsDouble);
            } else if (concreteLeftValue instanceof java.sql.Date && concreteRightValue instanceof java.sql.Date) {
                java.sql.Date leftDate = (java.sql.Date)concreteLeftValue;
                java.sql.Date rightDate = (java.sql.Date)concreteRightValue;
                java.sql.Date resultDate = SqlExpressionEvaluator.computeDateArithmeticOperation(leftDate, rightDate, arithmeticOperationType);
                this.evaluationStack.push(resultDate);
            }
        }
    }

    private static java.sql.Date computeDateArithmeticOperation(java.sql.Date leftDate, java.sql.Date rightDate, ArithmeticOperationType arithmeticOperationType) {
        long resultTime;
        Objects.requireNonNull(leftDate);
        Objects.requireNonNull(rightDate);
        long leftTime = leftDate.getTime();
        long rightTime = rightDate.getTime();
        switch (arithmeticOperationType) {
            case SUBTRACTION: {
                resultTime = leftTime - rightTime;
                break;
            }
            case ADDITION: {
                resultTime = leftTime + rightTime;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ArithmeticOperationType: " + (Object)((Object)arithmeticOperationType));
            }
        }
        java.sql.Date resultDate = new java.sql.Date(resultTime);
        return resultDate;
    }

    private static double computeNumberArithmeticOperation(Number leftNumber, Number rightNumber, ArithmeticOperationType arithmeticOperationType) {
        double resultAsDouble;
        Objects.requireNonNull(leftNumber);
        Objects.requireNonNull(rightNumber);
        double leftDoubleValue = leftNumber.doubleValue();
        double rightDoubleValue = rightNumber.doubleValue();
        switch (arithmeticOperationType) {
            case ADDITION: {
                resultAsDouble = leftDoubleValue + rightDoubleValue;
                break;
            }
            case SUBTRACTION: {
                resultAsDouble = leftDoubleValue - rightDoubleValue;
                break;
            }
            case MULTIPLICATION: {
                resultAsDouble = leftDoubleValue * rightDoubleValue;
                break;
            }
            case DIVISION: {
                resultAsDouble = leftDoubleValue / rightDoubleValue;
                break;
            }
            case INTEGER_DIVISION: {
                resultAsDouble = Math.floor(leftDoubleValue / rightDoubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ArithmeticOperationType: " + (Object)((Object)arithmeticOperationType));
            }
        }
        return resultAsDouble;
    }

    private static class EvaluatedAnyComparisonExpression {
        private final List<Object> values;
        private final AnyType anyType;

        public EvaluatedAnyComparisonExpression(List<Object> values, AnyType anyType) {
            this.values = values;
            this.anyType = anyType;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public AnyType getAnyType() {
            return this.anyType;
        }
    }

    private static enum ArithmeticOperationType {
        ADDITION,
        SUBTRACTION,
        MULTIPLICATION,
        DIVISION,
        INTEGER_DIVISION;

    }

    private static enum ComparisonOperatorType {
        EQUALS_TO,
        NOT_EQUALS_TO,
        GREATER_THAN,
        GREATER_THAN_EQUALS,
        MINOR_THAN,
        MINOR_THAN_EQUALS;

    }

    public static class SqlExpressionEvaluatorBuilder {
        private SqlHeuristicsCalculator parentStatementEvaluator;
        private TableColumnResolver tableColumnResolver;
        private TaintHandler taintHandler;
        private QueryResultSet queryResultSet;
        private Deque<DataRow> dataRowStack;
        private DataRow currentDataRow;
        private Deque<QueryResult> queryResultStack;
        private QueryResult currentQueryResult;

        public SqlExpressionEvaluatorBuilder withParentStatementEvaluator(SqlHeuristicsCalculator val) {
            this.parentStatementEvaluator = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withTableColumnResolver(TableColumnResolver val) {
            this.tableColumnResolver = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withTaintHandler(TaintHandler val) {
            this.taintHandler = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withQueryResultSet(QueryResultSet val) {
            this.queryResultSet = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withDataRowStack(Deque<DataRow> val) {
            this.dataRowStack = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withCurrentDataRow(DataRow val) {
            this.currentDataRow = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withQueryResultStack(Deque<QueryResult> val) {
            this.queryResultStack = val;
            return this;
        }

        public SqlExpressionEvaluatorBuilder withCurrentQueryResult(QueryResult val) {
            this.currentQueryResult = val;
            return this;
        }

        public SqlExpressionEvaluator build() {
            return new SqlExpressionEvaluator(this.parentStatementEvaluator, this.tableColumnResolver, this.taintHandler, this.queryResultSet, this.dataRowStack, this.currentDataRow, this.queryResultStack, this.currentQueryResult);
        }
    }
}

