/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller;

import com.webfuzzing.commons.auth.Header;
import com.webfuzzing.commons.auth.LoginEndpoint;
import com.webfuzzing.commons.auth.TokenHandling;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.evomaster.client.java.controller.api.dto.auth.AuthenticationDto;

public class AuthUtils {
    public static String encode64(String value) {
        Objects.requireNonNull(value);
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded);
    }

    public static AuthenticationDto getForBasic(String dtoName, String userId, String password) {
        Objects.requireNonNull(userId, password);
        String encoded = AuthUtils.encode64(userId + ":" + password);
        String headerValue = "Basic " + encoded;
        return AuthUtils.getForAuthorizationHeader(dtoName, headerValue);
    }

    public static AuthenticationDto getForAuthorizationHeader(String dtoName, String authorizationValue) {
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        Header header = new Header();
        header.setName("Authorization");
        header.setValue(authorizationValue);
        dto.getFixedHeaders().add(header);
        return dto;
    }

    public static AuthenticationDto getForDefaultSpringFormLogin(String dtoName, String username, String password) {
        return AuthUtils.getForDefaultSpringFormLogin(dtoName, username, password, "/login");
    }

    public static AuthenticationDto getForDefaultSpringFormLogin(String dtoName, String username, String password, String endpoint) {
        LoginEndpoint cookie = new LoginEndpoint();
        cookie.setEndpoint(endpoint);
        cookie.setVerb(LoginEndpoint.HttpVerb.POST);
        cookie.setContentType("application/x-www-form-urlencoded");
        cookie.setExpectCookies(true);
        try {
            String usernameField = URLEncoder.encode("username", "UTF-8");
            String passwordField = URLEncoder.encode("password", "UTF-8");
            String payload = usernameField + "=" + URLEncoder.encode(username, "UTF-8");
            payload = payload + "&";
            payload = payload + passwordField + "=" + URLEncoder.encode(password, "UTF-8");
            cookie.setPayloadRaw(payload);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.setLoginEndpointAuth(cookie);
        return dto;
    }

    public static AuthenticationDto getForJWT(String dtoName, String postEndpoint, String payload, String extractFromField) {
        return AuthUtils.getForJsonToken(dtoName, postEndpoint, payload, extractFromField, "JWT ");
    }

    public static AuthenticationDto getForJsonTokenBearer(String dtoName, String postEndpoint, String payload, String extractFromField) {
        return AuthUtils.getForJsonToken(dtoName, postEndpoint, payload, extractFromField, "Bearer ");
    }

    public static AuthenticationDto getForJsonToken(String dtoName, String postEndpoint, String payload, String extractFromField, String headerPrefix) {
        return AuthUtils.getForJsonToken(dtoName, postEndpoint, payload, extractFromField, headerPrefix, "application/json");
    }

    public static AuthenticationDto getForJsonToken(String dtoName, String postEndpoint, String payload, String extractFromField, String headerPrefix, String contentType) {
        LoginEndpoint le = new LoginEndpoint();
        if (postEndpoint.startsWith("http://") || postEndpoint.startsWith("https://")) {
            le.setExternalEndpointURL(postEndpoint);
        } else {
            le.setEndpoint(postEndpoint);
        }
        le.setVerb(LoginEndpoint.HttpVerb.POST);
        le.setContentType(contentType);
        le.setExpectCookies(false);
        le.setPayloadRaw(payload);
        le.setToken(new TokenHandling());
        le.getToken().setExtractFrom(TokenHandling.ExtractFrom.BODY);
        le.getToken().setExtractSelector(extractFromField);
        le.getToken().setSendIn(TokenHandling.SendIn.HEADER);
        le.getToken().setSendName("Authorization");
        le.getToken().setSendTemplate(headerPrefix + "{token}");
        AuthenticationDto dto = new AuthenticationDto(dtoName);
        dto.setLoginEndpointAuth(le);
        return dto;
    }
}

