/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.internal.db.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evomaster.client.java.controller.internal.TaintHandlerExecutionTracer;
import org.evomaster.client.java.controller.internal.db.redis.RedisCommandEvaluation;
import org.evomaster.client.java.controller.internal.db.redis.RedisDistanceWithMetrics;
import org.evomaster.client.java.controller.redis.RedisClient;
import org.evomaster.client.java.controller.redis.RedisHeuristicsCalculator;
import org.evomaster.client.java.controller.redis.RedisInfo;
import org.evomaster.client.java.instrumentation.RedisCommand;
import org.evomaster.client.java.utils.SimpleLogger;

public class RedisHandler {
    private final List<RedisCommand> operations;
    private final List<RedisCommandEvaluation> evaluatedRedisCommands = new ArrayList<RedisCommandEvaluation>();
    private volatile boolean calculateHeuristics = true;
    private volatile boolean extractRedisExecution = true;
    private RedisClient redisClient = null;
    private final RedisHeuristicsCalculator calculator = new RedisHeuristicsCalculator(new TaintHandlerExecutionTracer());
    private static final String REDIS_HASH_TYPE = "hash";
    private static final String REDIS_SET_TYPE = "set";
    private static final String REDIS_STRING_TYPE = "string";

    public RedisHandler() {
        this.operations = new ArrayList<RedisCommand>();
    }

    public void reset() {
        this.operations.clear();
        this.evaluatedRedisCommands.clear();
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractRedisExecution() {
        return this.extractRedisExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractRedisExecution(boolean extractRedisExecution) {
        this.extractRedisExecution = extractRedisExecution;
    }

    public void handle(RedisCommand info) {
        if (this.extractRedisExecution) {
            this.operations.add(info);
        }
    }

    public List<RedisCommandEvaluation> getEvaluatedRedisCommands() {
        this.operations.stream().filter(command -> command.getType().shouldCalculateHeuristic()).forEach(redisCommand -> {
            RedisDistanceWithMetrics distanceWithMetrics = this.computeDistance((RedisCommand)redisCommand, this.redisClient);
            this.evaluatedRedisCommands.add(new RedisCommandEvaluation((RedisCommand)redisCommand, distanceWithMetrics));
        });
        this.operations.clear();
        return this.evaluatedRedisCommands;
    }

    private RedisDistanceWithMetrics computeDistance(RedisCommand redisCommand, RedisClient redisClient) {
        RedisCommand.RedisCommandType type = redisCommand.getType();
        try {
            switch (type) {
                case KEYS: 
                case EXISTS: {
                    List<RedisInfo> redisInfo = this.createRedisInfoForAllKeys(redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
                case GET: {
                    List<RedisInfo> redisInfo = this.createRedisInfoForKeysByType(REDIS_STRING_TYPE, redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
                case HGET: {
                    String field = redisCommand.extractArgs().get(1);
                    List<RedisInfo> redisInfo = this.createRedisInfoForKeysByField(field, redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
                case HGETALL: {
                    List<RedisInfo> redisInfo = this.createRedisInfoForKeysByType(REDIS_HASH_TYPE, redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
                case SMEMBERS: {
                    List<RedisInfo> redisInfo = this.createRedisInfoForKeysByType(REDIS_SET_TYPE, redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
                case SINTER: {
                    List<String> keys = redisCommand.extractArgs();
                    List<RedisInfo> redisInfo = this.createRedisInfoForIntersection(keys, redisClient);
                    return this.calculator.computeDistance(redisCommand, redisInfo);
                }
            }
            return new RedisDistanceWithMetrics(1.0, 0);
        }
        catch (Exception e) {
            SimpleLogger.warn("Could not compute distance for " + (Object)((Object)type) + ": " + e.getMessage());
            return new RedisDistanceWithMetrics(1.0, 0);
        }
    }

    private List<RedisInfo> createRedisInfoForIntersection(List<String> keys, RedisClient redisClient) {
        ArrayList<RedisInfo> redisData = new ArrayList<RedisInfo>();
        keys.forEach(key -> redisData.add(new RedisInfo((String)key, redisClient.getType((String)key), redisClient.getSetMembers((String)key))));
        return redisData;
    }

    private List<RedisInfo> createRedisInfoForAllKeys(RedisClient redisClient) {
        Set<String> keys = redisClient.getAllKeys();
        ArrayList<RedisInfo> redisData = new ArrayList<RedisInfo>();
        keys.forEach(key -> redisData.add(new RedisInfo((String)key)));
        return redisData;
    }

    private List<RedisInfo> createRedisInfoForKeysByType(String type, RedisClient redisClient) {
        Set<String> keys = redisClient.getKeysByType(type);
        ArrayList<RedisInfo> redisData = new ArrayList<RedisInfo>();
        keys.forEach(key -> redisData.add(new RedisInfo((String)key)));
        return redisData;
    }

    private List<RedisInfo> createRedisInfoForKeysByField(String field, RedisClient redisClient) {
        Set<String> keys = redisClient.getKeysByType(REDIS_HASH_TYPE);
        ArrayList<RedisInfo> redisData = new ArrayList<RedisInfo>();
        keys.forEach(key -> redisData.add(new RedisInfo((String)key, redisClient.hashFieldExists((String)key, field))));
        return redisData;
    }

    public void setRedisClient(RedisClient redisClient) {
        this.redisClient = redisClient;
    }
}

