/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.mongo.selectors;

import java.util.List;
import java.util.Set;
import org.evomaster.client.java.controller.mongo.operations.NearSphereOperation;
import org.evomaster.client.java.controller.mongo.operations.QueryOperation;
import org.evomaster.client.java.controller.mongo.selectors.QuerySelector;
import org.evomaster.client.java.controller.mongo.utils.BsonHelper;

public class NearSphereSelector
extends QuerySelector {
    public static final int EARTH_RADIUS_IN_METERS = 6371000;

    @Override
    public QueryOperation getOperation(Object query) {
        String fieldName = this.extractFieldName(query);
        Object innerDoc = BsonHelper.getValue(query, fieldName);
        if (!BsonHelper.isDocument(innerDoc).booleanValue() || !this.hasTheExpectedOperator(query).booleanValue()) {
            return null;
        }
        Object point = BsonHelper.getValue(innerDoc, this.operator());
        Object geometry = BsonHelper.getValue(point, "$geometry");
        boolean legacyCoordinates = geometry == null;
        return this.parseValue(fieldName, innerDoc, legacyCoordinates);
    }

    @Override
    protected String extractOperator(Object query) {
        String fieldName = this.extractFieldName(query);
        Set<String> keys = BsonHelper.documentKeys(BsonHelper.getValue(query, fieldName));
        return keys.stream().findFirst().orElse(null);
    }

    @Override
    protected String operator() {
        return "$nearSphere";
    }

    public QueryOperation parseValue(String fieldName, Object innerDoc, boolean legacyCoordinates) {
        Object latitude;
        Object longitude;
        Object maxDistance = null;
        Object minDistance = null;
        Object point = BsonHelper.getValue(innerDoc, this.operator());
        if (legacyCoordinates) {
            Object maxDistanceInRadians = BsonHelper.getValue(innerDoc, "$maxDistance");
            Object minDistanceInRadians = BsonHelper.getValue(innerDoc, "$minDistance");
            if (maxDistanceInRadians instanceof Double) {
                maxDistance = NearSphereSelector.radiansToMeters((Double)maxDistanceInRadians);
            }
            if (minDistanceInRadians instanceof Double) {
                minDistance = NearSphereSelector.radiansToMeters((Double)minDistanceInRadians);
            }
            longitude = BsonHelper.getValue(point, "x");
            latitude = BsonHelper.getValue(point, "y");
        } else {
            Object geometry = BsonHelper.getValue(point, "$geometry");
            Object coordinates = BsonHelper.getValue(geometry, "coordinates");
            if (!(coordinates instanceof List) || ((List)coordinates).size() != 2) {
                return null;
            }
            longitude = ((List)coordinates).get(0);
            latitude = ((List)coordinates).get(1);
            maxDistance = BsonHelper.getValue(point, "$maxDistance");
            minDistance = BsonHelper.getValue(point, "$minDistance");
        }
        if (longitude instanceof Double && latitude instanceof Double && (maxDistance == null || maxDistance instanceof Double) && (minDistance == null || minDistance instanceof Double)) {
            return new NearSphereOperation(fieldName, (Double)longitude, (Double)latitude, (Double)maxDistance, (Double)minDistance);
        }
        return null;
    }

    private static double radiansToMeters(double radians) {
        return 6371000.0 * radians;
    }

    private String extractFieldName(Object query) {
        Set<String> keys = BsonHelper.documentKeys(query);
        return keys.stream().findFirst().orElse(null);
    }
}

