/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.problem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evomaster.client.java.controller.problem.ExternalService;
import org.evomaster.client.java.controller.problem.ProblemInfo;
import org.evomaster.client.java.controller.problem.param.RestDerivedParam;

public class RestProblem
extends ProblemInfo {
    private final String openApiUrl;
    private final List<String> endpointsToSkip;
    private final String openApiSchema;
    private final List<RestDerivedParam> derivedParams;

    public RestProblem(String openApiUrl, List<String> endpointsToSkip) {
        this(openApiUrl, endpointsToSkip, null);
    }

    public RestProblem(String openApiUrl, List<String> endpointsToSkip, String openApiSchema) {
        this(openApiUrl, endpointsToSkip, openApiSchema, null, null);
    }

    public RestProblem(String openApiUrl, List<String> endpointsToSkip, String openApiSchema, List<ExternalService> servicesToNotMock, List<RestDerivedParam> derivedParams) {
        boolean schema;
        this.openApiUrl = openApiUrl;
        this.endpointsToSkip = endpointsToSkip == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(endpointsToSkip));
        this.openApiSchema = openApiSchema;
        this.servicesToNotMock.clear();
        if (servicesToNotMock != null && !servicesToNotMock.isEmpty()) {
            this.servicesToNotMock.addAll(servicesToNotMock);
        }
        this.derivedParams = derivedParams == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<RestDerivedParam>(derivedParams));
        boolean url = openApiUrl != null && !openApiUrl.isEmpty();
        boolean bl = schema = openApiSchema != null && !openApiSchema.isEmpty();
        if (!url && !schema) {
            throw new IllegalArgumentException("MUST either provide a URL or a full schema for OpenAPI");
        }
        if (url && schema) {
            throw new IllegalArgumentException("Cannot specify BOTH a URL and a whole schema. Choose one only");
        }
    }

    @Override
    public RestProblem withServicesToNotMock(List<ExternalService> servicesToNotMock) {
        return new RestProblem(this.openApiUrl, this.endpointsToSkip, this.openApiSchema, servicesToNotMock, this.derivedParams);
    }

    public RestProblem withDerivedParams(List<RestDerivedParam> derivedParams) {
        return new RestProblem(this.openApiUrl, this.endpointsToSkip, this.openApiSchema, this.servicesToNotMock, derivedParams);
    }

    public String getOpenApiUrl() {
        return this.openApiUrl;
    }

    public List<String> getEndpointsToSkip() {
        return this.endpointsToSkip;
    }

    public String getOpenApiSchema() {
        return this.openApiSchema;
    }

    public List<RestDerivedParam> getDerivedParams() {
        return this.derivedParams;
    }
}

