/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.redis;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class RedisClient {
    private final Object redisClient;
    private final Object connection;
    private final Object syncCommands;

    public RedisClient(String host, int port) {
        try {
            Class<?> redisClientClass = Class.forName("io.lettuce.core.RedisClient");
            Class<?> redisURIClass = Class.forName("io.lettuce.core.RedisURI");
            Method createUri = redisURIClass.getMethod("create", String.class);
            Object uri = createUri.invoke(null, "redis://" + host + ":" + port);
            Method createClient = redisClientClass.getMethod("create", redisURIClass);
            this.redisClient = createClient.invoke(null, uri);
            Method connectMethod = redisClientClass.getMethod("connect", new Class[0]);
            this.connection = connectMethod.invoke(this.redisClient, new Object[0]);
            Class<?> statefulConnClass = Class.forName("io.lettuce.core.api.StatefulRedisConnection");
            Method syncMethod = statefulConnClass.getMethod("sync", new Class[0]);
            this.syncCommands = syncMethod.invoke(this.connection, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Lettuce Redis client via reflection", e);
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                Method close = this.connection.getClass().getMethod("close", new Class[0]);
                close.invoke(this.connection, new Object[0]);
            }
            if (this.redisClient != null) {
                Method shutdown = this.redisClient.getClass().getMethod("shutdown", new Class[0]);
                shutdown.invoke(this.redisClient, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(String key, String value) {
        this.invoke("set", key, value);
    }

    public String getValue(String key) {
        return (String)this.invoke("get", key);
    }

    public Set<String> getAllKeys() {
        Object result = this.invoke("keys", "*");
        if (result instanceof Collection) {
            return new HashSet<String>((Collection)result);
        }
        return Collections.emptySet();
    }

    public String getType(String key) {
        Object result = this.invoke("type", key);
        return result != null ? result.toString() : null;
    }

    public void hashSet(String key, String field, String value) {
        this.invoke("hset", key, field, value);
    }

    public boolean hashFieldExists(String key, String field) {
        Object result = this.invoke("hexists", key, field);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public Set<String> getSetMembers(String key) {
        Object result = this.invoke("smembers", key);
        if (result instanceof Collection) {
            return new HashSet<String>((Collection)result);
        }
        return Collections.emptySet();
    }

    private Object invoke(String methodName, Object ... args) {
        try {
            Class[] argTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            Method method = this.findMethod(this.syncCommands.getClass(), methodName, argTypes);
            if (method == null) {
                throw new RuntimeException("Method not found: " + methodName);
            }
            return method.invoke(this.syncCommands, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking Redis command: " + methodName, e);
        }
    }

    private Method findMethod(Class<?> clazz, String name, Class<?>[] argTypes) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterCount() != argTypes.length) continue;
            return m;
        }
        return null;
    }

    public Set<String> getKeysByType(String expectedType) {
        return this.getAllKeys().stream().filter(k -> expectedType.equalsIgnoreCase(this.getType((String)k))).collect(Collectors.toSet());
    }

    public void flushAll() {
        this.invoke("flushall", new Object[0]);
    }
}

