/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.controller.redis;

public class RedisUtils {
    public static String redisPatternToRegex(String redisPattern) {
        if (redisPattern == null || redisPattern.isEmpty()) {
            return ".*";
        }
        StringBuilder regex = new StringBuilder();
        boolean inBrackets = false;
        boolean escaping = false;
        block7: for (int i = 0; i < redisPattern.length(); ++i) {
            char c = redisPattern.charAt(i);
            if (escaping) {
                if (".+(){}|^$[]\\".indexOf(c) >= 0) {
                    regex.append('\\');
                }
                regex.append(c);
                escaping = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escaping = true;
                    continue block7;
                }
                case '*': {
                    regex.append(".*");
                    continue block7;
                }
                case '?': {
                    regex.append('.');
                    continue block7;
                }
                case '[': {
                    if (inBrackets) {
                        throw new IllegalArgumentException("Malformed Redis pattern: nested [");
                    }
                    inBrackets = true;
                    regex.append('[');
                    if (i + 1 >= redisPattern.length() || redisPattern.charAt(i + 1) != '^') continue block7;
                    regex.append('^');
                    ++i;
                    continue block7;
                }
                case ']': {
                    if (inBrackets) {
                        regex.append(']');
                        inBrackets = false;
                        continue block7;
                    }
                    regex.append("\\]");
                    continue block7;
                }
                default: {
                    if (!inBrackets && ".+(){}|^$".indexOf(c) >= 0) {
                        regex.append('\\');
                    }
                    regex.append(c);
                }
            }
        }
        if (escaping) {
            throw new IllegalArgumentException("Malformed Redis pattern: trailing backslash");
        }
        if (inBrackets) {
            throw new IllegalArgumentException("Malformed Redis pattern: unclosed [");
        }
        return "^" + regex + "$";
    }
}

