/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class URLClassReplacement
implements MethodReplacementClass {
    private static ThreadLocal<URL> instance = new ThreadLocal();

    @Override
    public Class<?> getTargetClass() {
        return URL.class;
    }

    public static URL consumeInstance() {
        URL url = instance.get();
        if (url == null) {
            throw new IllegalStateException("No instance to consume");
        }
        instance.set(null);
        return url;
    }

    private static void addInstance(URL x) {
        URL url = instance.get();
        if (url != null) {
            throw new IllegalStateException("Previous instance was not consumed");
        }
        instance.set(x);
    }

    @Replacement(type=ReplacementType.EXCEPTION, category=ReplacementCategory.EXT_0, replacingConstructor=true)
    public static void URL(String s, String idTemplate) throws MalformedURLException {
        URLClassReplacement.URL(null, s, null, idTemplate);
    }

    @Replacement(type=ReplacementType.EXCEPTION, category=ReplacementCategory.EXT_0, replacingConstructor=true)
    public static void URL(URL context, String s, String idTemplate) throws MalformedURLException {
        URLClassReplacement.URL(context, s, null, idTemplate);
    }

    @Replacement(type=ReplacementType.EXCEPTION, category=ReplacementCategory.EXT_0, replacingConstructor=true)
    public static void URL(URL context, String s, URLStreamHandler handler, String idTemplate) throws MalformedURLException {
        URL url;
        if (ExecutionTracer.isTaintInput(s)) {
            ExecutionTracer.addStringSpecialization(s, new StringSpecializationInfo(StringSpecialization.URL, null));
        }
        if (idTemplate == null) {
            url = new URL(context, s, handler);
        } else {
            try {
                URL res = new URL(context, s, handler);
                ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
                url = res;
            }
            catch (RuntimeException e) {
                double h = s == null ? 0.05 : 0.1;
                ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
                throw e;
            }
        }
        URLClassReplacement.addInstance(url);
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, id="URL_openConnection_Replacement", replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static URLConnection openConnection(URL caller) throws IOException {
        Objects.requireNonNull(caller);
        URL newURL = ExternalServiceUtils.getReplacedURL(caller);
        return newURL.openConnection();
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, id="URL_openConnection_proxy_Replacement", replacingStatic=false, usageFilter=UsageFilter.ANY)
    public static URLConnection openConnection(URL caller, Proxy proxy) throws IOException {
        Objects.requireNonNull(caller);
        URL newURL = ExternalServiceUtils.getReplacedURL(caller);
        return newURL.openConnection(proxy);
    }
}

