/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.GraphTransition;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.regex.RegexUtils;
import shaded.dk.brics.automaton.Automaton;
import shaded.dk.brics.automaton.RegExp;
import shaded.dk.brics.automaton.State;
import shaded.dk.brics.automaton.Transition;
import shaded.org.jgrapht.alg.CycleDetector;
import shaded.org.jgrapht.graph.DefaultDirectedGraph;
import shaded.org.jgrapht.graph.DefaultEdge;
import shaded.org.jgrapht.traverse.TopologicalOrderIterator;

public class RegexGraph {
    private static final Map<String, List<State>> regexStateCache = new ConcurrentHashMap<String, List<State>>();
    private static final Map<String, Automaton> regexAutomatonCache = new ConcurrentHashMap<String, Automaton>();
    private final Map<Integer, Map<State, Set<GraphTransition>>> transitions;
    private Map<Integer, State> intToStateMap;
    private Map<State, Integer> stateToIntMap;

    public RegexGraph(String arg, String regex) {
        this.transitions = this.createGraph(arg, regex);
    }

    public int getNumberOfRows() {
        return this.transitions.keySet().size();
    }

    public int getNumberOfColumns() {
        return this.stateToIntMap.size();
    }

    public Set<GraphTransition> getIncomingTransitions(int row, int column) {
        State state = this.intToStateMap.get(column);
        return this.transitions.get(row).get(state);
    }

    public int getColumn(State state) {
        return this.stateToIntMap.get(state);
    }

    private static double normalize(double x) {
        return x / (x + 1.0);
    }

    private static Automaton getAndCacheAutomaton(String regex) {
        if (!regexAutomatonCache.containsKey(regex)) {
            RegexGraph.cacheRegex(regex);
        }
        Automaton automaton = regexAutomatonCache.get(regex);
        return automaton;
    }

    private Map<Integer, Map<State, Set<GraphTransition>>> createGraph(String arg, String regex) {
        Automaton automaton = RegexGraph.getAndCacheAutomaton(regex);
        int NUM_CHARS = arg.length();
        List<State> topologicalOrder = regexStateCache.get(regex);
        HashMap<Integer, Map<State, Set<GraphTransition>>> transitions = new HashMap<Integer, Map<State, Set<GraphTransition>>>();
        this.intToStateMap = new HashMap<Integer, State>();
        this.stateToIntMap = new HashMap<State, Integer>();
        int numState = 0;
        for (State currentState : topologicalOrder) {
            this.stateToIntMap.put(currentState, numState);
            this.intToStateMap.put(numState, currentState);
            ++numState;
            for (Transition t : currentState.getTransitions()) {
                int row;
                State destination = t.getDest();
                RegexGraph.ensureState(transitions, destination, NUM_CHARS);
                for (row = 0; row <= NUM_CHARS; ++row) {
                    ((Set)((Map)transitions.get(row)).get(destination)).add(new GraphTransition(1.0, row, currentState, GraphTransition.TransitionType.INSERTION));
                }
                for (row = 0; row < NUM_CHARS; ++row) {
                    double cost = 0.0;
                    if (arg.charAt(row) < t.getMin() || arg.charAt(row) > t.getMax()) {
                        int distMin = Math.abs(arg.charAt(row) - t.getMin());
                        int distMax = Math.abs(arg.charAt(row) - t.getMax());
                        cost = RegexGraph.normalize(Math.min(distMin, distMax));
                    }
                    ((Set)((Map)transitions.get(row + 1)).get(destination)).add(new GraphTransition(cost, row, currentState, GraphTransition.TransitionType.REPLACEMENT));
                }
            }
            RegexGraph.ensureState(transitions, currentState, NUM_CHARS);
            for (int row = 0; row < NUM_CHARS; ++row) {
                ((Set)((Map)transitions.get(row + 1)).get(currentState)).add(new GraphTransition(1.0, row, currentState, GraphTransition.TransitionType.DELETION));
            }
        }
        State finalState = new State();
        RegexGraph.ensureState(transitions, finalState, NUM_CHARS);
        for (State s : automaton.getStates()) {
            if (!s.isAccept()) continue;
            ((Set)((Map)transitions.get(NUM_CHARS)).get(finalState)).add(new GraphTransition(0.0, NUM_CHARS, s, GraphTransition.TransitionType.PHANTOM));
        }
        this.intToStateMap.put(numState, finalState);
        this.stateToIntMap.put(finalState, numState);
        return transitions;
    }

    private static void ensureState(Map<Integer, Map<State, Set<GraphTransition>>> transitions, State state, int numRows) {
        for (int row = 0; row <= numRows; ++row) {
            if (!transitions.containsKey(row)) {
                transitions.put(row, new HashMap());
            }
            if (transitions.get(row).containsKey(state)) continue;
            transitions.get(row).put(state, new HashSet());
        }
    }

    private static void cacheRegex(String regex) {
        String r = RegexUtils.expandRegex(regex);
        Automaton automaton = new RegExp(r, 0).toAutomaton();
        automaton.expandSingleton();
        DefaultDirectedGraph<State, DefaultEdge> regexGraph = new DefaultDirectedGraph<State, DefaultEdge>(DefaultEdge.class);
        HashSet<State> visitedStates = new HashSet<State>();
        LinkedList<State> states = new LinkedList<State>();
        State initialState = automaton.getInitialState();
        states.add(initialState);
        while (!states.isEmpty()) {
            State currentState = (State)states.poll();
            if (visitedStates.contains(currentState)) continue;
            if (!regexGraph.containsVertex(currentState)) {
                regexGraph.addVertex(currentState);
            }
            for (Transition t : currentState.getTransitions()) {
                if (t.getDest().equals(currentState)) continue;
                regexGraph.addVertex(t.getDest());
                regexGraph.addEdge(currentState, t.getDest());
                states.add(t.getDest());
                CycleDetector det = new CycleDetector(regexGraph);
                if (!det.detectCycles()) continue;
                regexGraph.removeEdge(currentState, t.getDest());
            }
            visitedStates.add(currentState);
        }
        TopologicalOrderIterator iterator = new TopologicalOrderIterator(regexGraph);
        ArrayList<State> topologicalOrder = new ArrayList<State>();
        while (iterator.hasNext()) {
            topologicalOrder.add((State)iterator.next());
        }
        regexStateCache.put(regex, topologicalOrder);
        regexAutomatonCache.put(regex, automaton);
    }
}

