/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evomaster.client.java.instrumentation.RedisCommand;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class StatefulConnectionClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final StatefulConnectionClassReplacement singleton = new StatefulConnectionClassReplacement();
    private static final String DISPATCH = "dispatch";

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "io.lettuce.core.api.StatefulConnection";
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="dispatch", usageFilter=UsageFilter.ANY, category=ReplacementCategory.REDIS, castTo="io.lettuce.core.protocol.RedisCommand")
    public static Object dispatch(Object redis, @ThirdPartyCast(actualType="io.lettuce.core.protocol.RedisCommand") Object command) {
        try {
            RedisCommand.RedisCommandType cmdType;
            long start = System.currentTimeMillis();
            Method m = StatefulConnectionClassReplacement.getOriginal(singleton, DISPATCH, redis);
            Object result = m.invoke(redis, command);
            long end = System.currentTimeMillis();
            Method typeMethod = command.getClass().getMethod("getType", new Class[0]);
            Object typeObj = typeMethod.invoke(command, new Object[0]);
            String typeName = typeObj.toString();
            Method argsMethod = command.getClass().getMethod("getArgs", new Class[0]);
            Object commandArgs = argsMethod.invoke(command, new Object[0]);
            Method toCmdString = commandArgs.getClass().getMethod("toCommandString", new Class[0]);
            String fullCmd = (String)toCmdString.invoke(commandArgs, new Object[0]);
            String[] args = fullCmd.trim().split("\\s+");
            try {
                cmdType = RedisCommand.RedisCommandType.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                cmdType = RedisCommand.RedisCommandType.OTHER;
            }
            StatefulConnectionClassReplacement.addRedisCommand(cmdType, args, end - start);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static String stripKey(String token) {
        if (token != null && token.startsWith("key<") && token.endsWith(">")) {
            return token.substring(4, token.length() - 1);
        }
        return token;
    }

    private static void addRedisCommand(RedisCommand.RedisCommandType type, String[] args, long executionTime) {
        RedisCommand cmd = new RedisCommand(type, args, true, executionTime);
        ExecutionTracer.addRedisCommand(cmd);
    }
}

