/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionLogDto;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionsDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.QueryResultSet;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.sql.heuristic.BooleanLiteralsHelper;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlColumnReference;
import org.evomaster.client.java.sql.heuristic.SqlHeuristicsCalculator;
import org.evomaster.client.java.sql.heuristic.TableColumnResolver;
import org.evomaster.client.java.sql.internal.ColumnTableAnalyzer;
import org.evomaster.client.java.sql.internal.HeuristicsCalculator;
import org.evomaster.client.java.sql.internal.QueryResultTransformer;
import org.evomaster.client.java.sql.internal.SelectTransformer;
import org.evomaster.client.java.sql.internal.SqlColumnId;
import org.evomaster.client.java.sql.internal.SqlCommandWithDistance;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlNameContext;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.SqlTableId;
import org.evomaster.client.java.sql.internal.TablesAndColumnsFinder;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.insert.Insert;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class SqlHandler {
    private final TaintHandler taintHandler;
    private final List<SqlExecutionLogDto> bufferedSqlCommands;
    private final List<SqlCommandWithDistance> distances;
    private final Map<SqlTableId, Set<SqlColumnId>> queriedData;
    private final Map<SqlTableId, Set<SqlColumnId>> updatedData;
    private final Map<SqlTableId, Set<SqlColumnId>> insertedData;
    private final Map<SqlTableId, Set<SqlColumnId>> failedWhere;
    private final List<SqlTableId> deletedData;
    private final List<SqlExecutionLogDto> executedSqlCommands;
    private int numberOfSqlCommands;
    private int sqlParseFailureCount;
    private volatile Connection connection;
    private volatile boolean calculateHeuristics;
    private volatile boolean extractSqlExecution;
    private volatile boolean completeSqlHeuristics;
    private volatile DbInfoDto schema;

    public SqlHandler(TaintHandler taintHandler) {
        this.taintHandler = taintHandler;
        this.bufferedSqlCommands = new CopyOnWriteArrayList<SqlExecutionLogDto>();
        this.distances = new ArrayList<SqlCommandWithDistance>();
        this.queriedData = new ConcurrentHashMap<SqlTableId, Set<SqlColumnId>>();
        this.updatedData = new ConcurrentHashMap<SqlTableId, Set<SqlColumnId>>();
        this.insertedData = new ConcurrentHashMap<SqlTableId, Set<SqlColumnId>>();
        this.failedWhere = new ConcurrentHashMap<SqlTableId, Set<SqlColumnId>>();
        this.deletedData = new CopyOnWriteArrayList<SqlTableId>();
        this.executedSqlCommands = new CopyOnWriteArrayList<SqlExecutionLogDto>();
        this.calculateHeuristics = true;
        this.numberOfSqlCommands = 0;
        this.sqlParseFailureCount = 0;
    }

    public void reset() {
        this.bufferedSqlCommands.clear();
        this.distances.clear();
        this.queriedData.clear();
        this.updatedData.clear();
        this.insertedData.clear();
        this.failedWhere.clear();
        this.deletedData.clear();
        this.executedSqlCommands.clear();
        this.numberOfSqlCommands = 0;
        this.sqlParseFailureCount = 0;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSchema(DbInfoDto schema) {
        this.schema = schema;
    }

    public void handle(SqlExecutionLogDto sqlExecutionLogDto) {
        this.executedSqlCommands.add(sqlExecutionLogDto);
        String sqlCommand = sqlExecutionLogDto.sqlCommand;
        Objects.requireNonNull(sqlCommand);
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return;
        }
        ++this.numberOfSqlCommands;
        if (!SqlParserUtils.canParseSqlStatement(sqlCommand)) {
            ++this.sqlParseFailureCount;
            SimpleLogger.warn("Cannot parse SQL statement: " + sqlCommand);
            return;
        }
        this.bufferedSqlCommands.add(sqlExecutionLogDto);
        if (this.completeSqlHeuristics) {
            this.mergeNewDataForCompleteSqlHeuristics(sqlCommand);
        } else {
            this.mergeNewDataForPartialSqlHeuristics(sqlCommand);
        }
    }

    private void mergeNewDataForCompleteSqlHeuristics(String sqlCommand) {
        Statement parsedSqlCommand = SqlParserUtils.parseSqlCommand(sqlCommand);
        if (parsedSqlCommand instanceof Select || parsedSqlCommand instanceof Delete || parsedSqlCommand instanceof Insert || parsedSqlCommand instanceof Update) {
            Map<SqlTableId, Set<SqlColumnId>> columns = this.extractColumnsInvolvedInStatement(parsedSqlCommand);
            if (parsedSqlCommand instanceof Select) {
                SqlHandler.mergeNewData(this.queriedData, columns);
            } else if (parsedSqlCommand instanceof Delete) {
                this.deletedData.addAll(columns.keySet());
            } else if (parsedSqlCommand instanceof Insert) {
                SqlHandler.mergeNewData(this.insertedData, columns);
            } else if (parsedSqlCommand instanceof Update) {
                SqlHandler.mergeNewData(this.updatedData, columns);
            }
        }
    }

    private void mergeNewDataForPartialSqlHeuristics(String sqlCommand) {
        if (SqlParserUtils.isSelect(sqlCommand)) {
            SqlHandler.mergeNewData(this.queriedData, ColumnTableAnalyzer.getSelectReadDataFields(sqlCommand));
        } else if (SqlParserUtils.isDelete(sqlCommand)) {
            this.deletedData.add(ColumnTableAnalyzer.getDeletedTable(sqlCommand));
        } else if (SqlParserUtils.isInsert(sqlCommand)) {
            Map.Entry<SqlTableId, Set<SqlColumnId>> insertedDataFields = ColumnTableAnalyzer.getInsertedDataFields(sqlCommand);
            SqlHandler.mergeNewData(this.insertedData, Collections.singletonMap(insertedDataFields.getKey(), insertedDataFields.getValue()));
        } else if (SqlParserUtils.isUpdate(sqlCommand)) {
            Map.Entry<SqlTableId, Set<SqlColumnId>> updatedDataFields = ColumnTableAnalyzer.getUpdatedDataFields(sqlCommand);
            SqlHandler.mergeNewData(this.updatedData, Collections.singletonMap(updatedDataFields.getKey(), updatedDataFields.getValue()));
        }
    }

    public SqlExecutionsDto getExecutionDto() {
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return null;
        }
        SqlExecutionsDto sqlExecutionsDto = new SqlExecutionsDto();
        sqlExecutionsDto.queriedData.putAll(SqlHandler.getTableToColumnsMap(this.queriedData));
        sqlExecutionsDto.failedWhere.putAll(SqlHandler.getTableToColumnsMap(this.failedWhere));
        sqlExecutionsDto.insertedData.putAll(SqlHandler.getTableToColumnsMap(this.insertedData));
        sqlExecutionsDto.updatedData.putAll(SqlHandler.getTableToColumnsMap(this.updatedData));
        sqlExecutionsDto.deletedData.addAll(this.deletedData.stream().map(SqlTableId::getTableId).collect(Collectors.toSet()));
        sqlExecutionsDto.numberOfSqlCommands = this.numberOfSqlCommands;
        sqlExecutionsDto.sqlParseFailureCount = this.sqlParseFailureCount;
        sqlExecutionsDto.sqlExecutionLogDtoList.addAll(this.executedSqlCommands);
        return sqlExecutionsDto;
    }

    private static Map<String, Set<String>> getTableToColumnsMap(Map<SqlTableId, Set<SqlColumnId>> originalMap) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<SqlTableId, Set<SqlColumnId>> originalEntry : originalMap.entrySet()) {
            result.put(originalEntry.getKey().getTableId(), originalEntry.getValue().stream().map(SqlColumnId::getColumnId).collect(Collectors.toSet()));
        }
        return result;
    }

    private boolean isValidSqlCommandForDistanceEvaluation(String sqlCommand) {
        return !SqlParserUtils.isSelectOne(sqlCommand) && (SqlParserUtils.isSelect(sqlCommand) || SqlParserUtils.isDelete(sqlCommand) || SqlParserUtils.isUpdate(sqlCommand));
    }

    public List<SqlCommandWithDistance> getSqlDistances(List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase) {
        if (this.connection == null || !this.calculateHeuristics) {
            return this.distances;
        }
        if (!this.bufferedSqlCommands.isEmpty()) {
            this.bufferedSqlCommands.forEach(sqlExecutionLogDto -> {
                String sqlCommand = sqlExecutionLogDto.sqlCommand;
                if (!sqlExecutionLogDto.threwSqlExeception && (this.completeSqlHeuristics ? SqlHeuristicsCalculator.isValidSqlCommandForSqlHeuristicsCalculation(sqlCommand) : this.isValidSqlCommandForDistanceEvaluation(sqlCommand))) {
                    Statement parsedStatement = SqlParserUtils.parseSqlCommand(sqlCommand);
                    SqlDistanceWithMetrics sqlDistance = this.computeDistance(sqlCommand, parsedStatement, successfulInitSqlInsertions, queryFromDatabase);
                    this.distances.add(new SqlCommandWithDistance(sqlCommand, sqlDistance));
                }
            });
            this.bufferedSqlCommands.clear();
        }
        return this.distances;
    }

    private SqlDistanceWithMetrics computeDistance(String sqlCommand, Statement parsedStatement, List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase) {
        SqlDistanceWithMetrics dist;
        Map<SqlTableId, Set<SqlColumnId>> columns;
        if (this.connection == null) {
            throw new IllegalStateException("Trying to calculate SQL distance with no DB connection");
        }
        if (this.completeSqlHeuristics) {
            columns = this.extractColumnsInvolvedInStatement(parsedStatement);
            dist = this.computeCompleteSqlDistance(sqlCommand, parsedStatement, successfulInitSqlInsertions, queryFromDatabase, columns);
        } else {
            columns = this.extractColumnsInvolvedInWhere(parsedStatement);
            dist = this.computePartialSqlDistance(sqlCommand, parsedStatement, successfulInitSqlInsertions, queryFromDatabase);
        }
        if (dist.sqlDistance > 0.0) {
            SqlHandler.mergeNewData(this.failedWhere, columns);
        }
        return dist;
    }

    private SqlDistanceWithMetrics computeCompleteSqlDistance(String sqlCommand, Statement parsedStatement, List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase, Map<SqlTableId, Set<SqlColumnId>> columns) {
        QueryResultSet queryResultSet;
        if (!SqlHeuristicsCalculator.isValidSqlCommandForSqlHeuristicsCalculation(parsedStatement)) {
            throw new IllegalArgumentException("Cannot compute distance for sql command: " + sqlCommand);
        }
        if (queryFromDatabase) {
            try {
                List<QueryResult> queryResults = this.getQueryResultsForComputingSqlDistance(columns);
                queryResultSet = new QueryResultSet();
                for (QueryResult queryResult : queryResults) {
                    queryResultSet.addQueryResult(queryResult);
                }
            }
            catch (SQLException e) {
                SimpleLogger.uniqueWarn("Failed to execute query for retrieving data for computing SQL heuristics: " + sqlCommand);
                return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0, true);
            }
        } else {
            queryResultSet = QueryResultTransformer.translateInsertionDtos(successfulInitSqlInsertions, columns, this.schema);
        }
        SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder builder = new SqlHeuristicsCalculator.SqlHeuristicsCalculatorBuilder();
        SqlHeuristicsCalculator sqlHeuristicsCalculator = builder.withTableColumnResolver(new TableColumnResolver(this.schema)).withTaintHandler(this.taintHandler).withSourceQueryResultSet(queryResultSet).build();
        SqlDistanceWithMetrics sqlDistanceWithMetrics = sqlHeuristicsCalculator.computeDistance(sqlCommand);
        return sqlDistanceWithMetrics;
    }

    private Map<SqlTableId, Set<SqlColumnId>> extractColumnsInvolvedInStatement(Statement statement) {
        TablesAndColumnsFinder finder = new TablesAndColumnsFinder(this.schema);
        statement.accept(finder);
        HashMap<SqlTableId, Set<SqlColumnId>> columns = new HashMap<SqlTableId, Set<SqlColumnId>>();
        for (SqlBaseTableReference baseTableReference : finder.getBaseTableReferences()) {
            SqlTableId tableId = baseTableReference.getTableId();
            if (finder.containsColumnReferences(baseTableReference)) {
                Set columnIds = finder.getColumnReferences(baseTableReference).stream().map(SqlColumnReference::getColumnName).map(SqlColumnId::new).collect(Collectors.toSet());
                columns.put(tableId, columnIds);
                continue;
            }
            columns.put(tableId, new LinkedHashSet());
        }
        return columns;
    }

    private List<QueryResult> getQueryResultsForComputingSqlDistance(Map<SqlTableId, Set<SqlColumnId>> columnsInWhere) throws SQLException {
        ArrayList<QueryResult> queryResults = new ArrayList<QueryResult>();
        for (SqlTableId tableId : columnsInWhere.keySet().stream().sorted().collect(Collectors.toList())) {
            List<SqlColumnId> columnIds = columnsInWhere.get(tableId).stream().sorted().collect(Collectors.toList());
            String select = columnIds.isEmpty() ? SqlHandler.createSelectForSingleTable(tableId, Collections.singletonList(new SqlColumnId("*"))) : SqlHandler.createSelectForSingleTable(tableId, columnIds);
            QueryResult queryResult = SqlScriptRunner.execCommand(this.connection, select);
            queryResults.add(queryResult);
        }
        return queryResults;
    }

    private SqlDistanceWithMetrics computePartialSqlDistance(String sqlCommand, Statement parsedStatement, List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase) {
        Map<SqlTableId, Set<SqlColumnId>> columns = this.extractColumnsInvolvedInWhere(parsedStatement);
        SqlDistanceWithMetrics dist = columns.isEmpty() || queryFromDatabase ? this.getDistanceForWhere(sqlCommand, columns) : this.getDistanceForWhereBasedOnInsertion(sqlCommand, columns, successfulInitSqlInsertions);
        return dist;
    }

    private SqlDistanceWithMetrics getDistanceForWhereBasedOnInsertion(String sqlCommand, Map<SqlTableId, Set<SqlColumnId>> columns, List<InsertionDto> insertionDtos) {
        QueryResult[] data = QueryResultTransformer.convertInsertionDtosToQueryResults(insertionDtos, columns, this.schema);
        assert (data != null);
        return HeuristicsCalculator.computeDistance(sqlCommand, this.schema, this.taintHandler, data);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlDistanceWithMetrics getDistanceForWhere(String sqlCommand, Map<SqlTableId, Set<SqlColumnId>> columns) {
        String select;
        if (!(SqlParserUtils.isSelect(sqlCommand) || SqlParserUtils.isDelete(sqlCommand) || SqlParserUtils.isUpdate(sqlCommand))) {
            throw new IllegalArgumentException("Cannot compute distance for sql command: " + sqlCommand);
        }
        if (SqlParserUtils.isSelect(sqlCommand)) {
            select = SelectTransformer.addFieldsToSelect(sqlCommand);
            select = SelectTransformer.removeConstraints(select);
            select = SelectTransformer.removeOperations(select);
        } else {
            void var5_10;
            SqlTableId tableName;
            if (columns.size() > 1) {
                SimpleLogger.uniqueWarn("Cannot analyze: " + sqlCommand);
            }
            if (columns.isEmpty()) {
                if (SqlParserUtils.isUpdate(sqlCommand)) {
                    Map.Entry<SqlTableId, Set<SqlColumnId>> updatedDataFields = ColumnTableAnalyzer.getUpdatedDataFields(sqlCommand);
                    tableName = updatedDataFields.getKey();
                    List<SqlColumnId> list = Collections.singletonList(new SqlColumnId("*"));
                } else {
                    if (!SqlParserUtils.isDelete(sqlCommand)) throw new IllegalStateException("SQL command should only be SELECT, UPDATE or DELETE");
                    tableName = ColumnTableAnalyzer.getDeletedTable(sqlCommand);
                    List<SqlColumnId> list = Collections.singletonList(new SqlColumnId("*"));
                }
            } else {
                Map.Entry<SqlTableId, Set<SqlColumnId>> tableToColumns = columns.entrySet().iterator().next();
                tableName = tableToColumns.getKey();
                List list = tableToColumns.getValue().stream().sorted().collect(Collectors.toList());
            }
            select = SqlHandler.createSelectForSingleTable(tableName, (List<SqlColumnId>)var5_10);
        }
        try {
            QueryResult data = SqlScriptRunner.execCommand(this.connection, select);
            return HeuristicsCalculator.computeDistance(sqlCommand, this.schema, this.taintHandler, data);
        }
        catch (SQLException sQLException) {
            SimpleLogger.uniqueWarn("Failed to execute query for retrieving data for computing SQL heuristics: " + select);
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0, true);
        }
    }

    private static String createSelectForSingleTable(SqlTableId tableId, List<SqlColumnId> columnIds) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        String variables = columnIds.stream().map(SqlColumnId::getColumnId).collect(Collectors.joining(", "));
        buffer.append(variables);
        buffer.append(" FROM ");
        buffer.append(tableId.getTableId());
        return buffer.toString();
    }

    Map<SqlTableId, Set<SqlColumnId>> extractColumnsInvolvedInWhere(Statement statement) {
        final HashMap<SqlTableId, Set<SqlColumnId>> result = new HashMap<SqlTableId, Set<SqlColumnId>>();
        Expression where = SqlParserUtils.getWhere(statement);
        if (where == null) {
            return result;
        }
        final SqlNameContext context = new SqlNameContext(statement);
        if (this.schema != null) {
            context.setSchema(this.schema);
        }
        ExpressionVisitorAdapter visitor = new ExpressionVisitorAdapter(){

            @Override
            public void visit(Column column) {
                String tableName = context.getFullyQualifiedTableName(column);
                if (tableName.equalsIgnoreCase("___unnamed_table___")) {
                    return;
                }
                String columnName = column.getColumnName().toLowerCase();
                if (!context.hasColumn(tableName, columnName)) {
                    if (!BooleanLiteralsHelper.isBooleanLiteral(columnName).booleanValue()) {
                        SimpleLogger.warn("Cannot find column '" + columnName + "' in table '" + tableName + "'");
                    }
                    return;
                }
                result.putIfAbsent(new SqlTableId(tableName), new HashSet());
                Set columnIds = (Set)result.get(new SqlTableId(tableName));
                columnIds.add(new SqlColumnId(columnName));
            }
        };
        where.accept(visitor);
        return result;
    }

    static void mergeNewData(Map<SqlTableId, Set<SqlColumnId>> current, Map<SqlTableId, Set<SqlColumnId>> toAdd) {
        for (Map.Entry<SqlTableId, Set<SqlColumnId>> e : toAdd.entrySet()) {
            SqlTableId key = e.getKey();
            Set<SqlColumnId> values = e.getValue();
            Set<SqlColumnId> existing = current.get(key);
            if (existing != null && existing.contains(new SqlColumnId("*"))) continue;
            if (existing == null) {
                existing = new HashSet<SqlColumnId>(values);
                current.put(key, existing);
            } else {
                existing.addAll(values);
            }
            if (existing.size() <= 1 || !existing.contains(new SqlColumnId("*"))) continue;
            existing.clear();
            existing.add(new SqlColumnId("*"));
        }
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractSqlExecution() {
        return this.extractSqlExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractSqlExecution(boolean extractSqlExecution) {
        this.extractSqlExecution = extractSqlExecution;
    }

    public boolean isCompleteSqlHeuristics() {
        return this.completeSqlHeuristics;
    }

    public void setCompleteSqlHeuristics(boolean completeSqlHeuristics) {
        this.completeSqlHeuristics = completeSqlHeuristics;
    }
}

