/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryUtil.class);
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private BinaryUtil() {
    }

    public static String toBase64String(byte ... bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] fromBase64String(String base64String) {
        return Base64.getDecoder().decode(base64String);
    }

    public static byte[] md5(byte ... bytes) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(bytes);
        return messageDigest.digest();
    }

    public static String md5Hex(String str, boolean toLowerCase) {
        byte[] bs;
        char[] digits = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        try {
            bs = BinaryUtil.md5(str.getBytes(Charset.forName("utf-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        int l = bs.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & bs[i]) >>> 4];
            out[j++] = digits[0xF & bs[i]];
        }
        return new String(out);
    }

    public static String md5Hex(File file, boolean toLowerCase) {
        MessageDigest messageDigest;
        char[] digits = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try (FileInputStream data = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int read = data.read(buffer, 0, 1024);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = data.read(buffer, 0, 1024);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "";
        }
        byte[] bs = messageDigest.digest();
        int l = bs.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & bs[i]) >>> 4];
            out[j++] = digits[0xF & bs[i]];
        }
        return new String(out);
    }
}

