/*
 * Decompiled with CFR 0.152.
 */
package org.fastquery.httpsign;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.fastquery.httpsign.Err;

public class ReplyBuilder {
    private ReplyBuilder() {
    }

    public static Response.ResponseBuilder success(JSONObject data) {
        JSONObject json = new JSONObject();
        json.put("code", (Object)0);
        json.put("data", (Object)data);
        return Response.ok((Object)json.toJSONString());
    }

    public static Response.ResponseBuilder success(JSONArray data) {
        JSONObject json = new JSONObject();
        json.put("code", (Object)0);
        json.put("data", (Object)data);
        return Response.ok((Object)json.toJSONString());
    }

    public static Response.ResponseBuilder error(Err err) {
        return ReplyBuilder.error(err.getId(), err.getStatus(), err.getMessage());
    }

    public static Response.ResponseBuilder error(Err err, String append) {
        Objects.requireNonNull(append);
        return ReplyBuilder.error(err.getId(), err.getStatus(), err.getMessage() + append);
    }

    static Response.ResponseBuilder error(int code, int status, String message) {
        Objects.requireNonNull(message);
        JSONObject json = new JSONObject();
        json.put("code", (Object)code);
        json.put("message", (Object)message);
        return Response.ok((Object)json.toJSONString()).type("application/json").status(status);
    }
}

