/*
 * Decompiled with CFR 0.152.
 */
package fj.data.fingertrees;

import fj.Bottom;
import fj.F;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Stream;
import fj.data.fingertrees.Deep;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Measured;
import fj.data.fingertrees.Single;

public final class Empty<V, A>
extends FingerTree<V, A> {
    Empty(Measured<V, A> m) {
        super(m);
    }

    @Override
    public FingerTree<V, A> cons(A a) {
        return new Single(this.measured(), a);
    }

    @Override
    public FingerTree<V, A> snoc(A a) {
        return this.cons(a);
    }

    @Override
    public A head() {
        throw Bottom.error("Selection of head in empty tree");
    }

    @Override
    public A last() {
        throw Bottom.error("Selection of last in empty tree");
    }

    @Override
    public FingerTree<V, A> tail() {
        throw Bottom.error("Selection of tail in empty tree");
    }

    @Override
    public FingerTree<V, A> init() {
        throw Bottom.error("Selection of init in empty tree");
    }

    @Override
    public FingerTree<V, A> append(FingerTree<V, A> t) {
        return t;
    }

    @Override
    public P2<Integer, A> lookup(F<V, Integer> o, int i) {
        throw Bottom.error("Lookup of empty tree.");
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public <B> B foldRight(F<A, F<B, B>> aff, B z) {
        return z;
    }

    @Override
    public A reduceRight(F<A, F<A, A>> aff) {
        throw Bottom.error("Reduction of empty tree");
    }

    @Override
    public <B> B foldLeft(F<B, F<A, B>> bff, B z) {
        return z;
    }

    @Override
    public A reduceLeft(F<A, F<A, A>> aff) {
        throw Bottom.error("Reduction of empty tree");
    }

    @Override
    public <B> FingerTree<V, B> map(F<A, B> abf, Measured<V, B> m) {
        return new Empty<V, B>(m);
    }

    @Override
    public V measure() {
        return this.measured().zero();
    }

    @Override
    public <B> B match(F<Empty<V, A>, B> empty, F<Single<V, A>, B> single, F<Deep<V, A>, B> deep) {
        return empty.f(this);
    }

    @Override
    P3<FingerTree<V, A>, A, FingerTree<V, A>> split1(F<V, Boolean> predicate, V acc) {
        throw Bottom.error("Splitting an empty tree");
    }

    public String toString() {
        return Show.fingerTreeShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    @Override
    public Stream<A> toStream() {
        return Stream.nil();
    }
}

