/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.gitlab.api.http.GitlabHTTPRequestor;
import org.gitlab.api.http.Query;
import org.gitlab.api.models.GitlabAccessLevel;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabCommit;
import org.gitlab.api.models.GitlabGroup;
import org.gitlab.api.models.GitlabGroupMember;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMergeRequest;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabNamespace;
import org.gitlab.api.models.GitlabNote;
import org.gitlab.api.models.GitlabProject;
import org.gitlab.api.models.GitlabProjectHook;
import org.gitlab.api.models.GitlabProjectMember;
import org.gitlab.api.models.GitlabSession;

public class GitlabAPI {
    private final String _hostUrl;
    private final String _apiToken;
    private boolean _ignoreCertificateErrors = false;
    private static final String API_NAMESPACE = "/api/v3";
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private GitlabAPI(String hostUrl, String apiToken) {
        this._hostUrl = hostUrl.endsWith("/") ? hostUrl.replaceAll("/$", "") : hostUrl;
        this._apiToken = apiToken;
    }

    public static GitlabSession connect(String hostUrl, String username, String password) throws IOException {
        String tailUrl = "/session";
        GitlabAPI api = GitlabAPI.connect(hostUrl, null);
        return api.dispatch().with("login", username).with("password", password).to(tailUrl, GitlabSession.class);
    }

    public static GitlabAPI connect(String hostUrl, String apiToken) {
        return new GitlabAPI(hostUrl, apiToken);
    }

    public GitlabAPI ignoreCertificateErrors(boolean ignoreCertificateErrors) {
        this._ignoreCertificateErrors = ignoreCertificateErrors;
        return this;
    }

    public GitlabHTTPRequestor retrieve() {
        return new GitlabHTTPRequestor(this);
    }

    public GitlabHTTPRequestor dispatch() {
        return new GitlabHTTPRequestor(this).method("POST");
    }

    public boolean isIgnoreCertificateErrors() {
        return this._ignoreCertificateErrors;
    }

    public URL getAPIUrl(String tailAPIUrl) throws IOException {
        if (this._apiToken != null) {
            tailAPIUrl = tailAPIUrl + (tailAPIUrl.indexOf(63) > 0 ? (char)'&' : '?') + "private_token=" + this._apiToken;
        }
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this._hostUrl + API_NAMESPACE + tailAPIUrl);
    }

    public URL getUrl(String tailAPIUrl) throws IOException {
        if (!tailAPIUrl.startsWith("/")) {
            tailAPIUrl = "/" + tailAPIUrl;
        }
        return new URL(this._hostUrl + tailAPIUrl);
    }

    public GitlabGroup getGroup(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId;
        return this.retrieve().to(tailUrl, GitlabGroup.class);
    }

    public List<GitlabGroup> getGroups() throws IOException {
        String tailUrl = "/groups";
        return this.retrieve().getAll(tailUrl, GitlabGroup[].class);
    }

    public List<GitlabGroupMember> getGroupMembers(GitlabGroup group) throws IOException {
        return this.getGroupMembers(group.getId());
    }

    public List<GitlabGroupMember> getGroupMembers(Integer groupId) throws IOException {
        String tailUrl = "/groups/" + groupId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabGroupMember[].class));
    }

    public GitlabGroup createGroup(String name) throws IOException {
        return this.createGroup(name, name);
    }

    public GitlabGroup createGroup(String name, String path) throws IOException {
        return this.createGroup(name, path, null, null);
    }

    public GitlabGroup createGroup(String name, String path, String ldapCn, GitlabAccessLevel ldapAccess) throws IOException {
        Query query = new Query().append("name", name).append("path", path).appendIf("ldap_cn", ldapCn).appendIf("ldap_access", ldapAccess);
        String tailUrl = "/groups" + query.toString();
        return this.dispatch().to(tailUrl, GitlabGroup.class);
    }

    public GitlabProject getProject(Integer projectId) throws IOException {
        String tailUrl = "/projects/" + projectId;
        return this.retrieve().to(tailUrl, GitlabProject.class);
    }

    public List<GitlabProject> getProjects() throws IOException {
        String tailUrl = "/projects";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public List<GitlabProject> getAllProjects() throws IOException {
        String tailUrl = "/projects/all";
        return this.retrieve().getAll(tailUrl, GitlabProject[].class);
    }

    public GitlabProject createProject(String name) throws IOException {
        return this.createProject(name, null, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createProject(String name, Integer namespaceId, String description, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel, String importUrl) throws IOException {
        Query query = new Query().append("name", name).appendIf("namespace_id", namespaceId).appendIf("description", description).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel).appendIf("import_url", importUrl);
        String tailUrl = "/projects" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public GitlabProject createUserProject(Integer userId, String name) throws IOException {
        return this.createUserProject(userId, name, null, null, null, null, null, null, null, null, null);
    }

    public GitlabProject createUserProject(Integer userId, String name, String description, String defaultBranch, Boolean issuesEnabled, Boolean wallEnabled, Boolean mergeRequestsEnabled, Boolean wikiEnabled, Boolean snippetsEnabled, Boolean publik, Integer visibilityLevel) throws IOException {
        Query query = new Query().append("name", name).appendIf("description", description).appendIf("default_branch", defaultBranch).appendIf("issues_enabled", issuesEnabled).appendIf("wall_enabled", wallEnabled).appendIf("merge_requests_enabled", mergeRequestsEnabled).appendIf("wiki_enabled", wikiEnabled).appendIf("snippets_enabled", snippetsEnabled).appendIf("public", publik).appendIf("visibility_level", visibilityLevel);
        String tailUrl = "/projects/user/" + userId + query.toString();
        return this.dispatch().to(tailUrl, GitlabProject.class);
    }

    public List<GitlabMergeRequest> getOpenMergeRequests(GitlabProject project) throws IOException {
        List<GitlabMergeRequest> allMergeRequests = this.getAllMergeRequests(project);
        ArrayList<GitlabMergeRequest> openMergeRequests = new ArrayList<GitlabMergeRequest>();
        for (GitlabMergeRequest mergeRequest : allMergeRequests) {
            if (mergeRequest.isMerged() || mergeRequest.isClosed()) continue;
            openMergeRequests.add(mergeRequest);
        }
        return openMergeRequests;
    }

    public List<GitlabMergeRequest> getMergeRequests(Integer projectId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/merge_requests";
        return this.fetchMergeRequests(tailUrl);
    }

    public List<GitlabMergeRequest> getMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.fetchMergeRequests(tailUrl);
    }

    public List<GitlabMergeRequest> getAllMergeRequests(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_requests";
        return this.retrieve().getAll(tailUrl, GitlabMergeRequest[].class);
    }

    public GitlabMergeRequest getMergeRequest(GitlabProject project, Integer mergeRequestId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/merge_request/" + mergeRequestId;
        return this.retrieve().to(tailUrl, GitlabMergeRequest.class);
    }

    public List<GitlabNote> getNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        GitlabNote[] notes = this.retrieve().to(tailUrl, GitlabNote[].class);
        return Arrays.asList(notes);
    }

    public List<GitlabNote> getAllNotes(GitlabMergeRequest mergeRequest) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.retrieve().getAll(tailUrl, GitlabNote[].class);
    }

    public List<GitlabCommit> getCommits(GitlabMergeRequest mergeRequest) throws IOException {
        Integer projectId = mergeRequest.getSourceProjectId();
        if (projectId == null) {
            projectId = mergeRequest.getProjectId();
        }
        Query query = new Query().append("ref_name", mergeRequest.getSourceBranch());
        String tailUrl = "/projects/" + projectId + "/repository" + "/commits" + query.toString();
        GitlabCommit[] commits = this.retrieve().to(tailUrl, GitlabCommit[].class);
        return Arrays.asList(commits);
    }

    public GitlabNote createNote(GitlabMergeRequest mergeRequest, String body) throws IOException {
        String tailUrl = "/projects/" + mergeRequest.getProjectId() + "/merge_requests" + "/" + mergeRequest.getId() + "/notes";
        return this.dispatch().with("body", body).to(tailUrl, GitlabNote.class);
    }

    public List<GitlabBranch> getBranches(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/";
        GitlabBranch[] branches = this.retrieve().to(tailUrl, GitlabBranch[].class);
        return Arrays.asList(branches);
    }

    public GitlabBranch getBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName;
        GitlabBranch branch = this.retrieve().to(tailUrl, GitlabBranch.class);
        return branch;
    }

    public void protectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName + "/protect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public void unprotectBranch(GitlabProject project, String branchName) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/repository/branches/" + branchName + "/unprotect";
        this.retrieve().method("PUT").to(tailUrl, Void.class);
    }

    public List<GitlabProjectHook> getProjectHooks(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks";
        GitlabProjectHook[] hooks = this.retrieve().to(tailUrl, GitlabProjectHook[].class);
        return Arrays.asList(hooks);
    }

    public GitlabProjectHook getProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        GitlabProjectHook hook = this.retrieve().to(tailUrl, GitlabProjectHook.class);
        return hook;
    }

    public GitlabProjectHook addProjectHook(GitlabProject project, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + query.toString();
        return this.dispatch().to(tailUrl, GitlabProjectHook.class);
    }

    public GitlabProjectHook editProjectHook(GitlabProject project, String hookId, String url) throws IOException {
        Query query = new Query().append("url", url);
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId + query.toString();
        return this.retrieve().method("PUT").to(tailUrl, GitlabProjectHook.class);
    }

    public void deleteProjectHook(GitlabProject project, String hookId) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/hooks" + "/" + hookId;
        this.retrieve().method("DELETE").to(tailUrl, Void.class);
    }

    private List<GitlabMergeRequest> fetchMergeRequests(String tailUrl) throws IOException {
        GitlabMergeRequest[] mergeRequests = this.retrieve().to(tailUrl, GitlabMergeRequest[].class);
        return Arrays.asList(mergeRequests);
    }

    public List<GitlabIssue> getIssues(GitlabProject project) throws IOException {
        String tailUrl = "/projects/" + project.getId() + "/issues";
        return this.retrieve().getAll(tailUrl, GitlabIssue[].class);
    }

    public GitlabIssue getIssue(Integer projectId, Integer issueId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId;
        return this.retrieve().to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue createIssue(int projectId, int assigneeId, int milestoneId, String labels, String description, String title) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues";
        GitlabHTTPRequestor requestor = this.dispatch();
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    public GitlabIssue editIssue(int projectId, int issueId, int assigneeId, int milestoneId, String labels, String description, String title, GitlabIssue.Action action) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId;
        GitlabHTTPRequestor requestor = this.retrieve().method("PUT");
        this.applyIssue(requestor, projectId, assigneeId, milestoneId, labels, description, title);
        if (action != GitlabIssue.Action.LEAVE) {
            requestor.with("state_event", action.toString().toLowerCase());
        }
        return requestor.to(tailUrl, GitlabIssue.class);
    }

    private void applyIssue(GitlabHTTPRequestor requestor, int projectId, int assigneeId, int milestoneId, String labels, String description, String title) {
        requestor.with("title", title).with("description", description).with("labels", labels).with("milestone_id", milestoneId);
        if (assigneeId != 0) {
            requestor.with("assignee_id", assigneeId == -1 ? 0 : assigneeId);
        }
    }

    public List<GitlabNote> getNotes(GitlabIssue issue) throws IOException {
        String tailUrl = "/projects/" + issue.getProjectId() + "/issues" + "/" + issue.getId() + "/notes";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabNote[].class));
    }

    public GitlabNote createNote(Integer projectId, Integer issueId, String message) throws IOException {
        String tailUrl = "/projects/" + projectId + "/issues" + "/" + issueId + "/notes";
        return this.dispatch().with("body", message).to(tailUrl, GitlabNote.class);
    }

    public GitlabNote createNote(GitlabIssue issue, String message) throws IOException {
        return this.createNote(issue.getProjectId(), issue.getId(), message);
    }

    public List<GitlabMilestone> getMilestones(GitlabProject project) throws IOException {
        return this.getMilestones(project.getId());
    }

    public List<GitlabMilestone> getMilestones(Integer projectId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/milestones";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabMilestone[].class));
    }

    public List<GitlabProjectMember> getProjectMembers(GitlabProject project) throws IOException {
        return this.getProjectMembers(project.getId());
    }

    public List<GitlabProjectMember> getProjectMembers(Integer projectId) throws IOException {
        String tailUrl = "/projects/" + projectId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public List<GitlabProjectMember> getNamespaceMembers(GitlabNamespace namespace) throws IOException {
        return this.getNamespaceMembers(namespace.getId());
    }

    public List<GitlabProjectMember> getNamespaceMembers(Integer namespaceId) throws IOException {
        String tailUrl = "/groups/" + namespaceId + "/members";
        return Arrays.asList((Object[])this.retrieve().to(tailUrl, GitlabProjectMember[].class));
    }

    public GitlabSession getCurrentSession() throws IOException {
        String tailUrl = "/user";
        return this.retrieve().to(tailUrl, GitlabSession.class);
    }
}

