/*
 * Copyright (c) 2023, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.graalvm.python.embedding.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Predicate;

/**
 * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
 */
@Deprecated
public final class VirtualFileSystem implements AutoCloseable {

    final org.graalvm.python.embedding.VirtualFileSystem delegate;

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
     */
    @Deprecated
    public static enum HostIO {
        NONE,
        READ,
        READ_WRITE,
    }

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
     */
    @Deprecated
    public static final class Builder {

        org.graalvm.python.embedding.VirtualFileSystem.Builder delegate;

        private Builder(org.graalvm.python.embedding.VirtualFileSystem.Builder delegate) {
            this.delegate = delegate;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder caseInsensitive(boolean value) {
            delegate = delegate.caseInsensitive(value);
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder allowHostIO(HostIO b) {
            delegate = delegate.allowHostIO(switch (b) {
                case NONE -> org.graalvm.python.embedding.VirtualFileSystem.HostIO.NONE;
                case READ -> org.graalvm.python.embedding.VirtualFileSystem.HostIO.READ;
                case READ_WRITE -> org.graalvm.python.embedding.VirtualFileSystem.HostIO.READ_WRITE;
            });
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder windowsMountPoint(String windowsMountPoint) {
            delegate = delegate.windowsMountPoint(windowsMountPoint);
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder unixMountPoint(String unixMountPoint) {
            delegate = delegate.unixMountPoint(unixMountPoint);
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder resourceLoadingClass(Class<?> c) {
            delegate = delegate.resourceLoadingClass(c);
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public Builder extractFilter(Predicate<Path> filter) {
            delegate.extractFilter(filter);
            return this;
        }

        /**
         * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem.Builder} instead
         */
        @Deprecated
        public VirtualFileSystem build() {
            return new VirtualFileSystem(delegate.build());
        }
    }

    private VirtualFileSystem(org.graalvm.python.embedding.VirtualFileSystem delegate) {
        this.delegate = delegate;
    }

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
     */
    @Deprecated
    public static Builder newBuilder() {
        return new Builder(org.graalvm.python.embedding.VirtualFileSystem.newBuilder());
    }

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
     */
    @Deprecated
    public static VirtualFileSystem create() {
        return newBuilder().build();
    }

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
     */
    @Deprecated
    public String getMountPoint() {
        return delegate.getMountPoint();
    }

    /**
     * @deprecated use {@link org.graalvm.python.embedding.VirtualFileSystem} instead
     */
    @Override
    @Deprecated
    public void close() throws IOException {
        delegate.close();
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

}
