/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextContextBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyContextVar_Set
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_Set() {
        }

        @Specialization
        Object doGeneric(Object var, Object val) {
            if (!(var instanceof PContextVar)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            PContextVar pvar = (PContextVar)var;
            Object oldValue = pvar.getValue(threadState);
            pvar.setValue(threadState, val);
            return this.factory().createContextVarsToken(pvar, oldValue);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Pointer}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleContextVar_Get
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleContextVar_Get() {
        }

        @Specialization
        Object doGeneric(Object var, Object def, Object marker, @Cached CExtNodes.PRaiseNativeNode raiseNative) {
            if (!(var instanceof PContextVar)) {
                return raiseNative.raise(null, marker, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED, new Object[0]);
            }
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            Object result = ((PContextVar)var).getValue(threadState);
            if (result == null) {
                result = def == PNone.NO_VALUE ? (((PContextVar)var).getDefault() == PContextVar.NO_DEFAULT ? PNone.NO_VALUE : ((PContextVar)var).getDefault()) : def;
            }
            return result;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyContextVar_New
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_New() {
        }

        @Specialization
        static Object doGeneric(TruffleString name, Object def, @Cached CallNode callContextvar) {
            return callContextvar.execute((Object)PythonBuiltinClassType.ContextVar, name, def);
        }

        @Specialization
        static Object doGeneric(PNone name, Object def) {
            assert (name == PNone.NO_VALUE);
            return PNone.NO_VALUE;
        }
    }
}

