/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;

@GenerateLibrary(assertions=Assertions.class)
public abstract class PythonBufferAcquireLibrary
extends Library {
    static final LibraryFactory<PythonBufferAcquireLibrary> FACTORY = LibraryFactory.resolve(PythonBufferAcquireLibrary.class);

    @GenerateLibrary.Abstract
    public boolean hasBuffer(Object receiver) {
        return false;
    }

    public final Object acquireReadonly(Object receiver) {
        return this.acquire(receiver, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object acquireReadonly(Object receiver, VirtualFrame frame, PNodeWithRaiseAndIndirectCall indirectCallNode) {
        PythonLanguage language = indirectCallNode.getLanguage();
        PythonContext context = indirectCallNode.getContext();
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallNode);
        try {
            Object object = this.acquire(receiver, 0);
            return object;
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, language, context, savedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object acquireReadonly(Object receiver, VirtualFrame frame, PythonContext context, PythonLanguage language, IndirectCallNode node) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, language, context, node);
        try {
            Object object = this.acquire(receiver, 0);
            return object;
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, language, context, savedState);
        }
    }

    public final Object acquireWritable(Object receiver) {
        return this.acquire(receiver, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object acquireWritable(Object receiver, VirtualFrame frame, PNodeWithRaiseAndIndirectCall indirectCallNode) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallNode);
        try {
            Object object = this.acquire(receiver, 1);
            return object;
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, indirectCallNode, savedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object acquireWritable(Object receiver, VirtualFrame frame, PythonContext context, PythonLanguage language, IndirectCallNode node) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, language, context, node);
        try {
            Object object = this.acquire(receiver, 1);
            return object;
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, language, context, savedState);
        }
    }

    public final Object acquireWritableWithTypeError(Object receiver, String callerName, VirtualFrame frame, PNodeWithRaiseAndIndirectCall indirectCallNode) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallNode);
        try {
            Object object = this.acquireWritable(receiver);
            return object;
        }
        catch (PException e) {
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_READ_WRITE_BYTES_LIKE_NOT_P, callerName, receiver);
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, indirectCallNode, savedState);
        }
    }

    @GenerateLibrary.Abstract
    public Object acquire(Object receiver, int flags) {
        throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object acquire(Object receiver, int flags, VirtualFrame frame, PNodeWithRaiseAndIndirectCall indirectCallNode) {
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, indirectCallNode);
        try {
            Object object = this.acquire(receiver, flags);
            return object;
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, indirectCallNode, savedState);
        }
    }

    public static LibraryFactory<PythonBufferAcquireLibrary> getFactory() {
        return FACTORY;
    }

    public static PythonBufferAcquireLibrary getUncached() {
        return (PythonBufferAcquireLibrary)FACTORY.getUncached();
    }

    static class Assertions
    extends PythonBufferAcquireLibrary {
        @Node.Child
        PythonBufferAcquireLibrary delegate;

        public Assertions(PythonBufferAcquireLibrary delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(Object receiver) {
            return this.delegate.accepts(receiver);
        }

        @Override
        public boolean hasBuffer(Object receiver) {
            return this.delegate.hasBuffer(receiver);
        }

        @Override
        public Object acquire(Object receiver, int flags) {
            Object buffer = this.delegate.acquire(receiver, flags);
            assert (this.delegate.hasBuffer(receiver));
            assert (PythonBufferAccessLibrary.getUncached().isBuffer(buffer));
            return buffer;
        }
    }
}

