/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.util.PythonUtils;

public abstract class GraalHPyData {
    private static final int INDEX_DATA_PTR = 0;
    private static final int INDEX_CALL_FUN = 1;
    private static final int HPY_FIELD_OFFSET = 1;
    private static final Long DEFAULT_DATA_PTR_VALUE = 0L;
    private static final Object DEFAULT_CALL_FUNCTION_VALUE = null;

    public static void setHPyNativeSpace(PythonObject object, Object dataPtr) {
        Object[] hpyData = object.getHPyData();
        if (hpyData == null) {
            hpyData = new Object[]{dataPtr, DEFAULT_CALL_FUNCTION_VALUE};
            object.setHPyData(hpyData);
        } else {
            hpyData[0] = dataPtr;
        }
    }

    public static Object getHPyNativeSpace(PythonObject object) {
        Object[] hpyData = object.getHPyData();
        return hpyData != null ? hpyData[0] : DEFAULT_DATA_PTR_VALUE;
    }

    public static void setHPyCallFunction(PythonObject object, Object callFunctionPtr) {
        Object[] hpyData = object.getHPyData();
        if (hpyData == null) {
            hpyData = new Object[]{DEFAULT_DATA_PTR_VALUE, callFunctionPtr};
            object.setHPyData(hpyData);
        } else {
            hpyData[1] = callFunctionPtr;
        }
    }

    public static Object getHPyCallFunction(PythonObject object) {
        Object[] hpyData = object.getHPyData();
        return hpyData != null ? hpyData[1] : null;
    }

    public static Object getHPyField(PythonObject object, int location) {
        assert (location > 0);
        Object[] hpyData = object.getHPyData();
        return hpyData != null ? hpyData[location + 1] : null;
    }

    public static int setHPyField(PythonObject object, Object referent, int location) {
        int newLocation;
        Object[] hpyFields = object.getHPyData();
        if (location != 0) {
            assert (hpyFields != null);
            hpyFields[location + 1] = referent;
            return location;
        }
        if (hpyFields == null) {
            newLocation = 1;
            hpyFields = new Object[]{DEFAULT_DATA_PTR_VALUE, null, referent};
        } else {
            int newFieldIdx = hpyFields.length;
            hpyFields = PythonUtils.arrayCopyOf(hpyFields, newFieldIdx + 1);
            hpyFields[newFieldIdx] = referent;
            newLocation = newFieldIdx - 1;
        }
        object.setHPyData(hpyFields);
        return newLocation;
    }
}

