/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Iterator;

public final class DynamicObjectStorage
extends HashingStorage {
    public static final int SIZE_THRESHOLD = 100;
    public static final int EXPLODE_LOOP_SIZE_LIMIT = 16;
    final DynamicObject store;
    private final MroSequenceStorage mro;

    public DynamicObjectStorage(PythonLanguage lang) {
        this(new Store(lang.getEmptyShape()), null);
    }

    public DynamicObjectStorage(DynamicObject store) {
        this(store, null);
    }

    public DynamicObjectStorage(DynamicObject store, MroSequenceStorage mro) {
        this.store = store;
        this.mro = mro;
    }

    public Shape getStoreShape() {
        return this.store.getShape();
    }

    public DynamicObject getStore() {
        return this.store;
    }

    protected static Object[] keyArray(DynamicObjectStorage self) {
        return DynamicObjectStorage.keyArray(self.store.getShape());
    }

    protected static Object[] keyArray(Shape shape) {
        return shape.getKeyList().toArray();
    }

    private static void invalidateAttributeInMROFinalAssumptions(MroSequenceStorage mro, TruffleString name, Node inliningTarget, InlinedBranchProfile profile) {
        if (mro != null) {
            profile.enter(inliningTarget);
            mro.invalidateAttributeInMROFinalAssumptions(name);
        }
    }

    void setStringKey(TruffleString key, Object value, DynamicObjectLibrary dylib, Node inliningTarget, InlinedBranchProfile invalidateMroProfile) {
        dylib.put(this.store, (Object)key, TruffleStringMigrationHelpers.assertNoJavaString(value));
        this.invalidateAttributeInMROFinalAssumption(key, inliningTarget, invalidateMroProfile);
    }

    void invalidateAttributeInMROFinalAssumption(TruffleString key, Node inliningTarget, InlinedBranchProfile invalidateMroProfile) {
        DynamicObjectStorage.invalidateAttributeInMROFinalAssumptions(this.mro, key, inliningTarget, invalidateMroProfile);
    }

    boolean shouldTransitionOnPut() {
        boolean notDunderDict = this.store instanceof Store;
        int propertyCount = this.store.getShape().getPropertyCount();
        return notDunderDict && propertyCount > 100;
    }

    static final class Store
    extends DynamicObject {
        public Store(Shape shape) {
            super(shape);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DynamicObjectStorageSetStringKey
    extends HashingStorageNodes.SpecializedSetStringKey {
        @Specialization
        static void doIt(Node inliningTarget, HashingStorage self, TruffleString key, Object value, @CachedLibrary(limit="3") DynamicObjectLibrary dylib, @Cached InlinedBranchProfile invalidateMro) {
            ((DynamicObjectStorage)self).setStringKey(key, value, dylib, inliningTarget, invalidateMro);
        }
    }

    @ImportStatic(value={PGuards.class, DynamicObjectStorage.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class Copy
    extends Node {
        Copy() {
        }

        abstract DynamicObjectStorage execute(Node var1, DynamicObjectStorage var2);

        @NeverDefault
        static DynamicObjectLibrary[] createAccess(int length) {
            DynamicObjectLibrary[] result = new DynamicObjectLibrary[length];
            for (int i = 0; i < length; ++i) {
                result[i] = (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(1);
            }
            return result;
        }

        @ExplodeLoop
        @Specialization(limit="1", guards={"cachedLength < EXPLODE_LOOP_SIZE_LIMIT", "keys.length == cachedLength"})
        public static DynamicObjectStorage copy(DynamicObjectStorage receiver, @Bind(value="receiver.store") DynamicObject store, @CachedLibrary(value="store") DynamicObjectLibrary dylib, @Bind(value="dylib.getKeyArray(store)") Object[] keys, @Cached(value="keys.length") int cachedLength, @Cached(value="createAccess(cachedLength)") DynamicObjectLibrary[] readLib, @Cached(value="createAccess(cachedLength)") DynamicObjectLibrary[] writeLib) {
            Store copy = new Store(PythonLanguage.get((Node)dylib).getEmptyShape());
            for (int i = 0; i < cachedLength; ++i) {
                writeLib[i].put((DynamicObject)copy, keys[i], readLib[i].getOrDefault(receiver.store, keys[i], (Object)PNone.NO_VALUE));
            }
            return new DynamicObjectStorage(copy);
        }

        @Specialization(replaces={"copy"})
        public static DynamicObjectStorage copyGeneric(DynamicObjectStorage receiver, @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            Object[] keys;
            Store copy = new Store(PythonLanguage.get((Node)dylib).getEmptyShape());
            for (Object key : keys = dylib.getKeyArray(receiver.store)) {
                dylib.put((DynamicObject)copy, key, dylib.getOrDefault(receiver.store, key, (Object)PNone.NO_VALUE));
            }
            return new DynamicObjectStorage(copy);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ClearNode
    extends Node {
        ClearNode() {
        }

        public abstract HashingStorage execute(Node var1, HashingStorage var2);

        @Specialization(guards={"!isPythonObject(receiver.getStore())"})
        static HashingStorage clearPlain(DynamicObjectStorage receiver, @Cached.Shared(value="dylib") @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            dylib.resetShape(receiver.getStore(), PythonLanguage.get((Node)dylib).getEmptyShape());
            return receiver;
        }

        @Specialization(guards={"isPythonObject(receiver.getStore())"})
        static HashingStorage clearObjectBacked(DynamicObjectStorage receiver, @Cached.Shared(value="dylib") @CachedLibrary(limit="3") DynamicObjectLibrary dylib) {
            DynamicObjectStorage newStorage = new DynamicObjectStorage(new Store(PythonLanguage.get((Node)dylib).getEmptyShape()));
            PythonObject owner = (PythonObject)receiver.getStore();
            PDict dict = (PDict)dylib.getOrDefault((DynamicObject)owner, (Object)PythonObject.DICT, null);
            if (dict != null && dict.getDictStorage() == receiver) {
                dict.setDictStorage(newStorage);
            }
            return newStorage;
        }
    }

    @ImportStatic(value={PGuards.class, DynamicObjectStorage.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetItemNode
    extends Node {
        GetItemNode() {
        }

        public abstract Object execute(Frame var1, Node var2, DynamicObjectStorage var3, Object var4, long var5);

        @Specialization
        static Object string(Node inliningTarget, DynamicObjectStorage self, TruffleString key, long keyHash, @Cached.Shared(value="readKey") @Cached(inline=false) ReadAttributeFromDynamicObjectNode readKey, @Cached.Exclusive @Cached InlinedConditionProfile noValueProfile) {
            Object result = readKey.execute((Object)self.store, key);
            return noValueProfile.profile(inliningTarget, result == PNone.NO_VALUE) ? null : result;
        }

        @Specialization(guards={"isBuiltinString(inliningTarget, key, profile)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static Object pstring(Node inliningTarget, DynamicObjectStorage self, PString key, long keyHash, @Cached CastToTruffleStringNode castStr, @Cached.Shared(value="readKey") @Cached(inline=false) ReadAttributeFromDynamicObjectNode readKey, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile, @Cached.Exclusive @Cached InlinedConditionProfile noValueProfile) {
            return GetItemNode.string(inliningTarget, self, castStr.execute(inliningTarget, key), -1L, readKey, noValueProfile);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static Object nonStringKey(Frame frame, DynamicObjectStorage self, Object key, long keyHash, @Cached(inline=false) GetItemNoStringKeyNode getItemNoStringKeyNode) {
            return getItemNoStringKeyNode.execute(frame, self, key, keyHash);
        }

        @GenerateInline(value=false)
        @GenerateUncached
        @ImportStatic(value={PGuards.class, DynamicObjectStorage.class})
        static abstract class GetItemNoStringKeyNode
        extends Node {
            GetItemNoStringKeyNode() {
            }

            public abstract Object execute(Frame var1, DynamicObjectStorage var2, Object var3, long var4);

            @Specialization(guards={"cachedShape == self.store.getShape()", "keyList.length < EXPLODE_LOOP_SIZE_LIMIT"}, limit="1")
            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
            static Object notString(Frame frame, DynamicObjectStorage self, Object key, long hashIn, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="readKey") @Cached ReadAttributeFromDynamicObjectNode readKey, @Cached.Exclusive @Cached(value="self.store.getShape()") Shape cachedShape, @Cached.Exclusive @Cached(value="keyArray(cachedShape)", dimensions=1) Object[] keyList, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="hashNode") @Cached PyObjectHashNode hashNode, @Cached.Shared(value="noValueProfile") @Cached InlinedConditionProfile noValueProfile) {
                long hash = hashIn == -1L ? hashNode.execute(frame, inliningTarget, key) : hashIn;
                for (Object currentKey : keyList) {
                    long keyHash;
                    if (!(currentKey instanceof TruffleString) || (keyHash = hashNode.execute(frame, inliningTarget, currentKey)) != hash || !eqNode.compare(frame, inliningTarget, key, currentKey)) continue;
                    return GetItemNode.string(inliningTarget, self, (TruffleString)currentKey, -1L, readKey, noValueProfile);
                }
                return null;
            }

            @Specialization(replaces={"notString"})
            static Object notStringLoop(Frame frame, DynamicObjectStorage self, Object key, long hashIn, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="readKey") @Cached ReadAttributeFromDynamicObjectNode readKey, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="hashNode") @Cached PyObjectHashNode hashNode, @Cached.Shared(value="noValueProfile") @Cached InlinedConditionProfile noValueProfile) {
                long hash = hashIn == -1L ? hashNode.execute(frame, inliningTarget, key) : hashIn;
                Iterator<Object> keys = GetItemNoStringKeyNode.getKeysIterator(self.store.getShape());
                while (GetItemNoStringKeyNode.hasNext(keys)) {
                    long keyHash;
                    Object currentKey = GetItemNoStringKeyNode.getNext(keys);
                    if (!(currentKey instanceof TruffleString) || (keyHash = hashNode.execute(frame, inliningTarget, currentKey)) != hash || !eqNode.compare(frame, inliningTarget, key, currentKey)) continue;
                    return GetItemNode.string(inliningTarget, self, (TruffleString)currentKey, -1L, readKey, noValueProfile);
                }
                return null;
            }

            @CompilerDirectives.TruffleBoundary
            private static Iterator<Object> getKeysIterator(Shape shape) {
                return shape.getKeys().iterator();
            }

            @CompilerDirectives.TruffleBoundary
            private static Object getNext(Iterator<Object> keys) {
                return keys.next();
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean hasNext(Iterator<Object> keys) {
                return keys.hasNext();
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @GenerateCached
    @ImportStatic(value={DynamicObjectStorage.class})
    public static abstract class LengthNode
    extends Node {
        public abstract int execute(DynamicObjectStorage var1);

        @Specialization(guards={"cachedShape == self.store.getShape()", "keys.length < EXPLODE_LOOP_SIZE_LIMIT"}, limit="2")
        @ExplodeLoop
        static int cachedLen(DynamicObjectStorage self, @Cached(value="self.store.getShape()") Shape cachedShape, @Cached(value="keyArray(self)", dimensions=1) Object[] keys, @Cached.Shared @Cached ReadAttributeFromDynamicObjectNode readNode) {
            int len = 0;
            for (Object key : keys) {
                len = LengthNode.incrementLen(self, readNode, len, key);
            }
            return len;
        }

        @Specialization(replaces={"cachedLen"}, guards={"cachedShape == self.store.getShape()"}, limit="3")
        static int cachedKeys(DynamicObjectStorage self, @Cached(value="self.store.getShape()") Shape cachedShape, @Cached(value="keyArray(self)", dimensions=1) Object[] keys, @Cached.Shared @Cached ReadAttributeFromDynamicObjectNode readNode) {
            int len = 0;
            for (Object key : keys) {
                len = LengthNode.incrementLen(self, readNode, len, key);
            }
            return len;
        }

        @Specialization(replaces={"cachedKeys"})
        static int length(DynamicObjectStorage self, @Cached.Shared @Cached ReadAttributeFromDynamicObjectNode readNode) {
            return LengthNode.cachedKeys(self, self.store.getShape(), DynamicObjectStorage.keyArray(self), readNode);
        }

        private static boolean hasStringKey(DynamicObjectStorage self, TruffleString key, ReadAttributeFromDynamicObjectNode readNode) {
            return readNode.execute((Object)self.store, key) != PNone.NO_VALUE;
        }

        private static int incrementLen(DynamicObjectStorage self, ReadAttributeFromDynamicObjectNode readNode, int len, Object key) {
            if ((key = TruffleStringMigrationHelpers.assertNoJavaString(key)) instanceof TruffleString && LengthNode.hasStringKey(self, (TruffleString)key, readNode)) {
                return len + 1;
            }
            return len;
        }
    }
}

