/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.deque.DequeIterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDequeIter, PythonBuiltinClassType.PDequeRevIter})
public final class DequeIterBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DequeIterBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PTuple doGeneric(PDequeIter self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            return this.factory().createTuple(new Object[]{clazz, this.factory().createTuple(new Object[]{self.deque, self.deque.getSize() - self.lengthHint()})});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterLengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int doGeneric(PDequeIter self) {
            return self.lengthHint();
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterNextNode
    extends PythonUnaryBuiltinNode {
        public abstract Object execute(PDequeIter var1);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDequeIter self) {
            try {
                if (self.startState == self.deque.getState()) {
                    if (!self.hasNext()) {
                        assert (self.lengthHint() == 0);
                        throw this.raiseStopIteration();
                    }
                    return self.next();
                }
            }
            catch (NoSuchElementException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            self.reset();
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterIterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDequeIter self) {
            return self;
        }
    }
}

