/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PPermutations;
import com.oracle.graal.python.builtins.objects.itertools.PermutationsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PPermutations})
public final class PermutationsBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PermutationsBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2, Object var3);

        @Specialization
        Object setState(VirtualFrame frame, PPermutations self, Object state, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached InlinedLoopConditionProfile indicesProfile, @Cached InlinedLoopConditionProfile cyclesProfile) {
            int index;
            if (sizeNode.execute((Frame)frame, inliningTarget, state) != 3) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
            }
            Object indices = getItemNode.execute(frame, state, (Object)0);
            Object cycles = getItemNode.execute(frame, state, (Object)1);
            int poolLen = self.getPool().length;
            if (sizeNode.execute((Frame)frame, inliningTarget, indices) != poolLen || sizeNode.execute((Frame)frame, inliningTarget, cycles) != self.getR()) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
            }
            self.setStarted((Boolean)getItemNode.execute(frame, state, (Object)2));
            indicesProfile.profileCounted(inliningTarget, (long)poolLen);
            int i = 0;
            while (indicesProfile.inject(inliningTarget, i < poolLen)) {
                index = (Integer)getItemNode.execute(frame, indices, (Object)i);
                if (index < 0) {
                    index = 0;
                } else if (index > poolLen - 1) {
                    index = poolLen - 1;
                }
                self.getIndices()[i] = index;
                ++i;
            }
            cyclesProfile.profileCounted(inliningTarget, (long)self.getR());
            i = 0;
            while (cyclesProfile.inject(inliningTarget, i < self.getR())) {
                index = (Integer)getItemNode.execute(frame, cycles, (Object)i);
                if (index < 1) {
                    index = 1;
                } else if (index > poolLen - i) {
                    index = poolLen - 1;
                }
                self.getCycles()[i] = index;
                ++i;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"!self.isRaisedStopIteration()"})
        Object reduce(PPermutations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            PList poolList = this.factory().createList(self.getPool());
            PTuple tuple = this.factory().createTuple(new Object[]{poolList, self.getR()});
            PTuple indicesTuple = this.factory().createTuple(self.getIndices());
            PTuple cyclesTuple = this.factory().createTuple(self.getCycles());
            PTuple tuple2 = this.factory().createTuple(new Object[]{indicesTuple, cyclesTuple, self.isStarted()});
            Object[] result = new Object[]{type, tuple, tuple2};
            return this.factory().createTuple(result);
        }

        @Specialization(guards={"self.isRaisedStopIteration()"})
        Object reduceStopped(PPermutations self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = this.factory().createTuple(new Object[]{this.factory().createEmptyTuple(), self.getR()});
            Object[] result = new Object[]{type, tuple};
            return this.factory().createTuple(result);
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isStopped()"})
        Object next(PPermutations self) {
            self.setRaisedStopIteration(true);
            throw this.raiseStopIteration();
        }

        @Specialization(guards={"!self.isStopped()"})
        Object next(PPermutations self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isStartedProfile, @Cached InlinedBranchProfile jProfile, @Cached InlinedLoopConditionProfile resultLoopProfile, @Cached InlinedLoopConditionProfile mainLoopProfile, @Cached InlinedLoopConditionProfile shiftIndicesProfile) {
            int r = self.getR();
            int[] indices = self.getIndices();
            Object[] result = new Object[r];
            Object[] pool = self.getPool();
            resultLoopProfile.profileCounted(inliningTarget, (long)r);
            int i = 0;
            while (resultLoopProfile.inject(inliningTarget, i < r)) {
                result[i] = pool[indices[i]];
                ++i;
            }
            int[] cycles = self.getCycles();
            int i2 = r - 1;
            while (mainLoopProfile.profile(inliningTarget, i2 >= 0)) {
                int j = cycles[i2] - 1;
                if (j > 0) {
                    jProfile.enter(inliningTarget);
                    cycles[i2] = j;
                    int tmp = indices[i2];
                    indices[i2] = indices[indices.length - j];
                    indices[indices.length - j] = tmp;
                    return this.factory().createTuple(result);
                }
                cycles[i2] = indices.length - i2;
                int n1 = indices.length - 1;
                assert (n1 >= 0);
                int num = indices[i2];
                shiftIndicesProfile.profileCounted(inliningTarget, (long)(n1 - i2));
                int k = i2;
                while (shiftIndicesProfile.profile(inliningTarget, k < n1)) {
                    indices[k] = indices[k + 1];
                    ++k;
                }
                indices[n1] = num;
                --i2;
            }
            self.setStopped(true);
            if (isStartedProfile.profile(inliningTarget, self.isStarted())) {
                throw this.raiseStopIteration();
            }
            self.setStarted(true);
            return this.factory().createTuple(result);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PPermutations self) {
            return self;
        }
    }
}

