/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.bytecode.MakeFunctionNodeGen;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class MakeFunctionNode
extends PNodeWithContext {
    private final RootCallTarget callTarget;
    private final CodeUnit code;
    private final Signature signature;
    private final TruffleString doc;
    @CompilerDirectives.CompilationFinal
    private PCode cachedCode;
    private final Assumption sharedCodeStableAssumption = Truffle.getRuntime().createAssumption("shared code stable assumption");
    private final Assumption sharedDefaultsStableAssumption = Truffle.getRuntime().createAssumption("shared defaults stable assumption");

    public abstract int execute(VirtualFrame var1, Object var2, int var3, int var4);

    public MakeFunctionNode(RootCallTarget callTarget, CodeUnit code, Signature signature, TruffleString doc) {
        this.callTarget = callTarget;
        this.code = code;
        this.signature = signature;
        this.doc = doc;
    }

    @Specialization
    int makeFunction(VirtualFrame frame, Object globals, int initialStackTop, int flags, @Cached PythonObjectFactory factory, @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
        Assumption defaultsStableAssumption;
        Assumption codeStableAssumption;
        int stackTop = initialStackTop;
        PCode codeObj = this.cachedCode;
        if (codeObj == null) {
            if (PythonLanguage.get(this).isSingleContext()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedCode = codeObj = factory.createCode(this.callTarget, this.signature, this.code);
            } else {
                codeObj = factory.createCode(this.callTarget, this.signature, this.code);
            }
        }
        PCell[] closure = null;
        Object annotations = null;
        PKeyword[] kwdefaults = null;
        Object[] defaults = null;
        if ((flags & 8) != 0) {
            closure = (PCell[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 4) != 0) {
            annotations = frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 2) != 0) {
            kwdefaults = (PKeyword[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if ((flags & 1) != 0) {
            defaults = (Object[])frame.getObject(stackTop);
            frame.setObject(stackTop--, null);
        }
        if (CompilerDirectives.inCompiledCode()) {
            codeStableAssumption = this.sharedCodeStableAssumption;
            defaultsStableAssumption = this.sharedDefaultsStableAssumption;
        } else {
            codeStableAssumption = Truffle.getRuntime().createAssumption();
            defaultsStableAssumption = Truffle.getRuntime().createAssumption();
        }
        PFunction function = factory.createFunction(this.code.name, this.code.qualname, codeObj, (PythonObject)globals, defaults, kwdefaults, closure, codeStableAssumption, defaultsStableAssumption);
        if (annotations != null) {
            dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___ANNOTATIONS__, annotations);
        }
        if (this.doc != null) {
            dylib.put((DynamicObject)function, (Object)SpecialAttributeNames.T___DOC__, (Object)this.doc);
        }
        frame.setObject(++stackTop, (Object)function);
        return stackTop;
    }

    public static MakeFunctionNode create(PythonLanguage language, CodeUnit code, Source source) {
        PBytecodeRootNode bytecodeRootNode = PBytecodeRootNode.create(language, code, source);
        RootCallTarget callTarget = code.isGeneratorOrCoroutine() ? new PBytecodeGeneratorFunctionRootNode(language, bytecodeRootNode.getFrameDescriptor(), bytecodeRootNode, code.name).getCallTarget() : bytecodeRootNode.getCallTarget();
        TruffleString doc = null;
        if (code.constants.length > 0 && code.constants[0] instanceof TruffleString) {
            doc = (TruffleString)code.constants[0];
        }
        return MakeFunctionNodeGen.create(callTarget, code, bytecodeRootNode.getSignature(), doc);
    }

    public RootCallTarget getCallTarget() {
        return this.callTarget;
    }
}

