/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.AbcModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.DeleteAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_abc")
public final class AbcModuleBuiltins
extends PythonBuiltins {
    private static TruffleString ABC_TPFLAGS = PythonUtils.toTruffleStringUncached("__abc_tpflags__");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AbcModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="_abc_register", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RegisterCollectionFlagsNode
    extends PythonBinaryBuiltinNode {
        RegisterCollectionFlagsNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object register(Object self, Object subclass) {
            long tpFlags;
            long collectionFlag;
            if (TypeNodes.IsTypeNode.executeUncached(self) && (collectionFlag = (tpFlags = TypeNodes.GetTypeFlagsNode.executeUncached(self)) & 0x60L) > 0L) {
                RegisterCollectionFlagsNode.setCollectionFlagRecursive(subclass, collectionFlag);
            }
            return PNone.NONE;
        }

        private static void setCollectionFlagRecursive(Object child, long flag) {
            PythonAbstractClass[] grandchildren;
            assert (flag == 32L || flag == 64L) : flag;
            long origTpFlags = TypeNodes.GetTypeFlagsNode.executeUncached(child);
            long tpFlags = origTpFlags & 0xFFFFFFFFFFFFFF9FL;
            if ((tpFlags |= flag) == origTpFlags || (origTpFlags & 0x100L) != 0L) {
                return;
            }
            TypeNodes.SetTypeFlagsNode.executeUncached(child, tpFlags);
            for (PythonAbstractClass c : grandchildren = TypeNodes.GetSubclassesAsArrayNode.executeUncached(child)) {
                if (!TypeNodes.IsTypeNode.executeUncached(c)) continue;
                RegisterCollectionFlagsNode.setCollectionFlagRecursive(c, flag);
            }
        }
    }

    @Builtin(name="_abc_init", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AbcInitCollectionFlagsNode
    extends PythonUnaryBuiltinNode {
        AbcInitCollectionFlagsNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object init(Object object, @Bind(value="this") Node inliningTarget, @Cached DeleteAttributeNode deleteAttributeNode) {
            if (TypeNodes.IsTypeNode.executeUncached(object)) {
                PythonAbstractObject type;
                long val;
                Object flags = PyObjectLookupAttr.executeUncached(object, ABC_TPFLAGS);
                try {
                    val = CastToJavaLongLossyNode.executeUncached(flags);
                }
                catch (CannotCastException ex) {
                    return PNone.NONE;
                }
                if ((val & 0x60L) == 96L) {
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ABC_FLAGS_CANNOT_BE_SEQUENCE_AND_MAPPING);
                }
                long tpFlags = TypeNodes.GetTypeFlagsNode.getUncached().execute(object);
                tpFlags |= val & 0x60L;
                if (object instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType pbct = (PythonBuiltinClassType)((Object)object);
                    type = PythonContext.get(inliningTarget).lookupType(pbct);
                } else {
                    assert (object instanceof PythonAbstractObject);
                    type = (PythonAbstractObject)object;
                }
                HiddenAttr.WriteNode.executeUncached(type, HiddenAttr.FLAGS, tpFlags);
                deleteAttributeNode.execute(null, inliningTarget, object, ABC_TPFLAGS);
            }
            return PNone.NONE;
        }
    }
}

