/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyBytesCheckExactNode;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyFloatCheckExactNode;
import com.oracle.graal.python.lib.PyFrozenSetCheckExactNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.IntFunction;

abstract class Obj2SstBase {
    final AstState state;

    protected Obj2SstBase(AstState state) {
        this.state = state;
    }

    <T> T lookupAndConvert(Object obj, TruffleString attrName, TruffleString nodeName, Conversion<T> conversion, boolean required) {
        Object tmp = Obj2SstBase.lookupAttr(obj, attrName);
        if (tmp instanceof PNone) {
            if (!required) {
                return null;
            }
            if (tmp == PNone.NO_VALUE) {
                throw Obj2SstBase.raiseTypeError(ErrorMessages.REQUIRED_FIELD_S_MISSING_FROM_S, attrName, nodeName);
            }
            if (nodeName != AstState.T_C_CONSTANT || attrName != AstState.T_F_VALUE) {
                throw Obj2SstBase.raiseValueError(ErrorMessages.FIELD_S_IS_REQUIRED_FOR_S, attrName, nodeName);
            }
        }
        return conversion.convert(tmp);
    }

    int lookupAndConvertInt(Object obj, TruffleString attrName, TruffleString nodeName, boolean required) {
        Object tmp = Obj2SstBase.lookupAttr(obj, attrName);
        if (tmp instanceof PNone) {
            if (!required) {
                return 0;
            }
            if (tmp == PNone.NO_VALUE) {
                throw Obj2SstBase.raiseTypeError(ErrorMessages.REQUIRED_FIELD_S_MISSING_FROM_S, attrName, nodeName);
            }
        }
        return this.obj2int(tmp);
    }

    boolean lookupAndConvertBoolean(Object obj, TruffleString attrName, TruffleString nodeName, boolean required) {
        Object tmp = Obj2SstBase.lookupAttr(obj, attrName);
        if (tmp instanceof PNone) {
            if (!required) {
                return false;
            }
            if (tmp == PNone.NO_VALUE) {
                throw Obj2SstBase.raiseTypeError(ErrorMessages.REQUIRED_FIELD_S_MISSING_FROM_S, attrName, nodeName);
            }
        }
        return this.obj2boolean(tmp);
    }

    <T> T[] lookupAndConvertSequence(Object obj, TruffleString attrName, TruffleString nodeName, Conversion<T> conversion, IntFunction<T[]> arrayFactory) {
        Object tmp = Obj2SstBase.lookupAttr(obj, attrName);
        if (tmp instanceof PNone) {
            throw Obj2SstBase.raiseTypeError(ErrorMessages.REQUIRED_FIELD_S_MISSING_FROM_S, attrName, nodeName);
        }
        if (!(tmp instanceof PList)) {
            throw Obj2SstBase.raiseTypeError(ErrorMessages.S_FIELD_S_MUST_BE_A_LIST_NOT_P, nodeName, attrName, tmp);
        }
        SequenceStorage seq = ((PList)tmp).getSequenceStorage();
        T[] result = arrayFactory.apply(seq.length());
        for (int i = 0; i < result.length; ++i) {
            tmp = SequenceStorageNodes.GetItemScalarNode.executeUncached(seq, i);
            result[i] = conversion.convert(tmp);
            if (result.length == seq.length()) continue;
            throw Obj2SstBase.raiseTypeError(ErrorMessages.S_FIELD_S_CHANGED_SIZE_DURING_ITERATION, nodeName, attrName);
        }
        return result;
    }

    static boolean isInstanceOf(Object o, PythonAbstractClass cls) {
        Object check = Obj2SstBase.lookupAttr(cls, SpecialMethodNames.T___INSTANCECHECK__);
        Object result = CallNode.executeUncached(check, o);
        return CastToJavaBooleanNode.executeUncached(result);
    }

    int obj2int(Object o) {
        if (!PyLongCheckNode.executeUncached(o)) {
            throw Obj2SstBase.raiseValueError(ErrorMessages.INVALID_INTEGER_VALUE, Obj2SstBase.repr(o));
        }
        return PyLongAsIntNode.executeUncached(o);
    }

    boolean obj2boolean(Object o) {
        return this.obj2int(o) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object obj2string(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        if (PyBytesCheckExactNode.executeUncached(obj)) {
            PythonBufferAcquireLibrary acquireLib = PythonBufferAcquireLibrary.getUncached();
            PythonBufferAccessLibrary accessLib = PythonBufferAccessLibrary.getUncached();
            Object buf = acquireLib.acquireReadonly(obj);
            try {
                byte[] byArray = accessLib.getCopiedByteArray(buf);
                return byArray;
            }
            finally {
                accessLib.release(buf);
            }
        }
        if (PyUnicodeCheckExactNode.executeUncached(obj)) {
            return CastToJavaStringNode.getUncached().execute(obj);
        }
        throw Obj2SstBase.raiseTypeError(ErrorMessages.AST_STRING_MUST_BE_OF_TYPE_STR, new Object[0]);
    }

    String obj2identifier(Object obj) {
        if (obj == PNone.NONE) {
            return null;
        }
        try {
            return CastToJavaStringNode.getUncached().execute(obj);
        }
        catch (CannotCastException e) {
            throw Obj2SstBase.raiseTypeError(ErrorMessages.AST_IDENTIFIER_MUST_BE_OF_TYPE_STR, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConstantValue obj2ConstantValue(Object obj) {
        if (obj == PNone.NONE) {
            return ConstantValue.NONE;
        }
        if (obj == PEllipsis.INSTANCE) {
            return ConstantValue.ELLIPSIS;
        }
        if (obj instanceof Boolean) {
            return ConstantValue.ofBoolean((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return ConstantValue.ofLong(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return ConstantValue.ofLong((Long)obj);
        }
        if (obj instanceof PInt && PGuards.isBuiltinPInt((PInt)obj)) {
            BigInteger v = ((PInt)obj).getValue();
            if (PInt.bigIntegerFitsInLong(v)) {
                return ConstantValue.ofLong(v.longValue());
            }
            return ConstantValue.ofBigInteger(v);
        }
        if (obj instanceof Double) {
            return ConstantValue.ofDouble((Double)obj);
        }
        if (obj instanceof PFloat && PyFloatCheckExactNode.executeUncached(obj)) {
            return ConstantValue.ofDouble(((PFloat)obj).getValue());
        }
        if (obj instanceof PComplex && PyComplexCheckExactNode.executeUncached(obj)) {
            PComplex c = (PComplex)obj;
            return ConstantValue.ofComplex(c.getReal(), c.getImag());
        }
        if (obj instanceof TruffleString) {
            return ConstantValue.ofRaw(obj);
        }
        if (obj instanceof PString && PyUnicodeCheckExactNode.executeUncached(obj)) {
            return ConstantValue.ofRaw(((PString)obj).getValueUncached());
        }
        if (obj instanceof PBytes && PyBytesCheckExactNode.executeUncached(obj)) {
            Object buf = PythonBufferAcquireLibrary.getUncached().acquireReadonly(obj);
            PythonBufferAccessLibrary accessLib = (PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().getUncached(buf);
            try {
                ConstantValue constantValue = ConstantValue.ofBytes(accessLib.getCopiedByteArray(buf));
                return constantValue;
            }
            finally {
                accessLib.release(buf);
            }
        }
        boolean isTuple = PyTupleCheckExactNode.executeUncached(obj);
        if (isTuple || PyFrozenSetCheckExactNode.executeUncached(obj)) {
            Object iter = PyObjectGetIter.executeUncached(obj);
            GetNextNode nextNode = GetNextNode.getUncached();
            ArrayList<ConstantValue> list = new ArrayList<ConstantValue>();
            try {
                while (true) {
                    list.add(this.obj2ConstantValue(nextNode.execute(iter)));
                }
            }
            catch (PException e) {
                e.expectStopIteration(null, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                if (isTuple) {
                    return ConstantValue.ofTuple((ConstantValue[])list.toArray(ConstantValue[]::new));
                }
                return ConstantValue.ofFrozenset((ConstantValue[])list.toArray(ConstantValue[]::new));
            }
        }
        throw Obj2SstBase.raiseTypeError(ErrorMessages.GOT_AN_INVALID_TYPE_IN_CONSTANT, obj);
    }

    static PException unexpectedNodeType(TruffleString expected, Object obj) {
        throw Obj2SstBase.raiseTypeError(ErrorMessages.EXPECTED_SOME_SORT_OF_S_BUT_GOT_S, expected, Obj2SstBase.repr(obj));
    }

    private static Object lookupAttr(Object o, TruffleString attrName) {
        return PyObjectLookupAttr.executeUncached(o, attrName);
    }

    private static TruffleString repr(Object o) {
        return PyObjectReprAsTruffleStringNode.executeUncached(o);
    }

    private static PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
        throw PRaiseNode.getUncached().raise(type, format, arguments);
    }

    static PException raiseTypeError(TruffleString format, Object ... arguments) {
        throw Obj2SstBase.raise(PythonBuiltinClassType.TypeError, format, arguments);
    }

    private static PException raiseValueError(TruffleString format, Object ... arguments) {
        throw Obj2SstBase.raise(PythonBuiltinClassType.ValueError, format, arguments);
    }

    @FunctionalInterface
    static interface Conversion<T> {
        public T convert(Object var1);
    }
}

